/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.purchases;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.group.model.logs.purchases.LogResourcePoints;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.string.StringUtils;

public class LogOutpostItemPurchase
extends LogResourcePoints {
    private SimpleLocation location;
    private Map<String, Purchase> purchases;
    private static final Namespace NS = Namespace.kingdoms("OUTPOST_ITEM_PURCHASE");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogOutpostItemPurchase();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    protected LogOutpostItemPurchase() {
    }

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    public LogOutpostItemPurchase(SimpleLocation location, long resourcePoints, UUID player, Map<String, Purchase> purchases) {
        super(resourcePoints, player);
        this.location = location;
        this.purchases = purchases;
    }

    public Map<String, Purchase> getPurchases() {
        return this.purchases;
    }

    public SimpleLocation getLocation() {
        return this.location;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.location = json.get("location").asSimpleLocation();
        this.purchases = json.get("purchases").asMap(new HashMap(), (m, k, v) -> {
            String key = k.asString();
            int amount = v.getInt("amount");
            long rp = v.getLong("resourcePoints");
            m.put(key, new Purchase(key, amount, rp));
        });
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.get("location").setSimpleLocation(this.location);
        json.get("purchases").setMap(this.purchases, (key, keyProvider, value) -> {
            keyProvider.setString((String)key);
            SectionableDataSetter valueProvider = keyProvider.getValueProvider().createSection();
            valueProvider.setInt("amount", ((Purchase)value).amount);
            valueProvider.setLong("resourcePoints", ((Purchase)value).resourcePointsCost);
        });
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        builder.raw("location", LocationUtils.parseLocation(this.location));
        builder.parse("purchases", this.purchases.values().stream().map(x -> "{$sep}\u26ab {$p}" + ((Purchase)x).name + "{$sep}: {$s}x" + ((Purchase)x).amount + " {$sep}- {$s}" + StringUtils.toFancyNumber(((Purchase)x).resourcePointsCost)).collect(Collectors.joining("\n")));
    }

    public static final class Purchase {
        private final String name;
        private final int amount;
        private final long resourcePointsCost;

        public Purchase(String name, int amount, long resourcePointsCost) {
            this.name = name;
            this.amount = amount;
            this.resourcePointsCost = resourcePointsCost;
        }

        public long getResourcePointsCost() {
            return this.resourcePointsCost;
        }

        public int getAmount() {
            return this.amount;
        }

        public String getName() {
            return this.name;
        }
    }
}

