/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable;

import org.kingdoms.config.EnumConfig;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.upgradable.StandardKingdomUpgrade;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.Masswar;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.string.StringUtils;

public enum MiscUpgrade implements StandardKingdomUpgrade
{
    ANTI_EXPLOSION,
    ANTI_TRAMPLE,
    NEXUS_GUARDS,
    GUARDS,
    INSANITY,
    GLORY,
    CHEST_SIZE(false),
    MAX_MEMBERS(false),
    MAX_TURRETS(false),
    MAX_CLAIMS(false),
    INVASION_TELEPORTATION,
    INVASIONS(false);

    public static final MiscUpgrade[] VALUES;
    private final boolean canBeDisabled;

    private MiscUpgrade() {
        this(true);
    }

    private MiscUpgrade(boolean canBeDisabled) {
        this.canBeDisabled = canBeDisabled;
    }

    public boolean canBeDisabled() {
        return this.canBeDisabled;
    }

    @Override
    public String getDataName() {
        return this.name();
    }

    public YamlConfigAccessor getConfig() {
        ConfigSection defaults = KingdomsConfig.MISC_UPGRADE.getDefaults().getSection(StringUtils.configOption(this));
        return new YamlConfigAccessor(KingdomsConfig.MISC_UPGRADE.getConfig().getSection(StringUtils.configOption(this)), defaults);
    }

    public String toString() {
        return StringUtils.capitalize(this.name());
    }

    @Override
    public boolean isEnabled(PlaceholderContextProvider placeholderProvider) {
        if (Masswar.isRunning() && KingdomsConfig.Invasions.MASSWAR_DISABLE_MISC_UPGRADES.getManager().getStringList().contains(StringUtils.configOption(this))) {
            return false;
        }
        return StandardKingdomUpgrade.super.isEnabled(placeholderProvider);
    }

    @Override
    public EnumConfig getEnabledOption() {
        return KingdomsConfig.MiscUpgrades.ENABLED;
    }

    @Override
    public EnumConfig getScalingOption() {
        return KingdomsConfig.MiscUpgrades.SCALING;
    }

    @Override
    public EnumConfig getUpgradeCostOption() {
        return KingdomsConfig.MiscUpgrades.COST;
    }

    @Override
    public EnumConfig getMaxLevelOption() {
        return KingdomsConfig.MiscUpgrades.MAX_LEVEL;
    }

    @Override
    public EnumConfig getDefaultLevelOption() {
        return KingdomsConfig.MiscUpgrades.DEFAULT_LEVEL;
    }

    @Override
    public Messenger getDisplayName() {
        return new LanguageEntryMessenger("upgrades", "misc", StringUtils.configOption(this.name()), "name");
    }

    static {
        VALUES = MiscUpgrade.values();
    }
}

