/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable;

import org.kingdoms.config.EnumConfig;
import org.kingdoms.constants.group.upgradable.KingdomUpgrade;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.string.StringUtils;

public interface StandardKingdomUpgrade
extends KingdomUpgrade {
    public EnumConfig getEnabledOption();

    public EnumConfig getScalingOption();

    public EnumConfig getUpgradeCostOption();

    public EnumConfig getMaxLevelOption();

    public EnumConfig getDefaultLevelOption();

    @Override
    default public double getScaling(PlaceholderContextProvider placeholderProvider) {
        return this.eval(this.getScalingOption(), placeholderProvider);
    }

    default public double eval(EnumConfig config, PlaceholderContextProvider placeholderProvider) {
        MathCompiler.Expression expr = config.getManager().withOption("upgrade", StringUtils.configOption(this.getDataName())).getMathExpression();
        return MathUtils.eval(expr, placeholderProvider);
    }

    @Override
    default public boolean isEnabled(PlaceholderContextProvider placeholderProvider) {
        return this.getEnabledOption().getManager().withOption("upgrade", StringUtils.configOption(this.getDataName())).getBoolean();
    }

    default public boolean isEnabled() {
        return this.isEnabled(null);
    }

    @Override
    default public double getUpgradeCost(PlaceholderContextProvider placeholders) {
        return this.eval(this.getUpgradeCostOption(), placeholders);
    }

    @Override
    default public int getMaxLevel(PlaceholderContextProvider placeholders) {
        return (int)this.eval(this.getMaxLevelOption(), placeholders);
    }

    @Override
    public String getDataName();

    @Override
    default public int getDefaultLevel(PlaceholderContextProvider placeholders) {
        return this.getDefaultLevelOption() == null ? 0 : (int)this.eval(this.getDefaultLevelOption(), placeholders);
    }
}

