/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.chunkrestoration.ChunkSnapshotManager;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.utils.LandUtil;
import org.kingdoms.utils.NationZone;
import org.kingdoms.utils.internal.FastUUID;

public class Land
extends KingdomsObject<SimpleChunkLocation> {
    private final transient @NonNull Map<UUID, Invasion> invasions = new ConcurrentHashMap<UUID, Invasion>();
    private @NonNull Map<SimpleLocation, Turret> turrets = new HashMap<SimpleLocation, Turret>();
    private @NonNull Map<SimpleLocation, ProtectionSign> protectedBlocks = new HashMap<SimpleLocation, ProtectionSign>();
    private @NonNull Map<SimpleLocation, Structure> structures = new HashMap<SimpleLocation, Structure>();
    private final transient SimpleChunkLocation location;
    private @Nullable UUID kingdom;
    private @Nullable UUID claimedBy;
    private long since;

    public Land(@NonNull SimpleChunkLocation location, @Nullable UUID kingdom, @Nullable UUID claimedBy, @NonNull Map<SimpleLocation, Structure> structures, @NonNull Map<SimpleLocation, Turret> turrets, @NonNull Map<SimpleLocation, ProtectionSign> protectedBlocks, long since) {
        this.location = location;
        this.turrets = Objects.requireNonNull(turrets, "Turrets cannot be null");
        this.protectedBlocks = Objects.requireNonNull(protectedBlocks, "Protected blocks cannot be null");
        this.structures = Objects.requireNonNull(structures, "Structures cannot be null");
        this.kingdom = kingdom;
        this.claimedBy = claimedBy;
        this.since = since;
    }

    public Land(@NonNull Kingdom kingdom, @NonNull SimpleChunkLocation chunk) {
        this(kingdom.getId(), chunk);
    }

    public Land(@Nullable UUID kingdom, @NonNull SimpleChunkLocation chunk) {
        if (Land.getLand(chunk) != null) {
            throw new NullPointerException("Cannot construct a new land object for " + chunk + " for kingdom " + kingdom + " becuase it already exists.");
        }
        this.location = chunk;
        this.kingdom = kingdom;
        this.since = System.currentTimeMillis();
        KingdomsDataCenter.get().getLandManager().load(this);
    }

    public Land(@NonNull SimpleChunkLocation chunk) {
        this((UUID)null, chunk);
    }

    public static @Nullable Land getLand(@NonNull Location location) {
        return Land.getLand(SimpleChunkLocation.of(location));
    }

    public static @Nullable Land getLand(@NonNull Chunk chunk) {
        return Land.getLand(SimpleChunkLocation.of(chunk));
    }

    public static @Nullable Land getLand(@NonNull Block block) {
        return SimpleChunkLocation.of(block).getLand();
    }

    public static @Nullable Land getLand(@NonNull SimpleChunkLocation loc) {
        return (Land)KingdomsDataCenter.get().getLandManager().getData(loc);
    }

    public static @Nullable Land getLand(@NonNull SimpleLocation loc) {
        return Land.getLand(loc.toSimpleChunkLocation());
    }

    public static @Nullable NationZone getNationZone(SimpleChunkLocation chunk) {
        int radius = KingdomsConfig.Invasions.NATIONS_NATION_ZONE_RADIUS.getManager().getInt();
        if (radius < 1) {
            return null;
        }
        Land mainLand = chunk.getLand();
        if (mainLand != null && mainLand.isClaimed()) {
            return null;
        }
        return chunk.findFromSurroundingChunks(radius, c -> {
            Land land = c.getLand();
            if (land == null) {
                return null;
            }
            Kingdom kingdom = land.getKingdom();
            if (kingdom == null) {
                return null;
            }
            Nation nation = kingdom.getNation();
            if (nation != null && nation.getCapitalId().equals(kingdom.getId())) {
                return new NationZone(nation, kingdom, land);
            }
            return null;
        });
    }

    public static Land validateDistance(SimpleChunkLocation chunk, UUID kingdom) {
        int distance = KingdomsConfig.Claims.DISTANCE.getManager().getInt();
        if (distance <= 0) {
            return null;
        }
        return chunk.findFromSurroundingChunks(distance, c -> {
            Land land = c.getLand();
            if (land != null && land.isClaimed() && !FastUUID.equals(land.kingdom, kingdom)) {
                return land;
            }
            return null;
        });
    }

    public static boolean isConnected(SimpleChunkLocation chunk, Kingdom kingdom) {
        if (kingdom.getLandLocations().isEmpty()) {
            return true;
        }
        int radius = KingdomsConfig.Claims.CONNECTION_RADIUS.getManager().getInt();
        if (radius <= 0) {
            return true;
        }
        return Land.isConnected(chunk, kingdom, radius);
    }

    public static boolean disconnectsLandsAfterUnclaim(SimpleChunkLocation unclaimed, Kingdom kingdom) {
        int radius = KingdomsConfig.Claims.CONNECTION_RADIUS.getManager().getInt();
        if (radius <= 0) {
            return false;
        }
        Set<SimpleChunkLocation> landsInWorld = kingdom.getLandLocations().stream().filter(x -> x.getWorld().equals(unclaimed.getWorld()) && !x.equalsIgnoreWorld(unclaimed)).collect(Collectors.toSet());
        if (landsInWorld.size() == 1) {
            return false;
        }
        return LandUtil.getConnectedClusters(radius, landsInWorld).size() > 1;
    }

    public static boolean isConnected(SimpleChunkLocation chunk, Kingdom kingdom, int radius) {
        String world = chunk.getWorld();
        if (chunk.findFromSurroundingChunks(radius, kingdom::isClaimed) != null) {
            return true;
        }
        return kingdom.getLandLocations().stream().noneMatch(x -> x.getWorld().equals(world));
    }

    public boolean isHomeLand() {
        Kingdom kingdom = this.getKingdom();
        if (kingdom == null) {
            return false;
        }
        Location home = kingdom.getHome();
        if (home == null) {
            return false;
        }
        return SimpleChunkLocation.of(home).equals(this.location);
    }

    public boolean isClaimed() {
        return this.kingdom != null;
    }

    public boolean isNexusLand() {
        return this.getStructure((Structure structure) -> ((StructureType)((StructureStyle)structure.getStyle()).getType()).isNexus()) != null;
    }

    public Structure getStructure(@NonNull Predicate<Structure> predicate) {
        for (Structure value : this.structures.values()) {
            if (!predicate.test(value)) continue;
            return value;
        }
        return null;
    }

    public <T extends Structure> T getStructure(@NonNull Class<T> type) {
        return (T)this.getStructure(type::isInstance);
    }

    public int hashCode() {
        int prime = 31;
        int result = 19;
        result = prime * result + this.location.hashCode();
        if (this.kingdom != null) {
            result = prime * result + this.kingdom.hashCode();
        }
        if (this.claimedBy != null) {
            result = prime * result + this.claimedBy.hashCode();
        }
        result = prime * result + this.structures.hashCode();
        result = prime * result + this.turrets.hashCode();
        result = prime * result + this.protectedBlocks.hashCode();
        result = prime * result + Long.hashCode(this.since);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Land)) {
            return false;
        }
        Land land = (Land)obj;
        return this.location.equals(land.location) && Objects.equals(this.kingdom, land.kingdom) && this.since == land.since && Objects.equals(this.claimedBy, land.claimedBy) && this.structures.equals(land.structures) && this.turrets.equals(land.turrets) && this.protectedBlocks.equals(land.protectedBlocks);
    }

    public boolean simpleEquals(@Nullable Land land) {
        return land != null && (this == land || this.location.equals(land.location));
    }

    public UnclaimLandEvent unclaim(@Nullable KingdomPlayer by, UnclaimLandEvent.Reason reason) {
        return this.unclaim(by, reason, true);
    }

    public UnclaimLandEvent unclaim(@Nullable KingdomPlayer by, UnclaimLandEvent.Reason reason, boolean history) {
        Kingdom kingdom = Objects.requireNonNull(this.getKingdom(), () -> "Cannot unclaim " + this.location + " it wasn't claimed by a kingdom");
        return kingdom.unclaim(Collections.singleton(this.location), by, reason, history);
    }

    public void silentUnclaim() {
        for (Structure structure : this.structures.values().toArray(new Structure[0])) {
            if (!KingdomsConfig.Structures.REMOVE_UNCLAIMED.getManager().getBoolean() && !((StructureType)((StructureStyle)structure.getStyle()).getType()).isNexus() || this.kingdom == null) continue;
            structure.remove(new KingdomItemRemoveContext());
        }
        if (KingdomsConfig.Claims.RESTORATION_ENABLED.getManager().getBoolean()) {
            ChunkSnapshotManager.queueRestoration(this.location);
        }
        this.kingdom = null;
        this.since = System.currentTimeMillis();
        this.claimedBy = null;
        if (this.structures.isEmpty() && this.turrets.isEmpty() && this.protectedBlocks.isEmpty() && this.metadata.isEmpty()) {
            Kingdoms.get().getDataCenter().getLandManager().delete(this.location);
        }
    }

    public @NonNull SimpleChunkLocation getLocation() {
        return this.location;
    }

    @Override
    public @NonNull SimpleChunkLocation getDataKey() {
        return this.location;
    }

    public String toString() {
        return "Land:{" + this.location + '}';
    }

    @Override
    public @NonNull String getCompressedData() {
        return Land.compressUUID(this.kingdom) + Land.compressUUID(this.claimedBy) + this.since + Land.compressCollecton(this.structures.values(), KingdomItem::hashCode) + Land.compressCollecton(this.turrets.values(), KingdomItem::hashCode) + Land.compressCollecton(this.protectedBlocks.values(), ProtectionSign::getCompressedData) + this.compressMetadata();
    }

    public @Nullable Kingdom getKingdom() {
        if (this.kingdom == null) {
            return null;
        }
        Kingdom kingdomInstance = Kingdom.getKingdom(this.kingdom);
        if (kingdomInstance == null) {
            MessageHandler.sendConsolePluginMessage("&4Invalid kingdom data for land &e" + this.location + " &4removing its data...");
            this.kingdom = null;
            this.silentUnclaim();
        }
        return kingdomInstance;
    }

    public void setKingdom(@Nullable UUID kingdom) {
        this.kingdom = kingdom;
    }

    public boolean isBeingInvaded() {
        return !this.invasions.isEmpty();
    }

    public @Nullable UUID getKingdomId() {
        return this.kingdom;
    }

    public @NonNull Map<SimpleLocation, Structure> getStructures() {
        return this.structures;
    }

    public @Nullable UUID getClaimedBy() {
        return this.claimedBy;
    }

    public void setClaimedBy(@Nullable UUID claimedBy) {
        this.claimedBy = claimedBy;
    }

    public @Nullable KingdomPlayer getClaimer() {
        return this.claimedBy == null ? null : KingdomPlayer.getKingdomPlayer(this.claimedBy);
    }

    public @Nullable Map<UUID, Invasion> getInvasions() {
        return Collections.unmodifiableMap(this.invasions);
    }

    public void addInvasion(@NonNull Invasion invasion) {
        UUID id = invasion.getInvader().getKingdomId();
        if (this.invasions.containsKey(id)) {
            throw new IllegalArgumentException("The kingdom with ID " + id + " is already invading land at " + this.location + " conflicting between: " + invasion.getInvaderPlayer().getName() + " and " + this.invasions.get(id).getInvaderPlayer().getName());
        }
        if (!invasion.getAffectedLands().contains(this.location)) {
            throw new IllegalArgumentException("The provided invasion isn't affecting this land: " + invasion.getAffectedLands());
        }
        this.invasions.put(id, invasion);
    }

    public void endInvasions(Invasion.Result result) {
        this.invasions.values().forEach(i -> i.end(result));
    }

    public Invasion removeInvasion(@NonNull Kingdom kingdom) {
        return this.removeInvasion(kingdom.getId());
    }

    public Invasion removeInvasion(@NonNull UUID kingdom) {
        return this.invasions.remove(kingdom);
    }

    public @NonNull Map<SimpleLocation, ProtectionSign> getProtectedBlocks() {
        return this.protectedBlocks;
    }

    public void setProtectedBlocks(@NonNull Map<SimpleLocation, ProtectionSign> protectedBlocks) {
        this.protectedBlocks = protectedBlocks;
    }

    public @NonNull Map<SimpleLocation, Turret> getTurrets() {
        return this.turrets;
    }

    public void setTurrets(@NonNull Map<SimpleLocation, Turret> turrets) {
        this.turrets = turrets;
    }

    public long getSince() {
        return this.since;
    }

    public void setSince(long since) {
        this.since = since;
    }
}

