/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.bukkit.entity.EntityType;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KeyedConfigAccessor;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.utils.cache.EnumCache;
import org.kingdoms.utils.config.ConfigPath;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;

public class TurretStyle
extends KingdomItemStyle<Turret, TurretStyle, TurretType> {
    private final YamlResource adapter;
    private Set<EntityType> allowedEntityTypes;
    private boolean needsAmmo;

    public TurretStyle(String name, YamlResource adapter) {
        super(name, TurretRegistry.getType(adapter.getConfig().getString("type")));
        this.adapter = Objects.requireNonNull(adapter, "Turret style config adapter cannot be null");
    }

    @Override
    public @NonNull KeyedConfigAccessor getOption(String ... option) {
        return new KeyedYamlConfigAccessor(this.adapter, new ConfigPath(option)).noDefault();
    }

    public Set<EntityType> getAllowedEntityTypes() {
        return this.allowedEntityTypes;
    }

    public YamlResource getAdapter() {
        return this.adapter;
    }

    public boolean needsAmmo() {
        return this.needsAmmo;
    }

    @Override
    public void loadSettings() {
        super.loadSettings();
        ConfigAccessor entities = this.getOption("entities").getSection();
        if (entities != null) {
            boolean whitelist = entities.getBoolean("whitelist");
            this.allowedEntityTypes = whitelist ? new QuickEnumSet((Enum[])EnumCache.ENTITY_TYPES) : QuickEnumSet.allOf((Enum[])EnumCache.ENTITY_TYPES);
            for (String element : entities.getStringList("list")) {
                Optional type = Enums.getIfPresent(EntityType.class, (String)element.toUpperCase(Locale.ENGLISH));
                if (!type.isPresent()) continue;
                if (whitelist) {
                    this.allowedEntityTypes.add((EntityType)type.get());
                    continue;
                }
                this.allowedEntityTypes.remove(type.get());
            }
        } else {
            this.allowedEntityTypes = QuickEnumSet.allOf((Enum[])EnumCache.ENTITY_TYPES);
        }
        this.needsAmmo = !"0".equals(this.getOption("max-ammo").getString());
    }
}

