/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.objects;

import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.objects.TargetedRangedTurret;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.Laser;

public class InfernoTurret
extends TargetedRangedTurret {
    protected transient int phase = 0;
    protected transient double damage;
    protected transient Laser laser;

    public InfernoTurret(TurretStyle type, SimpleLocation location) {
        super(type, location);
    }

    @Override
    public void activate(LivingEntity target, Kingdom kingdom) {
        super.activate(target, kingdom);
        if (this.target != null && this.target == target) {
            int n;
            ++this.phase;
            if ((double)n >= this.getDamageModifierPhases(kingdom, this.level)) {
                this.phase = 0;
                this.damage += this.getDamageModifier(kingdom);
            }
        } else {
            this.damage = this.getDamage(kingdom);
            this.target = target;
        }
        this.startLaser();
        target.damage(this.getDamage(kingdom) + this.damage);
    }

    @Override
    public KingdomItemBreakEvent<?> remove(KingdomItemRemoveContext context) {
        if (this.laser != null && this.laser.isStarted()) {
            this.laser.stop();
        }
        return super.remove(context);
    }

    public double getDamageModifier(Kingdom kingdom) {
        return this.getDamageModifier(kingdom, this.level);
    }

    public double getDamageModifier(Kingdom kingdom, int lvl) {
        return this.eval("damage-modifier", kingdom, lvl);
    }

    public double getDamageModifierPhases(Kingdom kingdom, int lvl) {
        return this.eval("damage-modifier-phases", kingdom, lvl);
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public Laser getLaser() {
        return this.laser;
    }

    public void setLaser(Laser laser) {
        this.laser = laser;
    }

    private Location endLocationSupplier() {
        if (this.target == null || this.target.isDead() || !this.target.isValid()) {
            return null;
        }
        Location location = this.target.getEyeLocation().add(0.0, -0.75, 0.0);
        Location start = this.location.toBukkitLocation().add(0.5, 0.0, 0.5);
        return location.add(location.toVector().subtract(start.toVector()).normalize().multiply(-1.5));
    }

    public void startLaser() {
        if (this.laser == null) {
            try {
                this.laser = new Laser(this.location.toBukkitLocation().add(0.5, 0.0, 0.5), this::endLocationSupplier, -1, 15);
                this.laser.start((Plugin)Kingdoms.get());
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
            return;
        }
        if (!this.laser.isStarted()) {
            this.laser.start((Plugin)Kingdoms.get());
        }
    }

    @Override
    public boolean checkup() {
        if (this.isOutOfAmmo()) {
            this.stop();
        }
        return super.checkup();
    }

    @Override
    public boolean targetCheckup(LivingEntity target) {
        boolean checkup = super.targetCheckup(target);
        if (!checkup) {
            checkup = this.target != null && this.target != target;
        }
        return checkup;
    }

    public void stop() {
        if (this.target == null) {
            return;
        }
        if (this.laser != null && this.laser.isStarted()) {
            this.laser.stop();
        }
        this.target = null;
        this.phase = 0;
    }
}

