/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.objects;

import com.google.common.base.Enums;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.ChairManager;
import org.kingdoms.utils.nbt.NBTTagCompound;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;

public class RangedTurret
extends Turret
implements PlayerOperator {
    private Player operator;
    private boolean manual;
    private transient int cooldown;
    private int ammo;
    private static final boolean ADVANCED_ARROWS = XMaterial.supports(14);
    public static final String ORIGIN_METADATA = "TURRET_ORIGIN";
    public static final String ORIGIN_KINGDOM = "TURRET_KINGDOM";

    public RangedTurret(TurretStyle type, SimpleLocation location) {
        super(type, location);
    }

    public int getAmmo() {
        return this.ammo;
    }

    public void setAmmo(int ammo) {
        this.ammo = ammo;
    }

    public void postActivation(Kingdom kingdom) {
        if (((TurretStyle)this.style).needsAmmo()) {
            --this.ammo;
        }
        this.cooldown = this.getCooldown(kingdom, this.level);
    }

    public boolean isOutOfAmmo() {
        return ((TurretStyle)this.style).needsAmmo() && this.ammo <= 0;
    }

    public int addAmmo(int amount) {
        return this.ammo += amount;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + super.hashCode();
        result = prime * result + this.cooldown;
        result = prime * result + this.ammo;
        return result;
    }

    public EntityType getProjectile() {
        ConfigAccessor section = ((TurretStyle)this.style).getOption("projectile").getSection();
        if (section == null) {
            return null;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level);
        String projectile = section.getString(String.valueOf(entry));
        return (EntityType)Enums.getIfPresent(EntityType.class, (String)projectile).or((Object)EntityType.ARROW);
    }

    public double getSpeed(Kingdom kingdom) {
        return this.getSpeed(kingdom, this.level);
    }

    public double getSpeed(Kingdom kingdom, int lvl) {
        return this.eval("speed", kingdom, lvl);
    }

    @Override
    public boolean checkup() {
        return super.checkup() || this.tick() > 0 || this.isOutOfAmmo();
    }

    public int passThroughLevel(Kingdom kingdom) {
        return (int)this.eval("pass-through", kingdom, this.level);
    }

    public boolean canPassThrough(Kingdom kingdom) {
        int passThroLevel = this.passThroughLevel(kingdom);
        return passThroLevel != 0 && this.level >= passThroLevel;
    }

    @Override
    public boolean targetCheckup(LivingEntity target) {
        return this.isOutOfAmmo() || super.targetCheckup(target);
    }

    @Override
    public Pair<ItemStack, NBTTagCompound> getTags() {
        Pair<ItemStack, NBTTagCompound> pair = super.getTags();
        if (pair == null) {
            return null;
        }
        NBTWrappers.NBTTagCompound tag = (NBTWrappers.NBTTagCompound)pair.getValue();
        tag = tag.getCompound("Kingdoms");
        if (((TurretStyle)this.style).needsAmmo() && this.ammo != 0) {
            tag.set("Ammo", NBTType.INTEGER, this.ammo);
        }
        return pair;
    }

    @Override
    public void setDataFromNBT(NBTTagCompound tag) {
        super.setDataFromNBT(tag);
        Integer ammo = tag.get("Ammo", NBTType.INTEGER);
        this.ammo = ammo == null ? 0 : ammo;
    }

    public void setOperator(Player operator) {
        this.operator = operator;
    }

    public Player getOperator() {
        return this.operator;
    }

    @Override
    public MessageBuilder getEdits(Kingdom kingdom) {
        return super.getEdits(kingdom).raw("ammo", this.ammo).raw("manual", this.manual).raw("speed", this.round(this.getSpeed(kingdom))).raw("next_speed", this.round(this.getSpeed(kingdom, this.level + 1))).raw("range", this.round(this.getRange(kingdom))).raw("next_range", this.round(this.getRange(kingdom, this.level + 1))).raw("max_targets", this.getMaxTargets(kingdom)).raw("next_max_targets", this.getMaxTargets(kingdom, this.level + 1)).raw("max_ammo", this.getMaxAmmo(kingdom)).raw("next_max_ammo", this.getMaxAmmo(kingdom, this.level + 1)).raw("cooldown", this.getCooldown(kingdom)).raw("next_cooldown", this.getCooldown(kingdom, this.level + 1)).raw("knockback", this.round(this.getKnockback(kingdom))).raw("next_knockback", this.round(this.getKnockback(kingdom, this.level + 1)));
    }

    @Override
    public KingdomItemBreakEvent<?> remove(KingdomItemRemoveContext context) {
        if (this.operator != null) {
            ChairManager.standUp((Entity)this.operator);
        }
        return super.remove(context);
    }

    public double getRange(Kingdom kingdom, int lvl) {
        return this.eval("range", kingdom, lvl);
    }

    public double getRange(Kingdom kingdom) {
        return this.getRange(kingdom, this.level);
    }

    public int getCooldown(Kingdom kingdom, int lvl) {
        return (int)this.eval("cooldown", kingdom, lvl);
    }

    public int getCooldown(Kingdom kingdom) {
        return this.getCooldown(kingdom, this.level);
    }

    public int getAmmoCost(Kingdom kingdom) {
        return (int)this.eval("ammo", kingdom, this.level);
    }

    public int getMaxAmmo(Kingdom kingdom) {
        return this.getMaxAmmo(kingdom, this.level);
    }

    public int getMaxAmmo(Kingdom kingdom, int lvl) {
        return (int)this.eval("max-ammo", kingdom, lvl);
    }

    public int getMaxTargets(Kingdom kingdom, int lvl) {
        return (int)this.eval("max-targets", kingdom, lvl);
    }

    public int getMaxTargets(Kingdom kingdom) {
        return this.getMaxTargets(kingdom, this.level);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public int tick() {
        return --this.cooldown;
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        if (((TurretStyle)this.style).needsAmmo()) {
            context.getDataProvider().setInt("ammo", this.ammo);
        }
        if (this.manual) {
            context.getDataProvider().setBoolean("manual", this.manual);
        }
    }

    public Entity shootEntity(EntityType type, Kingdom kingdom, Location from, Vector direction) {
        Entity projectile;
        double speed = this.getSpeed(kingdom);
        World world = this.location.getBukkitWorld();
        if (type == EntityType.ARROW || type == EntityType.SPECTRAL_ARROW) {
            if (ADVANCED_ARROWS) {
                Class classType = type == EntityType.SPECTRAL_ARROW ? SpectralArrow.class : Arrow.class;
                projectile = world.spawnArrow(from, direction, (float)speed, 3.0f, classType);
            } else {
                projectile = world.spawnArrow(from, direction, (float)speed, 3.0f);
            }
        } else {
            projectile = world.spawnEntity(from, type);
            projectile.setVelocity(projectile.getVelocity().multiply(speed));
        }
        if (this.canSetOnFire(kingdom)) {
            projectile.setFireTicks(1200);
        }
        this.repeatedParticle(this, projectile);
        RangedTurret.setMetadata(projectile, this, kingdom);
        return projectile;
    }

    protected static void setMetadata(Entity entity, RangedTurret turret, Kingdom kingdom) {
        entity.setMetadata(ORIGIN_METADATA, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)turret));
        entity.setMetadata(ORIGIN_KINGDOM, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)kingdom));
    }

    public void repeatedParticle(Turret turret, final Entity entity) {
        final ParticleDisplay display = turret.getParticle();
        if (display == null) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                if (!entity.isValid()) {
                    this.cancel();
                    return;
                }
                display.spawn(entity.getLocation());
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 1L);
    }

    public boolean isManual() {
        return this.manual;
    }

    public void setManual(boolean manual) {
        this.manual = manual;
    }

    @Override
    @Nullable
    public KingdomPlayer getPlayer() {
        return KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.operator);
    }
}

