/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.types;

import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.constants.land.turrets.types.TurretTypeRanged;
import org.kingdoms.data.Pair;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;

public class TurretArrow
extends TurretTypeRanged {
    private static final boolean ADVANCED_ARROWS = XMaterial.supports(14);

    public TurretArrow() {
        super("arrow", true, false);
    }

    @Override
    public boolean activate(TurretActivateEvent event) {
        Vector direction;
        Pair<Location, Vector> dir = this.shootingDirection(event);
        Location from = dir.getKey();
        if (this.cantReachTarget(event, from, direction = dir.getValue())) {
            return false;
        }
        if (TurretArrow.call(event)) {
            return false;
        }
        Kingdom kingdom = event.getKingdom();
        RangedTurret turret = (RangedTurret)event.getTurret();
        EntityType type = turret.getProjectile();
        LivingEntity target = event.getTarget();
        if (type != null) {
            turret.shootEntity(type, kingdom, from, direction);
        } else {
            ParticleDisplay particle;
            turret.activate(target, kingdom);
            double damage = turret.getDamage(kingdom);
            if (damage > 0.0) {
                target.damage(damage);
            }
            if ((particle = turret.getParticle()) != null) {
                XParticle.line(from.clone().add(0.0, 0.5, 0.0), target.getEyeLocation().add(0.0, -0.25, 0.0), 0.1, particle);
            }
            if (turret.canSetOnFire(kingdom)) {
                target.setFireTicks(100);
            }
        }
        return true;
    }
}

