/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.types;

import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.MineTurret;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;

public class TurretPressureMine
extends TurretType {
    public TurretPressureMine() {
        super("pressure_mine", true, false);
    }

    @Override
    public boolean activate(TurretActivateEvent event) {
        LivingEntity target = event.getTarget();
        MineTurret mine = (MineTurret)event.getTurret();
        mine.applyKnockback(target, event.getKingdom());
        @NonNull List<PotionEffect> effects = mine.getEffects();
        target.addPotionEffects(effects);
        if (((TurretStyle)mine.getStyle()).getOption("lingering").getBoolean()) {
            MineTurret.spawnLingeringPotion(mine.getLocation().toBukkitLocation(), effects);
        }
        mine.createExplosion(mine.getLocation().toBukkitLocation(), event.getKingdom());
        mine.damage(event);
        return true;
    }

    @Override
    public Turret build(KingdomItemBuilder<Turret, TurretStyle, TurretType> builder) {
        return new MineTurret(builder.getStyle(), builder.getLocation());
    }
}

