/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.types;

import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.data.Pair;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.libs.xseries.ReflectionUtils;

public abstract class TurretTypeRanged
extends TurretType {
    public TurretTypeRanged(String name, boolean enemies, boolean friends) {
        super(name, enemies, friends);
    }

    public boolean cantReachTarget(TurretActivateEvent event, Location from, Vector direction) {
        return this.cantReachTarget((RangedTurret)event.getTurret(), event.getKingdom(), from, (Entity)event.getTarget(), direction);
    }

    @Override
    public RangedTurret build(KingdomItemBuilder<Turret, TurretStyle, TurretType> builder) {
        return new RangedTurret(builder.getStyle(), builder.getLocation());
    }

    public boolean cantReachTarget(RangedTurret turret, Kingdom kingdom, Location from, Entity target, Vector direction) {
        if (!ReflectionUtils.supports(13)) {
            return false;
        }
        if (turret.canPassThrough(kingdom)) {
            return false;
        }
        RayTraceResult result = from.getWorld().rayTrace(from, direction, turret.getRange(kingdom), FluidCollisionMode.NEVER, true, 0.0, entity -> entity.getEntityId() == target.getEntityId());
        if (result == null) {
            return false;
        }
        return result.getHitBlock() != null;
    }

    public Pair<Location, Vector> shootingDirection(TurretActivateEvent event) {
        return this.shootingDirection(event.getOrigin(), event.getTarget().getEyeLocation());
    }

    public Pair<Location, Vector> shootingDirection(Location origin, Location target) {
        Vector to = target.toVector().add(new Vector(0.0, -0.25, 0.0));
        Location from = origin.clone().add(0.5, 0.0, 0.5);
        Vector direction = to.subtract(from.toVector()).normalize();
        from.add(direction.clone());
        return Pair.of(from, direction);
    }

    @Override
    public void deserialize(Turret item, DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(item, context);
        RangedTurret turret = (RangedTurret)item;
        turret.setAmmo(context.getDataProvider().getInt("ammo"));
    }
}

