/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.kingdoms.data.managers.KingdomManager;
import org.kingdoms.data.managers.NationManager;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;

public final class StartupCache {
    private static final List<Consumer<Kingdoms>> ON_LOAD = new ArrayList<Consumer<Kingdoms>>(10);
    private static boolean loaded = false;

    public static void whenLoaded(Consumer<Kingdoms> runnable) {
        Objects.requireNonNull(runnable, "Load consumer cannot be null");
        if (loaded) {
            runnable.accept(Kingdoms.get());
        } else {
            ON_LOAD.add(runnable);
        }
    }

    public static void init(Kingdoms plugin) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)plugin, () -> {
            plugin.getPermissionRegistery().lock();
            plugin.getRelationAttributeRegistry().lock();
            plugin.getAuditLogRegistry().lock();
            plugin.getMetadataRegistry().lock();
            StartupCache.loadNations(plugin);
            StartupCache.loadKingdoms(plugin);
            StartupCache.loadLands(plugin);
            loaded = true;
            for (Consumer<Kingdoms> runnable : ON_LOAD) {
                runnable.accept(plugin);
            }
        }, 20L);
    }

    private static void loadNations(Kingdoms plugin) {
        NationManager manager = plugin.getDataCenter().getNationManager();
        MessageHandler.sendConsolePluginMessage("&2Setting up nations data...");
        long start = System.currentTimeMillis();
        int loaded = manager.loadAllData();
        MessageHandler.sendConsolePluginMessage("&2Done, loaded a total of &6" + loaded + " &2nations. Took &6" + (System.currentTimeMillis() - start) + "ms");
    }

    private static void loadKingdoms(Kingdoms plugin) {
        KingdomManager manager = plugin.getDataCenter().getKingdomManager();
        MessageHandler.sendConsolePluginMessage("&2Setting up kingdoms data...");
        long start = System.currentTimeMillis();
        int loaded = manager.loadAllData();
        MessageHandler.sendConsolePluginMessage("&2Done, loaded a total of &6" + loaded + " &2kingdoms. Took &6" + (System.currentTimeMillis() - start) + "ms");
    }

    private static void loadLands(Kingdoms plugin) {
        MessageHandler.sendConsolePluginMessage("&2Loading lands data...");
        long start = System.currentTimeMillis();
        int loaded = plugin.getDataCenter().getLandManager().loadAllData();
        MessageHandler.sendConsolePluginMessage("&2Done, loaded a total of &6" + loaded + " &2lands. Took &6" + (System.currentTimeMillis() - start) + "ms");
    }
}

