/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.libs.hikari.HikariConfig;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.string.StringUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 :2\u00020\u0001:\u0001:B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0001J\u001f\u00104\u001a\u00020\n2\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000405\"\u00020\u0004\u00a2\u0006\u0002\u00106J\u000e\u00107\u001a\u0002012\u0006\u00108\u001a\u000209R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0006\"\u0004\b\u001c\u0010\bR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\f\"\u0004\b)\u0010\u000eR\u001a\u0010*\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0006\"\u0004\b,\u0010\bR\u001a\u0010-\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\f\"\u0004\b/\u0010\u000e\u00a8\u0006;"}, d2={"Lorg/kingdoms/data/database/sql/DatabaseProperties;", "", "()V", "address", "", "getAddress", "()Ljava/lang/String;", "setAddress", "(Ljava/lang/String;)V", "allowPublicKeyRetrieval", "", "getAllowPublicKeyRetrieval", "()Z", "setAllowPublicKeyRetrieval", "(Z)V", "databaseName", "getDatabaseName", "setDatabaseName", "ignoredProperties", "", "getIgnoredProperties", "()Ljava/util/Set;", "others", "", "getOthers", "()Ljava/util/Map;", "password", "getPassword", "setPassword", "port", "", "getPort", "()I", "setPort", "(I)V", "socketTimeout", "", "getSocketTimeout", "()J", "useSSL", "getUseSSL", "setUseSSL", "user", "getUser", "setUser", "verifyServerCertificate", "getVerifyServerCertificate", "setVerifyServerCertificate", "add", "", "name", "value", "ignore", "", "([Ljava/lang/String;)Z", "useStandardDataSourcePropertyAppendar", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "Companion", "core"})
public final class DatabaseProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public String user;
    public String password;
    public String address;
    private int port;
    public String databaseName;
    private boolean useSSL = true;
    private boolean verifyServerCertificate = true;
    private boolean allowPublicKeyRetrieval;
    private final long socketTimeout = Duration.ofSeconds(30L).toMillis();
    @NotNull
    private final Map<String, Object> others = new HashMap();
    @NotNull
    private final Set<String> ignoredProperties = new HashSet();
    @NotNull
    private static final DatabaseProperties DEFAULTS = new DatabaseProperties();
    private static boolean initialized;

    @NotNull
    public final String getUser() {
        String string = this.user;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"user");
        return null;
    }

    public final void setUser(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.user = string;
    }

    @NotNull
    public final String getPassword() {
        String string = this.password;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"password");
        return null;
    }

    public final void setPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.password = string;
    }

    @NotNull
    public final String getAddress() {
        String string = this.address;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"address");
        return null;
    }

    public final void setAddress(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.address = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getDatabaseName() {
        String string = this.databaseName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"databaseName");
        return null;
    }

    public final void setDatabaseName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.databaseName = string;
    }

    public final boolean getUseSSL() {
        return this.useSSL;
    }

    public final void setUseSSL(boolean bl) {
        this.useSSL = bl;
    }

    public final boolean getVerifyServerCertificate() {
        return this.verifyServerCertificate;
    }

    public final void setVerifyServerCertificate(boolean bl) {
        this.verifyServerCertificate = bl;
    }

    public final boolean getAllowPublicKeyRetrieval() {
        return this.allowPublicKeyRetrieval;
    }

    public final void setAllowPublicKeyRetrieval(boolean bl) {
        this.allowPublicKeyRetrieval = bl;
    }

    public final long getSocketTimeout() {
        return this.socketTimeout;
    }

    @NotNull
    public final Map<String, Object> getOthers() {
        return this.others;
    }

    @NotNull
    public final Set<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public final boolean ignore(String ... name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return CollectionsKt.addAll((Collection)this.ignoredProperties, (Object[])name);
    }

    public final void add(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.others.put(name, value);
    }

    public final void useStandardDataSourcePropertyAppendar(@NotNull HikariConfig hikariConfig) {
        Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
        DatabaseProperties.useStandardDataSourcePropertyAppendar$add(this, hikariConfig, "user", this.getUser());
        DatabaseProperties.useStandardDataSourcePropertyAppendar$add(this, hikariConfig, "password", this.getUser());
        DatabaseProperties.useStandardDataSourcePropertyAppendar$add(this, hikariConfig, "serverName", this.getAddress());
        DatabaseProperties.useStandardDataSourcePropertyAppendar$add(this, hikariConfig, "port", this.port);
        DatabaseProperties.useStandardDataSourcePropertyAppendar$add(this, hikariConfig, "portNumber", this.port);
        DatabaseProperties.useStandardDataSourcePropertyAppendar$add(this, hikariConfig, "databaseName", this.getDatabaseName());
        DatabaseProperties.useStandardDataSourcePropertyAppendar$add(this, hikariConfig, "useSSL", this.useSSL);
        DatabaseProperties.useStandardDataSourcePropertyAppendar$add(this, hikariConfig, "verifyServerCertificate", this.verifyServerCertificate);
        DatabaseProperties.useStandardDataSourcePropertyAppendar$add(this, hikariConfig, "allowPublicKeyRetrieval", this.allowPublicKeyRetrieval);
        DatabaseProperties.useStandardDataSourcePropertyAppendar$add(this, hikariConfig, "socketTimeout", this.socketTimeout);
        Map<String, Object> $this$forEach$iv = this.others;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> x = element$iv = iterator.next();
            boolean bl = false;
            DatabaseProperties.useStandardDataSourcePropertyAppendar$add(this, hikariConfig, x.getKey(), x.getValue());
        }
    }

    private static final void useStandardDataSourcePropertyAppendar$add(DatabaseProperties this$0, HikariConfig $hikariConfig, String name, Object value) {
        if (this$0.ignoredProperties.contains(name)) {
            return;
        }
        $hikariConfig.addDataSourceProperty(name, value);
    }

    @JvmStatic
    @NotNull
    public static final DatabaseProperties defaults(@NotNull DatabaseType databaseType) {
        return Companion.defaults(databaseType);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/data/database/sql/DatabaseProperties$Companion;", "", "()V", "DEFAULTS", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "initialized", "", "defaults", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "parseAddress", "Lorg/kingdoms/libs/kotlin/Pair;", "", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DatabaseProperties defaults(@NotNull DatabaseType databaseType) {
            DatabaseProperties databaseProperties;
            Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
            if (initialized) {
                return DEFAULTS;
            }
            DatabaseProperties databaseProperties2 = DEFAULTS;
            Pair<String, Integer> pair = this.parseAddress(databaseType);
            String address = (String)pair.component1();
            int port = ((Number)pair.component2()).intValue();
            databaseProperties2.setAddress(address);
            databaseProperties2.setPort(port);
            DatabaseProperties $this$defaults_u24lambda_u2d0 = databaseProperties = databaseProperties2;
            boolean bl = false;
            String string = KingdomsConfig.DATABASE_USERNAME.getManager().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DATABASE_USERNAME.manager.string");
            $this$defaults_u24lambda_u2d0.setUser(string);
            String string2 = KingdomsConfig.DATABASE_PASSWORD.getManager().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DATABASE_PASSWORD.manager.string");
            $this$defaults_u24lambda_u2d0.setPassword(string2);
            String string3 = KingdomsConfig.DATABASE_DATABASE.getManager().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DATABASE_DATABASE.manager.string");
            $this$defaults_u24lambda_u2d0.setDatabaseName(string3);
            $this$defaults_u24lambda_u2d0.setUseSSL(KingdomsConfig.DATABASE_SSL_ENABLED.getManager().getBoolean());
            $this$defaults_u24lambda_u2d0.setVerifyServerCertificate(KingdomsConfig.DATABASE_SSL_VERIFY_SERVER_CERTIFICATE.getManager().getBoolean());
            $this$defaults_u24lambda_u2d0.setAllowPublicKeyRetrieval(KingdomsConfig.DATABASE_SSL_ALLOW_PUBLIC_KEY_RETRIEVAL.getManager().getBoolean());
            ConfigSection dataSourceProperties = KingdomsConfig.DATABASE_POOL_SETTINGS_PROPERTIES.getManager().getSection().noDefault().getSection();
            for (String key : dataSourceProperties.getKeys()) {
                Object object;
                Map<String, Object> map = $this$defaults_u24lambda_u2d0.getOthers();
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                String string4 = key;
                String[] stringArray = new String[]{key};
                Intrinsics.checkNotNull((Object)dataSourceProperties.get(stringArray), (String)"null cannot be cast to non-null type kotlin.Any");
                map.put(string4, object);
            }
            initialized = true;
            return databaseProperties2;
        }

        private final Pair<String, Integer> parseAddress(DatabaseType databaseType) {
            String address = KingdomsConfig.DATABASE_ADDRESS.getManager().getString();
            int port = databaseType.getDefaultPort();
            List<String> list2 = StringUtils.split(address, ':', false);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"split(address, ':', false)");
            List<String> addrPort = list2;
            if (addrPort.size() == 2) {
                address = addrPort.get(0);
                String string = addrPort.get(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"addrPort[1]");
                port = Integer.parseInt(string);
            }
            return TuplesKt.to((Object)address, (Object)port);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

