/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.regex.Pattern;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.data.DataManager;
import org.kingdoms.data.database.KingdomsDatabase;
import org.kingdoms.data.database.dataprovider.IdDataTypeHandler;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLConnectionProvider;
import org.kingdoms.data.database.sql.SQLDataGetterProvider;
import org.kingdoms.data.database.sql.SQLDataSetterProvider;
import org.kingdoms.data.database.sql.SchemaReader;
import org.kingdoms.data.database.sql.statements.getters.SimpleResultSetQuery;
import org.kingdoms.data.database.sql.statements.setters.PreparedNamedSetterStatement;
import org.kingdoms.data.database.sql.statements.setters.RawSimplePreparedStatement;
import org.kingdoms.data.handlers.DataHandler;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.intellij.lang.annotations.Language;
import org.kingdoms.libs.kotlin.text.MatchGroup;
import org.kingdoms.libs.kotlin.text.MatchGroupCollection;
import org.kingdoms.libs.kotlin.text.Regex;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.string.StringUtils;

public final class SQLDatabase<K, T extends KingdomsObject<K>>
implements KingdomsDatabase<K, T> {
    public static boolean ranSchema = false;
    private final DataHandler<K, T> dataHandler;
    private final DatabaseType databaseType;
    private final SQLConnectionProvider connectionProvider;
    private final String table;
    private int totalDataCount = 10;
    @Language(value="RegExp")
    private static final String NULLABLE = "( +(?:NOT )?NULL)?";
    @Language(value="RegExp")
    private static final String NOTHING_BEHIND = "(?<!\\w)";
    private static final Regex LOCAION_TYPE = SQLDatabase.compile("Location\\((\\w+)\\)");
    private static final Regex SIMPLE_LOCATION_TYPE = SQLDatabase.compile("SimpleLocation\\((\\w+)\\)");
    private static final Regex SIMPLE_CHUNK_LOCATION_TYPE = SQLDatabase.compile("SimpleChunkLocation\\((\\w+)\\)");

    public SQLDatabase(DatabaseType databaseType, String table, DataHandler<K, T> dataHandler, SQLConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        this.dataHandler = dataHandler;
        this.databaseType = databaseType;
        this.table = SQLConnectionProvider.TABLE_PREFIX + table;
        if (!ranSchema) {
            this.printMeta();
            try {
                String executePragma = databaseType == DatabaseType.SQLite ? "PRAGMA strict=ON" : null;
                List<String> statements = SchemaReader.getStatements(Kingdoms.get().getResource("schema.sql"));
                try (Connection connection = this.getConnection();
                     Statement statement = connection.createStatement();){
                    for (String query : statements) {
                        if (executePragma != null) {
                            statement.addBatch(executePragma);
                            executePragma = null;
                        }
                        query = SQLDatabase.globalSchemaProcessor(query);
                        query = databaseType.processCommands(query);
                        statement.addBatch(query);
                    }
                    statement.executeBatch();
                }
            }
            catch (IOException | SQLException e) {
                throw new RuntimeException(e);
            }
            ranSchema = true;
        }
    }

    private static String replacePrefix(String query) {
        return StringUtils.replace(query, "{PREFIX}", KingdomsConfig.DATABASE_TABLE_PREFIX.getString() + '_');
    }

    private static Regex compile(@Language(value="RegExp") String pattern) {
        return new Regex(Pattern.compile(NOTHING_BEHIND + pattern + NULLABLE));
    }

    private static String replace(Regex pattern, String query, String ... fragments) {
        return pattern.replace((CharSequence)query, matcher -> {
            MatchGroupCollection groups = matcher.getGroups();
            String prefix = groups.get(1).getValue();
            MatchGroup nullGroup = groups.get(2);
            String nullability = nullGroup == null ? "" : nullGroup.getValue();
            StringJoiner builder = new StringJoiner(", ");
            for (String fragment : fragments) {
                builder.add(prefix + '_' + fragment + nullability);
            }
            return builder.toString();
        });
    }

    private static String globalSchemaProcessor(String query) {
        query = SQLDatabase.replacePrefix(query);
        query = SQLDatabase.replace(LOCAION_TYPE, query, "world WORLD", "x DOUBLE", "y DOUBLE", "z DOUBLE", "yaw FLOAT", "pitch FLOAT");
        query = SQLDatabase.replace(SIMPLE_LOCATION_TYPE, query, "world WORLD", "x INT", "y INT", "z INT");
        query = SQLDatabase.replace(SIMPLE_CHUNK_LOCATION_TYPE, query, "world WORLD", "x INT", "z INT");
        query = StringUtils.replace(query, "WORLD", "VARCHAR(64)");
        query = StringUtils.replace(query, "RANK_NODE", "VARCHAR(50)");
        query = StringUtils.replace(query, "RANK_NAME", "NVARCHAR(100)");
        query = StringUtils.replace(query, "COLOR", "VARCHAR(30)");
        return query;
    }

    private String handleQuery(String query) {
        if (this.databaseType.getSystemIdentifierEscapeChar() != '`') {
            return query.replace('`', this.databaseType.getSystemIdentifierEscapeChar());
        }
        return query;
    }

    private void printMeta() {
        KLogger log = new KLogger(KingdomsDebug.CHUNK$SNAPSHOT);
        try (Connection connection = this.getConnection();){
            DatabaseMetaData meta = connection.getMetaData();
            KLogger.info("Running SQL Database:");
            KLogger.info("   | Driver: " + meta.getDriverName() + " (" + meta.getCatalogTerm() + ") | " + meta.getDriverVersion());
            KLogger.info("   | Product: " + meta.getDatabaseProductName() + " | " + meta.getDatabaseProductVersion());
            KLogger.info("   | JDBC: " + meta.getJDBCMajorVersion() + '.' + meta.getJDBCMinorVersion());
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to retrieve meta information for SQL: " + (Object)((Object)this.databaseType), e);
        }
    }

    public static byte[] asBytes(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public static UUID asUUID(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long firstLong = bb.getLong();
        long secondLong = bb.getLong();
        return new UUID(firstLong, secondLong);
    }

    private Connection getConnection() {
        return this.connectionProvider.getConnection();
    }

    /*
     * Exception decompiling
     */
    @Override
    public T load(@NonNull K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public @NonNull Collection<T> load(@NonNull Collection<K> keys, @NonNull Collection<T> to, @NonNull DataManager<K, T> dataManager) {
        Objects.requireNonNull(keys);
        Objects.requireNonNull(to);
        Objects.requireNonNull(dataManager);
        if (keys.isEmpty()) {
            return to;
        }
        int columnCount = this.dataHandler.getIdHandler().getColumns().length;
        String inClause = StringUtils.repeat('(' + this.dataHandler.getIdHandler().getInClause() + "),", keys.size());
        inClause = inClause.substring(0, inClause.length() - 1);
        String query = this.handleQuery("SELECT * FROM `" + this.table + "` WHERE (" + this.dataHandler.getIdHandler().getColumnsTuple() + ") IN(" + inClause + ')');
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(query);){
            int i = 0;
            for (K key : keys) {
                this.dataHandler.getIdHandler().setSQL(new RawSimplePreparedStatement(i * columnCount + 1, this.databaseType, ps), key);
                ++i;
            }
            try (ResultSet result = ps.executeQuery();){
                while (result.next()) {
                    K key;
                    key = this.dataHandler.getIdHandler().fromSQL(new SimpleResultSetQuery(this.databaseType, result));
                    SQLDataGetterProvider<K> provider = new SQLDataGetterProvider<K>(this.databaseType, key, this.dataHandler.getIdHandler(), connection, this.table, null, false, false, new SimpleResultSetQuery(this.databaseType, result));
                    to.add((KingdomsObject)this.dataHandler.load(provider, key));
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while loading data for key [" + keys + "] with query: " + query, ex);
        }
        return to;
    }

    @Override
    public void save(T data) {
        PreparedNamedSetterStatement ps = new PreparedNamedSetterStatement(this.databaseType, this.dataHandler.getSqlProperties().getAssociateNamedData());
        try (Connection connection = this.getConnection();){
            SQLDataSetterProvider provider = new SQLDataSetterProvider(this.databaseType, ((KingdomsObject)data).getDataKey(), this.dataHandler.getIdHandler(), connection, this.table, null, false, false, ps);
            this.dataHandler.getIdHandler().setSQL(ps, ((KingdomsObject)data).getDataKey());
            this.dataHandler.save(provider, data);
            ps.buildStatement(this.table, connection);
            ps.execute();
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while saving data " + ((KingdomsObject)data).getDataKey() + " (" + data.getClass() + ')', ex);
        }
    }

    @Override
    public void delete(@NonNull K key) {
        String query = this.handleQuery("DELETE FROM `" + this.table + "` WHERE " + this.dataHandler.getIdHandler().getWhereClause());
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(query);){
            this.dataHandler.getIdHandler().setSQL(new RawSimplePreparedStatement(this.databaseType, ps), key);
            ps.execute();
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while deleting data with query: " + query, ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasData(@NonNull K key) {
        String query = this.handleQuery("SELECT 1 FROM `" + this.table + "` WHERE " + this.dataHandler.getIdHandler().getWhereClause());
        try (Connection connection = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement ps = connection.prepareStatement(query);
                try {
                    this.dataHandler.getIdHandler().setSQL(new RawSimplePreparedStatement(this.databaseType, ps), key);
                    ResultSet result = ps.executeQuery();
                    bl = result.next();
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while attempting to check if data exists with query: " + query, ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public @NonNull Collection<K> getDataKeys() {
        ArrayList<K> keys = new ArrayList<K>(this.totalDataCount);
        String query = this.handleQuery("SELECT " + this.dataHandler.getIdHandler().getColumnsTuple() + " FROM `" + this.table + '`');
        try (Connection connection = this.getConnection();){
            ArrayList<K> arrayList;
            block24: {
                Statement statement = connection.createStatement();
                try {
                    try (ResultSet result = statement.executeQuery(query);){
                        while (result.next()) {
                            K key = this.dataHandler.getIdHandler().fromSQL(new SimpleResultSetQuery(this.databaseType, result));
                            keys.add(key);
                        }
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException("Error while getting key from query: " + query, ex);
                    }
                    this.totalDataCount = Math.max(this.totalDataCount, keys.size());
                    arrayList = keys;
                    if (statement == null) break block24;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return arrayList;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while running query: " + query, ex);
        }
    }

    @Override
    public void deleteAllData() {
        String query = this.handleQuery("DROP TABLE `" + this.table + '`');
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeQuery(query);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while attempting to drop table: " + query);
        }
    }

    @Override
    public Collection<T> loadAllData() {
        ArrayList<KingdomsObject> list2 = new ArrayList<KingdomsObject>(this.totalDataCount);
        String query = this.handleQuery("SELECT * FROM `" + this.table + '`');
        try (Connection connection = this.getConnection();
             PreparedStatement ps = connection.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                SimpleResultSetQuery result = new SimpleResultSetQuery(this.databaseType, rs);
                K key = this.dataHandler.getIdHandler().fromSQL(result);
                SQLDataGetterProvider<K> provider = new SQLDataGetterProvider<K>(this.databaseType, key, this.dataHandler.getIdHandler(), connection, this.table, null, false, false, result);
                list2.add((KingdomsObject)this.dataHandler.load(provider, key));
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while loading all data with query: " + query, ex);
        }
        this.totalDataCount = Math.max(this.totalDataCount, list2.size());
        return list2;
    }

    @Override
    public void save(Collection<T> datas) {
        if (datas.isEmpty()) {
            return;
        }
        PreparedNamedSetterStatement ps = new PreparedNamedSetterStatement(this.databaseType, this.dataHandler.getSqlProperties().getAssociateNamedData());
        IdDataTypeHandler<K> idHandler = this.dataHandler.getIdHandler();
        try (Connection connection = this.getConnection();){
            connection.setAutoCommit(false);
            for (KingdomsObject data : datas) {
                SQLDataSetterProvider provider = new SQLDataSetterProvider(this.databaseType, data.getDataKey(), idHandler, connection, this.table, null, false, false, ps);
                this.dataHandler.getIdHandler().setSQL(ps, data.getDataKey());
                this.dataHandler.save(provider, data);
                ps.buildStatement(this.table, connection);
                ps.addBatch();
            }
            ps.execute();
            connection.commit();
            connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while trying to save batch data", e);
        }
    }

    @Override
    public void close() {
        this.connectionProvider.close();
    }
}

