/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.abstraction.ImmutableLocation;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.constants.group.model.InviteCode;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.group.upgradable.Powerup;
import org.kingdoms.constants.group.upgradable.champion.ChampionUpgrade;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.IdDataTypeHandler;
import org.kingdoms.data.database.dataprovider.MappedIdSetter;
import org.kingdoms.data.database.dataprovider.SQLDataHandlerProperties;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StdIdDataType;
import org.kingdoms.data.handlers.DataHandler;
import org.kingdoms.data.handlers.DataHandlerGroup;
import org.kingdoms.data.handlers.DataHandlerKingdom;
import org.kingdoms.data.handlers.DataHandlerMetadata;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.IndexedValue;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.utils.internal.arrays.ArrayUtils;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;
import org.kingdoms.utils.nms.JsonItemStack;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerKingdom;", "Lorg/kingdoms/data/handlers/DataHandler;", "Ljava/util/UUID;", "Lorg/kingdoms/constants/group/Kingdom;", "()V", "load", "provider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "id", "save", "", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "data", "core"})
public final class DataHandlerKingdom
extends DataHandler<UUID, Kingdom> {
    public DataHandlerKingdom() {
        IdDataTypeHandler idDataTypeHandler = StdIdDataType.UUID;
        Object[] objectArray = new Object[]{SQLDataHandlerProperties.Companion.ofLocation("home"), SQLDataHandlerProperties.Companion.ofSimpleLocation("nexus"), "color", "flag"};
        String[] stringArray = ArrayUtils.mergeObjects(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"mergeObjects(\n          \u2026\"color\", \"flag\"\n        )");
        super(idDataTypeHandler, new SQLDataHandlerProperties(stringArray));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void save(@NotNull SectionableDataSetter provider, @NotNull Kingdom data) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$associateTo$iv$iv;
        Map $this$associate$iv;
        Map upgrade;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DataHandlerGroup.save(provider, data);
        provider.setUUID("king", data.getKingId());
        provider.setUUID("nation", data.getNationId());
        provider.setString("lore", data.getLore());
        provider.setInt("maxLandsModifier", data.getMaxLandsModifier());
        provider.setLong("lastInvasion", data.getLastInvasion());
        provider.setBoolean("pacifist", data.isPacifist());
        SectionableDataSetter sectionableDataSetter = provider.get("lands");
        Set<SimpleChunkLocation> set = data.getLandLocations();
        Intrinsics.checkNotNullExpressionValue(set, (String)"data.landLocations");
        sectionableDataSetter.setCollection((Collection)set, DataHandlerKingdom::save$lambda-0);
        SectionableDataSetter sectionableDataSetter2 = provider.get("members");
        Set<UUID> set2 = data.getMembers();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"data.members");
        sectionableDataSetter2.setCollection((Collection)set2, DataHandlerKingdom::save$lambda-1);
        SectionableDataSetter it = provider.createSection("upgrades");
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"misc", data.getMiscUpgrades()), TuplesKt.to((Object)"powerups", data.getPowerups()), TuplesKt.to((Object)"champions", data.getChampionUpgrades())};
        for (Pair pair : pairArray) {
            String name = (String)pair.component1();
            upgrade = (Map)pair.component2();
            it.get(name).setMap(upgrade, save.3.1.INSTANCE);
        }
        SectionableDataSetter sectionableDataSetter3 = provider.get("nexusChest");
        ItemStack[] itemStackArray = data.getNexusChest().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"data.nexusChest.contents");
        Iterable iterable = ArraysKt.withIndex((Object[])itemStackArray);
        SectionableDataSetter sectionableDataSetter4 = sectionableDataSetter3;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associate$iv), (int)10)), (int)16);
        void var6_9 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            upgrade = destination$iv$iv;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            boolean bl2 = false;
            int index = indexedValue.component1();
            ItemStack value = (ItemStack)indexedValue.component2();
            indexedValue = TuplesKt.to((Object)index, (Object)value);
            upgrade.put(indexedValue.getFirst(), indexedValue.getSecond());
        }
        $this$associate$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        void capacity$iv22 = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl3 = false;
            ItemStack item = (ItemStack)entry.getValue();
            if (!(item != null)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        sectionableDataSetter4.setMap(destination$iv$iv2, DataHandlerKingdom::save$lambda-5);
        SectionableDataSetter sectionableDataSetter5 = provider.get("book");
        Map<String, BookChapter> map = data.getBook();
        Intrinsics.checkNotNullExpressionValue(map, (String)"data.book");
        sectionableDataSetter5.setMap(map, DataHandlerKingdom::save$lambda-8);
        provider.get("mails").setCollection((Collection)data.getMails().keySet(), DataHandlerKingdom::save$lambda-9);
        SectionableDataSetter sectionableDataSetter6 = provider.get("challenges");
        Map<UUID, Long> map2 = data.getChallenges();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"data.challenges");
        sectionableDataSetter6.setMap(map2, DataHandlerKingdom::save$lambda-10);
        SectionableDataSetter sectionableDataSetter7 = provider.get("inviteCodes");
        Map<String, InviteCode> map3 = data.getInviteCodes();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"data.inviteCodes");
        sectionableDataSetter7.setMap(map3, DataHandlerKingdom::save$lambda-13);
    }

    @Override
    @NotNull
    public Kingdom load(@NotNull SectionableDataGetter provider, @NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DataHandlerGroup.DataHolder parent = DataHandlerGroup.load(provider);
        UUID uUID = provider.get("king").asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        UUID king = uUID;
        UUID nation = provider.get("nation").asUUID();
        String name = parent.getName();
        String tag = parent.getTag();
        String lore = provider.getString("lore");
        String tax = parent.getTax();
        String flag = parent.getFlag();
        Color color = parent.getColor();
        String championType2 = provider.get("championType").asString((Function0<String>)((Function0)load.championType.1.INSTANCE));
        int maxClaimMod = provider.getInt("maxLandsModifier");
        double bank = parent.getBank();
        long rp = parent.getResourcePoints();
        long lastInvasion = provider.getLong("lastInvasion");
        long since = parent.getSince();
        long shieldSince = parent.getShieldSince();
        long shieldTime = parent.getShieldTime();
        boolean pacifist = provider.getBoolean("pacifist");
        boolean publicHome = parent.getPublicHome();
        boolean permanent = parent.getPermanent();
        boolean requiresInvite = parent.getRequiresInvite();
        ImmutableLocation home = ImmutableLocation.Companion.of(parent.getHome());
        SimpleLocation nexus = parent.getNexus();
        RankMap ranks = parent.getRanks();
        Map<KingdomRelation, Set<RelationAttribute>> attributes = parent.getAttributes();
        Map<UUID, KingdomRelationshipRequest> rlReq = parent.getRelationshipRequests();
        Map<UUID, KingdomRelation> relations = parent.getRelations();
        Set members = provider.get("members").asCollection((Collection)new HashSet(), DataHandlerKingdom::load$lambda-14);
        Set lands = provider.get("lands").asCollection((Collection)new HashSet(), DataHandlerKingdom::load$lambda-15);
        SectionableDataGetter upgrades = provider.get("upgrades").asSection();
        Map miscUpgrades = upgrades.get("misc").asMap((Map)new QuickEnumMap((Enum[])MiscUpgrade.VALUES), DataHandlerKingdom::load$lambda-16);
        Map powerups = upgrades.get("powerups").asMap((Map)new QuickEnumMap((Enum[])Powerup.VALUES), DataHandlerKingdom::load$lambda-17);
        Map championUpgrades = upgrades.get("champions").asMap((Map)new QuickEnumMap((Enum[])ChampionUpgrade.VALUES), DataHandlerKingdom::load$lambda-18);
        HashMap items = provider.get("nexusChest").asMap((Map)new HashMap(), DataHandlerKingdom::load$lambda-19);
        HashMap book = provider.get("book").asMap((Map)new HashMap(), DataHandlerKingdom::load$lambda-21);
        Set mails = provider.get("mails").asCollection((Collection)new HashSet(), DataHandlerKingdom::load$lambda-22);
        HashMap challenges = provider.get("challenges").asMap((Map)new HashMap(), DataHandlerKingdom::load$lambda-23);
        HashMap inviteCodes = provider.get("inviteCodes").asMap((Map)new HashMap(), DataHandlerKingdom::load$lambda-25);
        Map<UUID, KingdomRelationshipRequest> map = rlReq;
        Intrinsics.checkNotNull(map);
        LinkedList<AuditLog> linkedList = parent.getLogs();
        Intrinsics.checkNotNull(linkedList);
        RankMap rankMap = ranks;
        Intrinsics.checkNotNull((Object)rankMap);
        Map<UUID, KingdomRelation> map2 = relations;
        Intrinsics.checkNotNull(map2);
        String string = championType2;
        Intrinsics.checkNotNull((Object)string);
        Location location = home;
        Map<KingdomRelation, Set<RelationAttribute>> map3 = attributes;
        Intrinsics.checkNotNull(map3);
        Kingdom kingdom = new Kingdom(id, map, mails, challenges, inviteCodes, linkedList, miscUpgrades, powerups, championUpgrades, lands, rankMap, map2, members, lore, string, pacifist, king, nation, name, tag, tax, nexus, location, book, items, flag, color, rp, maxClaimMod, bank, lastInvasion, since, publicHome, permanent, requiresInvite, shieldTime, shieldSince, map3);
        DataHandlerMetadata.deserializeMetadata(provider, kingdom);
        return kingdom;
    }

    private static final void save$lambda-0(SectionCreatableDataSetter obj, SimpleChunkLocation value) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        SimpleChunkLocation simpleChunkLocation = value;
        Intrinsics.checkNotNull((Object)simpleChunkLocation);
        obj.setSimpleChunkLocation(simpleChunkLocation);
    }

    private static final void save$lambda-1(SectionCreatableDataSetter obj, UUID value) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.setUUID(value);
    }

    private static final void save$lambda-5(int key, MappedIdSetter keyProvider, ItemStack value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setInt(key);
        keyProvider.getValueProvider().setString(JsonItemStack.serialize(value));
    }

    private static final void save$lambda-8$lambda-7$lambda-6(SectionCreatableDataSetter elementProvider, String element) {
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        elementProvider.setString(element);
    }

    private static final void save$lambda-8(String key, MappedIdSetter keyProvider, BookChapter value) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setString(key);
        SectionableDataSetter $this$save_u24lambda_u2d8_u24lambda_u2d7 = sectionableDataSetter = keyProvider.getValueProvider().createSection();
        boolean bl = false;
        SectionableDataSetter sectionableDataSetter2 = $this$save_u24lambda_u2d8_u24lambda_u2d7.get("pages");
        List<String> list2 = value.getPages();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"value.pages");
        sectionableDataSetter2.setCollection((Collection)list2, DataHandlerKingdom::save$lambda-8$lambda-7$lambda-6);
    }

    private static final void save$lambda-9(SectionCreatableDataSetter elementProvider, UUID element) {
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        elementProvider.setUUID(element);
    }

    private static final void save$lambda-10(UUID key, MappedIdSetter keyProvider, Long value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setUUID(key);
        SectionCreatableDataSetter sectionCreatableDataSetter = keyProvider.getValueProvider();
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
        sectionCreatableDataSetter.setLong(value);
    }

    private static final void save$lambda-13$lambda-12$lambda-11(SectionCreatableDataSetter elementProvider, UUID element) {
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        elementProvider.setUUID(element);
    }

    private static final void save$lambda-13(String key, MappedIdSetter keyProvider, InviteCode value) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setString(key);
        SectionableDataSetter $this$save_u24lambda_u2d13_u24lambda_u2d12 = sectionableDataSetter = keyProvider.getValueProvider().createSection();
        boolean bl = false;
        $this$save_u24lambda_u2d13_u24lambda_u2d12.setUUID("createdBy", value.getCreatedBy());
        $this$save_u24lambda_u2d13_u24lambda_u2d12.setLong("createdAt", value.getCreatedAt());
        $this$save_u24lambda_u2d13_u24lambda_u2d12.setLong("expiration", value.getExpiration());
        $this$save_u24lambda_u2d13_u24lambda_u2d12.setInt("uses", value.getUses());
        SectionableDataSetter sectionableDataSetter2 = $this$save_u24lambda_u2d13_u24lambda_u2d12.get("usedBy");
        Set<UUID> set = value.getUsedBy();
        Intrinsics.checkNotNullExpressionValue(set, (String)"value.usedBy");
        sectionableDataSetter2.setCollection((Collection)set, DataHandlerKingdom::save$lambda-13$lambda-12$lambda-11);
    }

    private static final void load$lambda-14(HashSet set, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UUID uUID = element.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        set.add(uUID);
    }

    private static final void load$lambda-15(HashSet set, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        set.add(element.asSimpleChunkLocation());
    }

    private static final void load$lambda-16(Map map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        map.put(MiscUpgrade.valueOf(string), value.asInt());
    }

    private static final void load$lambda-17(Map map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        map.put(Powerup.valueOf(string), value.asInt());
    }

    private static final void load$lambda-18(Map map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        map.put(ChampionUpgrade.valueOf(string), value.asInt());
    }

    private static final void load$lambda-19(HashMap map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        Map map2 = map;
        Integer n = key.asInt();
        ItemStack itemStack = JsonItemStack.deserialize(value.asString());
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"deserialize(value.asString())");
        ItemStack itemStack2 = itemStack;
        map2.put(n, itemStack2);
    }

    private static final void load$lambda-21$lambda-20(ArrayList list2, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        list2.add(element.asString());
    }

    private static final void load$lambda-21(HashMap map, DataGetter key, SectionableDataGetter value) {
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        String chapter = string;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        ((Map)map).put(chapter, new BookChapter(chapter, value.get("pages").asCollection((Collection)new ArrayList(), DataHandlerKingdom::load$lambda-21$lambda-20)));
    }

    private static final void load$lambda-22(HashSet collection, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UUID uUID = element.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        UUID mailId = uUID;
        collection.add(mailId);
    }

    private static final void load$lambda-23(HashMap map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        Map map2 = map;
        UUID uUID = key.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        map2.put(uUID, value.asLong());
    }

    private static final void load$lambda-25$lambda-24(HashSet list2, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UUID uUID = element.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        list2.add(uUID);
    }

    private static final void load$lambda-25(HashMap map, DataGetter key, SectionableDataGetter value) {
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        String code = string;
        long createdAt = value.getLong("createdAt");
        UUID uUID = value.get("createdBy").asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        UUID createdBy = uUID;
        long expiration = value.getLong("expiration");
        int uses = value.getInt("uses");
        Set usedBy = value.get("usedBy").asCollection((Collection)new HashSet(), DataHandlerKingdom::load$lambda-25$lambda-24);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        ((Map)map).put(code, new InviteCode(code, createdAt, expiration, createdBy, usedBy, uses));
    }
}

