/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.data.database.dataprovider.DataSetter;
import org.kingdoms.data.database.dataprovider.SQLDataHandlerProperties;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StdIdDataType;
import org.kingdoms.data.handlers.DataHandler;
import org.kingdoms.data.handlers.DataHandlerMetadata;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.SupportedLanguage;

public final class DataHandlerKingdomPlayer
extends DataHandler<UUID, KingdomPlayer> {
    public DataHandlerKingdomPlayer() {
        super(StdIdDataType.UUID, new SQLDataHandlerProperties(new String[]{"power", "lastPowerCheckup", "chatChannel", "mapSize_height", "mapSize_width"}));
    }

    @Override
    public void save(@NotNull SectionableDataSetter provider, KingdomPlayer data) {
        provider.setUUID("kingdom", data.getKingdomId());
        provider.setString("lang", data.getLanguage().name());
        provider.setString("rank", data.getRankNode());
        provider.setString("nationalRank", data.getNationRankNode());
        if (!data.getChatChannelId().equals("GLOBAL")) {
            provider.setString("chatChannel", data.getChatChannel().getDataId());
        }
        provider.setLong("joinedAt", data.getJoinedAt());
        provider.setString("markersType", data.getMarkersType());
        if (KingdomsConfig.Powers.POWER_ENABLED.getManager().getBoolean()) {
            provider.setDouble("power", data.getPower());
            provider.setLong("lastPowerCheckup", data.getLastPowerCheckup());
        }
        provider.setLong("lastDonationTime", data.getLastDonationTime());
        provider.setLong("lastDonationAmount", data.getLastDonationAmount());
        provider.setLong("totalDonations", data.getTotalDonations());
        provider.setBoolean("pvp", data.isPvp());
        provider.setBoolean("spy", data.isSpy());
        provider.setBoolean("admin", data.isAdmin());
        provider.setBoolean("sneakMode", data.isInSneakMode());
        provider.setBoolean("markers", data.isUsingMarkers());
        provider.setString("markersType", data.getMarkersType());
        Pair<Integer, Integer> mapSize = data.getMapSize();
        if (mapSize != null) {
            SectionableDataSetter mapSizeProvider = provider.createSection("mapSize");
            mapSizeProvider.setInt("height", mapSize.getKey());
            mapSizeProvider.setInt("width", mapSize.getValue());
        }
        provider.get("invites").setMap(data.getInvites(), (key, keyProvider, value) -> {
            keyProvider.setUUID((UUID)key);
            SectionableDataSetter valueProvider = keyProvider.getValueProvider().createSection();
            valueProvider.setUUID("sender", value.getSender());
            valueProvider.setLong("acceptTime", value.getAcceptTime());
            valueProvider.setLong("timestamp", value.getTimestamp());
        });
        provider.get("claims").setCollection(data.getClaims(), DataSetter::setSimpleChunkLocation);
        provider.get("mutedChannels").setCollection(data.getMutedChannels(), DataSetter::setString);
        provider.get("readMails").setCollection(data.getReadMails(), DataSetter::setUUID);
        DataHandlerMetadata.serializeMetadata(provider, data);
    }

    @Override
    public KingdomPlayer load(@NotNull SectionableDataGetter provider, UUID id) {
        String langName = provider.getString("lang");
        SupportedLanguage language = langName != null ? SupportedLanguage.valueOf(langName) : LanguageManager.getDefaultLanguage();
        UUID kingdom = provider.get("kingdom").asUUID();
        String rank = provider.getString("rank");
        String nationalRank = provider.getString("nationalRank");
        String markersType = provider.getString("markersType");
        String channel = provider.get("chatChannel").asString((Function0<String>)((Function0)() -> "GLOBAL"));
        double power = provider.getDouble("power");
        long lastPowerCheckup = provider.getLong("lastPowerCheckup");
        long joinedAt = provider.getLong("joinedAt");
        long lastDonationTime = provider.getLong("lastDonationTime");
        long lastDonationAmount = provider.getLong("lastDonationAmount");
        long totalDonations = provider.getLong("totalDonations");
        boolean markers = provider.getBoolean("markers");
        boolean pvp = provider.getBoolean("pvp");
        boolean admin = provider.getBoolean("admin");
        boolean spy = provider.getBoolean("spy");
        boolean sneakMode = provider.getBoolean("sneakMode");
        Set readMails = provider.get("readMails").asCollection(new HashSet(), (c, e) -> c.add(e.asUUID()));
        Set mutedChannels = provider.get("mutedChannels").asCollection(new HashSet(), (c, e) -> c.add(e.asString()));
        Set claims = provider.get("claims").asCollection(new HashSet(), (c, e) -> c.add(e.asSimpleChunkLocation()));
        SectionableDataGetter mapSizeSection = provider.get("mapSize").asSection();
        int mapHeight = mapSizeSection.getInt("height");
        int mapWidth = mapSizeSection.getInt("width");
        Pair<Integer, Integer> mapSize = mapHeight == 0 || mapWidth == 0 ? null : Pair.of(mapHeight, mapWidth);
        HashMap invites = provider.get("invites").asMap(new HashMap(), (m, k, v) -> m.put(k.asUUID(), new KingdomInvite(v.get("sender").asUUID(), v.getLong("acceptTime"), v.getLong("timestamp"))));
        KingdomPlayer kp = new KingdomPlayer(id, kingdom, language, rank, nationalRank, channel, markersType, joinedAt, power, lastDonationTime, lastDonationAmount, totalDonations, lastPowerCheckup, readMails, invites, claims, mapSize, markers, pvp, admin, spy, sneakMode, mutedChannels);
        DataHandlerMetadata.deserializeMetadata(provider, kp);
        return kp;
    }
}

