/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.util.HashMap;
import java.util.UUID;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.data.database.dataprovider.SQLDataHandlerProperties;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StdIdDataType;
import org.kingdoms.data.handlers.DataHandler;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.main.KLogger;

public final class DataHandlerLand
extends DataHandler<SimpleChunkLocation, Land> {
    public DataHandlerLand() {
        super(StdIdDataType.SIMPLE_CHUNK_LOCATION, new SQLDataHandlerProperties(new String[0]));
    }

    @Override
    public void save(@NotNull SectionableDataSetter provider, @NonNull Land data) {
        provider.setUUID("kingdom", data.getKingdomId());
        provider.setUUID("claimedBy", data.getClaimedBy());
        provider.setLong("since", data.getSince());
        provider.get("structures").setMap(data.getStructures(), (key, keyProvider, value) -> {
            keyProvider.setSimpleLocation((SimpleLocation)key);
            value.serialize(new SerializationContext<SectionableDataSetter>(keyProvider.getValueProvider().createSection()));
        });
        provider.get("turrets").setMap(data.getTurrets(), (key, keyProvider, value) -> {
            keyProvider.setSimpleLocation((SimpleLocation)key);
            value.serialize(new SerializationContext<SectionableDataSetter>(keyProvider.getValueProvider().createSection()));
        });
        provider.get("protectedBlocks").setMap(data.getProtectedBlocks(), (key, keyProvider, value) -> {
            keyProvider.setSimpleLocation((SimpleLocation)key);
            SectionableDataSetter valueProvider = keyProvider.getValueProvider().createSection();
            valueProvider.setString("password", value.getPassword());
            valueProvider.get("sign").setSimpleLocation(value.getSign());
            valueProvider.setUUID("owner", value.getOwner());
            valueProvider.setLong("since", value.getSince());
            valueProvider.setString("protectionType", value.getProtectionType().name());
            valueProvider.get("players").setMap(value.getPlayers(), (pKey, pKeyProvider, pValue) -> {
                pKeyProvider.setUUID((UUID)pKey);
                pKeyProvider.getValueProvider().setBoolean((boolean)pValue);
            });
            valueProvider.get("kingdoms").setMap(value.getKingdoms(), (pKey, pKeyProvider, pValue) -> {
                pKeyProvider.setUUID((UUID)pKey);
                pKeyProvider.getValueProvider().setBoolean((boolean)pValue);
            });
        });
    }

    @Override
    public Land load(@NotNull SectionableDataGetter provider, SimpleChunkLocation id) {
        UUID kingdom = provider.get("kingdom").asUUID();
        UUID claimedBy = provider.get("claimedBy").asUUID();
        long since = provider.getLong("since");
        HashMap structures = provider.get("structures").asMap(new HashMap(), (map, key, value) -> {
            String styleName = value.getString("type");
            StructureStyle style = StructureRegistry.getStyle(styleName);
            if (style == null) {
                KLogger.warn("Unknown structure style '" + styleName + "' (the file was possibly deleted from Structures folder)");
                return;
            }
            SimpleLocation loc = key.asSimpleLocation();
            KingdomItem structure = ((StructureType)style.getType()).build(new KingdomItemBuilder(style, loc));
            ((StructureType)style.getType()).deserialize((Structure)structure, new DeserializationContext<SectionableDataGetter>((SectionableDataGetter)value));
            map.put(loc, structure);
        });
        HashMap turrets = provider.get("turrets").asMap(new HashMap(), (map, key, value) -> {
            String styleName = value.getString("type");
            TurretStyle style = TurretRegistry.getStyle(styleName);
            if (style == null) {
                KLogger.warn("Unknown turret style '" + styleName + "' (the file was possibly deleted from Turrets folder)");
                return;
            }
            SimpleLocation loc = key.asSimpleLocation();
            KingdomItem turret = ((TurretType)style.getType()).build(new KingdomItemBuilder(style, loc));
            ((TurretType)style.getType()).deserialize(turret, new DeserializationContext<SectionableDataGetter>((SectionableDataGetter)value));
            map.put(loc, turret);
        });
        HashMap protectedBlocks = provider.get("protectedBlocks").asMap(new HashMap(), (map, key, value) -> {
            SimpleLocation loc = key.asSimpleLocation();
            SimpleLocation sign = value.get("sign").asSimpleLocation();
            String password = value.getString("password");
            UUID owner = value.get("owner").asUUID();
            long sinceProtectionSign = value.getLong("since");
            String protectionTypeStr = value.getString("protectionType");
            ProtectionSign.ProtectionType protectionType = protectionTypeStr == null ? ProtectionSign.ProtectionType.PROTECTED : ProtectionSign.ProtectionType.valueOf(protectionTypeStr);
            HashMap players = value.get("players").asMap(new HashMap(), (proMap, proKey, proValue) -> proMap.put(proKey.asUUID(), proValue.asBoolean()));
            HashMap kingdoms = value.get("kingdoms").asMap(new HashMap(), (proMap, proKey, proValue) -> proMap.put(proKey.asUUID(), proValue.asBoolean()));
            map.put(loc, new ProtectionSign(loc, sign, owner, protectionType, password, sinceProtectionSign, players, kingdoms));
        });
        return new Land(id, kingdom, claimedBy, structures, turrets, protectedBlocks, since);
    }
}

