/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.data.DataManager;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.data.handlers.DataHandlerLand;
import org.kingdoms.main.Kingdoms;

public class LandManager
extends DataManager<SimpleChunkLocation, Land> {
    public static final Map<SimpleChunkLocation, List<Consumer<Land>>> QUERIED_LANDS = new ConcurrentHashMap<SimpleChunkLocation, List<Consumer<Land>>>(100);

    public LandManager(KingdomsDataCenter dataCenter) {
        super("lands", dataCenter.constructDatabase(KingdomsConfig.DATABASE_TABLES_LANDS.getString(), "lands", new DataHandlerLand()), true, false);
        this.autoSave(Kingdoms.get());
    }

    public CompletableFuture<Collection<Land>> getLands(Collection<SimpleChunkLocation> locations) {
        CompletableFuture<Collection<Land>> completableFuture = new CompletableFuture<Collection<Land>>();
        Kingdoms.taskScheduler().async().execute(() -> {
            ArrayList<Land> loaded = new ArrayList<Land>(locations.size());
            HashSet chosenLocs = locations;
            for (SimpleChunkLocation location : locations) {
                Land land2 = (Land)this.getDataIfLoaded(location);
                if (land2 == null) continue;
                loaded.add(land2);
                if (chosenLocs == locations) {
                    chosenLocs = new HashSet(locations);
                }
                chosenLocs.remove(location);
            }
            if (chosenLocs.isEmpty()) {
                completableFuture.complete(loaded);
            } else {
                for (SimpleChunkLocation chosenLoc : chosenLocs) {
                    Set finalChosenLocs = chosenLocs;
                    LandManager.queryLand(chosenLoc, land -> {
                        loaded.add((Land)land);
                        finalChosenLocs.remove(chosenLoc);
                        if (finalChosenLocs.isEmpty()) {
                            completableFuture.complete(loaded);
                        }
                    });
                }
            }
        });
        return completableFuture;
    }

    public static void queryLand(SimpleChunkLocation chunk) {
        LandManager.queryLand(chunk, null);
    }

    public static void queryLand(SimpleChunkLocation chunk, Consumer<Land> consumer) {
        List<Consumer<Land>> query = QUERIED_LANDS.get(chunk);
        if (query == null) {
            query = new ArrayList<Consumer<Land>>();
            QUERIED_LANDS.put(chunk, consumer == null ? new ArrayList() : new ArrayList(1));
        }
        if (consumer != null) {
            query.add(consumer);
        }
    }
}

