/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.dependencies.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.kingdoms.dependencies.classpath.BootstrapProvider;
import org.kingdoms.dependencies.classpath.LoadingException;

public final class JarInJarClassLoader
extends URLClassLoader {
    public JarInJarClassLoader(ClassLoader loaderClassLoader, String jarResourcePath) throws LoadingException {
        super(new URL[]{JarInJarClassLoader.extractJar(loaderClassLoader, jarResourcePath)}, loaderClassLoader);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public void close() throws IOException {
        super.close();
        URL[] urls = this.getURLs();
        if (urls.length == 0) {
            return;
        }
        try {
            Path path = Paths.get(urls[0].toURI());
            Files.deleteIfExists(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> BootstrapProvider instantiatePlugin(String bootstrapClass, Class<T> loaderPluginType, T loaderPlugin) throws LoadingException {
        Constructor<BootstrapProvider> constructor;
        Class<BootstrapProvider> plugin;
        try {
            plugin = this.loadClass(bootstrapClass).asSubclass(BootstrapProvider.class);
        }
        catch (ReflectiveOperationException e) {
            throw new LoadingException("Unable to load bootstrap class", e);
        }
        try {
            constructor = plugin.getConstructor(loaderPluginType);
        }
        catch (ReflectiveOperationException e) {
            throw new LoadingException("Unable to get bootstrap constructor", e);
        }
        try {
            return constructor.newInstance(loaderPlugin);
        }
        catch (ReflectiveOperationException e) {
            throw new LoadingException("Unable to create bootstrap plugin instance", e);
        }
    }

    public static URL extractJar(ClassLoader loaderClassLoader, String jarResourcePath) throws LoadingException {
        Path path;
        URL jarInJar = loaderClassLoader.getResource(jarResourcePath);
        if (jarInJar == null) {
            throw new LoadingException("Could not locate jar-in-jar");
        }
        try {
            path = Files.createTempFile("kingdoms-jarinjar", ".jar.tmp", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new LoadingException("Unable to create a temporary file", e);
        }
        path.toFile().deleteOnExit();
        try (InputStream in = jarInJar.openStream();){
            Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new LoadingException("Unable to copy jar-in-jar to temporary path", e);
        }
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new LoadingException("Unable to get URL from path", e);
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

