/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.general;

import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.kingdoms.abstraction.GroupOperator;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;

public class GroupShieldPurchaseEvent
extends KingdomsEvent
implements Cancellable,
GroupOperator,
PlayerOperator {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled;
    private final Group group;
    @Nullable
    private final KingdomPlayer player;
    private long shieldDuration;
    private long resourcePointsCost;

    public GroupShieldPurchaseEvent(Group group, @Nullable KingdomPlayer player, long shieldDuration, long resourcePointsCost) {
        this.group = group;
        this.player = player;
        this.shieldDuration = shieldDuration;
        this.resourcePointsCost = resourcePointsCost;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public long getResourcePointsCost() {
        return this.resourcePointsCost;
    }

    public long getShieldDuration() {
        return this.shieldDuration;
    }

    public void setResourcePointsCost(long resourcePointsCost) {
        this.resourcePointsCost = resourcePointsCost;
    }

    public void setShieldDuration(long shieldDuration) {
        if (shieldDuration < 0L) {
            throw new IllegalArgumentException("Shield duration must not be negative");
        }
        this.shieldDuration = shieldDuration;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    @Nullable
    public KingdomPlayer getPlayer() {
        return this.player;
    }

    @Override
    @Nullable
    public Group getGroup() {
        return this.group;
    }
}

