/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.general;

import java.util.Objects;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.kingdoms.abstraction.KingdomOperator;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;

public class KingdomDisbandEvent
extends KingdomsEvent
implements Cancellable,
GroupDisband,
KingdomOperator {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled;
    private final GroupDisband.Reason reason;
    private final Kingdom kingdom;

    public KingdomDisbandEvent(Kingdom kingdom, GroupDisband.Reason reason) {
        this.kingdom = kingdom;
        this.reason = Objects.requireNonNull(reason, "Disband reason cannot be null");
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public @NonNull Kingdom getKingdom() {
        return this.kingdom;
    }

    @Override
    public GroupDisband.Reason getReason() {
        return this.reason;
    }
}

