/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import org.bukkit.entity.Player;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIPathContainer;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.provider.MessageBuilder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0007\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lorg/kingdoms/gui/GUIBuilder;", "", "name", "Lorg/kingdoms/gui/GUIPathContainer;", "(Lorg/kingdoms/gui/GUIPathContainer;)V", "", "(Ljava/lang/String;)V", "inventoryGUIOnly", "", "getInventoryGUIOnly", "()Z", "setInventoryGUIOnly", "(Z)V", "messageSettings", "Lorg/kingdoms/locale/provider/MessageBuilder;", "getMessageSettings", "()Lorg/kingdoms/locale/provider/MessageBuilder;", "setMessageSettings", "(Lorg/kingdoms/locale/provider/MessageBuilder;)V", "optional", "getOptional", "setOptional", "player", "Lorg/bukkit/entity/Player;", "getPlayer", "()Lorg/bukkit/entity/Player;", "setPlayer", "(Lorg/bukkit/entity/Player;)V", "build", "T", "Lorg/kingdoms/gui/InteractiveGUI;", "()Lorg/kingdoms/gui/InteractiveGUI;", "forPlayer", "withSettings", "core"})
public final class GUIBuilder {
    @NotNull
    private final String name;
    public Player player;
    @Nullable
    private MessageBuilder messageSettings;
    private boolean optional;
    private boolean inventoryGUIOnly;

    public GUIBuilder(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    @NotNull
    public final Player getPlayer() {
        Player player = this.player;
        if (player != null) {
            return player;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"player");
        return null;
    }

    public final void setPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"<set-?>");
        this.player = player;
    }

    @Nullable
    public final MessageBuilder getMessageSettings() {
        return this.messageSettings;
    }

    public final void setMessageSettings(@Nullable MessageBuilder messageBuilder) {
        this.messageSettings = messageBuilder;
    }

    public final boolean getOptional() {
        return this.optional;
    }

    public final void setOptional(boolean bl) {
        this.optional = bl;
    }

    public final boolean getInventoryGUIOnly() {
        return this.inventoryGUIOnly;
    }

    public final void setInventoryGUIOnly(boolean bl) {
        this.inventoryGUIOnly = bl;
    }

    public GUIBuilder(@NotNull GUIPathContainer name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.getGUIPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name.guiPath");
        this(string);
    }

    @NotNull
    public final GUIBuilder withSettings(@NotNull MessageBuilder messageSettings) {
        Intrinsics.checkNotNullParameter((Object)messageSettings, (String)"messageSettings");
        this.messageSettings = messageSettings;
        return this;
    }

    @NotNull
    public final GUIBuilder forPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.setPlayer(player);
        return this;
    }

    @NotNull
    public final GUIBuilder optional() {
        this.optional = true;
        return this;
    }

    @NotNull
    public final GUIBuilder inventoryGUIOnly() {
        this.inventoryGUIOnly = true;
        return this;
    }

    @Nullable
    public final <T extends InteractiveGUI> T build() {
        Player player = this.getPlayer();
        MessageBuilder messageBuilder = this.messageSettings;
        if (messageBuilder == null) {
            messageBuilder = new MessageBuilder();
        }
        return (T)GUIAccessor.prepare(player, this.name, this.optional, messageBuilder, this.inventoryGUIOnly);
    }
}

