/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.gui.objects.GUIOptionObject;
import org.kingdoms.locale.provider.MessageBuilder;

public class GUIOption {
    protected final String name;
    protected final GUIOptionObject settings;
    private ItemStack item;
    protected Map<ClickType, Runnable> runnables;
    protected Consumer<String> conversation;

    public GUIOption(String name, GUIOptionObject settings) {
        this.name = Objects.requireNonNull(name, "GUI option name is null");
        this.settings = Objects.requireNonNull(settings, "GUI option settings is null");
    }

    public void defineVariables(MessageBuilder builder) {
        this.item = this.settings.defineVariables(builder);
    }

    public GUIOptionObject getSettings() {
        return this.settings;
    }

    public String getName() {
        return this.name;
    }

    public GUIOption clone() {
        GUIOption option = new GUIOption(this.name, this.settings);
        option.conversation = this.conversation;
        option.runnables = this.runnables;
        return option;
    }

    public ItemStack getItem() {
        return Objects.requireNonNull(this.item, "Getting item before defining variables");
    }

    public Map<ClickType, Runnable> getRunnables() {
        return this.runnables;
    }

    public void setRunnables(Map<ClickType, Runnable> runnables) {
        this.runnables = runnables;
    }

    public Consumer<String> getConversation() {
        return this.conversation;
    }

    public void setConversation(Consumer<String> conversation) {
        this.conversation = conversation;
    }
}

