/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.container;

import java.util.ArrayList;
import java.util.List;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KeyedConfigAccessor;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.snakeyaml.exceptions.Mark;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.container.ConditionalMessageContainer;
import org.kingdoms.locale.compiler.container.SimpleMessageContainer;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.config.ConfigSection;

public interface MessageContainer {
    public MessageObject get(MessageBuilder var1);

    public static List<Pair<ConditionalCompiler.LogicalOperand, String>> parseRaw(KeyedConfigAccessor accessor) {
        ArrayList<Pair<ConditionalCompiler.LogicalOperand, String>> list2 = new ArrayList<Pair<ConditionalCompiler.LogicalOperand, String>>();
        if (!accessor.isSet()) {
            return list2;
        }
        ConfigAccessor variableSection = accessor.getSection();
        if (variableSection != null) {
            ConfigSection varSection = variableSection.getSection();
            for (String conds : variableSection.getKeys()) {
                list2.add(Pair.of(ConditionalCompiler.compile(conds).evaluate(), varSection.getString(conds)));
            }
        } else {
            list2.add(Pair.of(null, accessor.getString()));
        }
        return list2;
    }

    public static MessageContainer parse(KeyedConfigAccessor accessor) {
        MessageContainer container;
        ConfigAccessor variableSection = accessor.getSection();
        if (variableSection != null) {
            ConfigSection varSection = variableSection.getSection();
            ArrayList<Pair<ConditionalCompiler.LogicalOperand, MessageObject>> messages = new ArrayList<Pair<ConditionalCompiler.LogicalOperand, MessageObject>>(2);
            container = new ConditionalMessageContainer(messages);
            for (String conds : variableSection.getKeys()) {
                ConditionalCompiler.LogicalOperand condition = ConditionalCompiler.compile(conds).evaluate();
                MessageObject msg = MessageCompiler.compile(varSection.getString(conds), MessageCompiler.defaultSettingsWithErroHandler(exes -> {
                    Mark mark = varSection.getNode(conds).getStartMark();
                    KLogger.warn("While parsing '" + accessor.getDynamicOption() + "' macro, line " + mark.getLine() + ":\n" + exes.joinExceptions());
                }));
                messages.add(Pair.of(condition, msg));
            }
        } else {
            container = new SimpleMessageContainer(MessageCompiler.compile(accessor.getString(), MessageCompiler.defaultSettingsWithErroHandler(exes -> {
                Mark mark = accessor.getNode().getStartMark();
                KLogger.warn("While parsing '" + accessor.getDynamicOption() + "' macro, line " + mark.getLine() + ":\n" + exes.joinExceptions());
            })));
        }
        return container;
    }
}

