/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.placeholders;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.placeholders.KingdomsPlaceholder;
import org.kingdoms.locale.compiler.placeholders.KingdomsPlaceholderTranslationContext;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.RomanNumber;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.time.TimeFormatter;

public class Placeholder {
    public final @NonNull KingdomsPlaceholder identifier;
    protected final @Nullable String fn;
    public final @Nullable Modifier modifier;
    private final String pointer;
    private final boolean fnAsFormat;
    private final boolean positional;
    protected final @NonNull Map<String, String> parameters;
    private int position;

    protected Placeholder(KingdomsPlaceholder identifier, String fn, String pointer, Modifier modifier, boolean fnAsFormat, Map<String, String> parameters) {
        this.identifier = identifier;
        this.fn = fn;
        this.modifier = modifier;
        this.fnAsFormat = fnAsFormat;
        this.pointer = pointer;
        this.parameters = parameters == null ? new HashMap() : parameters;
        this.positional = parameters.containsKey("1");
    }

    public String getPointer() {
        return this.pointer;
    }

    public boolean hasFormat() {
        return this.fnAsFormat;
    }

    public void unknownFunction() {
        KLogger.warn("Unknown function for placeholder " + this);
    }

    private void err(String type, String parameter) {
        KLogger.error("Could not parse " + type + " parameter '" + parameter + "' for placeholder function " + this);
    }

    public void invalidArg(String parameter) {
        KLogger.error("Invalid value for parameter '" + parameter + "' with value '" + this.parameters.get(parameter) + "' for placeholder function " + this);
    }

    String incArg() {
        return Character.toString((char)(48 + ++this.position));
    }

    public void requireArguments(String ... args) {
        if (this.positional && this.parameters.size() < args.length) {
            throw new IllegalArgumentException("Missing required parameter '" + this.parameters.size() + "' for placeholder function " + this);
        }
        for (String arg : args) {
            if (this.parameters.containsKey(arg)) continue;
            throw new IllegalArgumentException("Missing required parameter '" + arg + "' for placeholder function " + this);
        }
    }

    public String toString() {
        StringBuilder params = new StringBuilder();
        for (Map.Entry<String, String> param : this.parameters.entrySet()) {
            params.append(param.getKey()).append('=').append(param.getValue()).append(", ");
        }
        if (params.length() != 0) {
            params.setLength(params.length() - 2);
        }
        return "Placeholder{ " + this.identifier.getName() + ':' + this.fn + " [" + params + "] }";
    }

    public boolean isPointerOther() {
        return "other".equals(this.pointer);
    }

    public Object request(PlaceholderContextBuilder placeholderContextBuilder) {
        boolean isDefault;
        Object translated;
        if (this.isPointerOther()) {
            placeholderContextBuilder = placeholderContextBuilder.clone();
            placeholderContextBuilder.switchContext();
        }
        if ((translated = this.identifier.translate(new KingdomsPlaceholderTranslationContext(placeholderContextBuilder, this))) == null) {
            isDefault = true;
            translated = this.identifier.getConfiguredDefaultValue();
            if (translated == null) {
                translated = this.identifier.getDefault();
            }
        } else {
            isDefault = false;
        }
        translated = Placeholder.modify(this.modifier, translated);
        if (this.fnAsFormat) {
            YamlConfigAccessor section = KingdomsConfig.PLACEHOLDERS_FORMATS.getManager().getSection().noDefault();
            String formatter = this.fn.toLowerCase();
            String format = null;
            if (section != null) {
                ConfigAccessor placeholderSection = section.gotoSection(formatter);
                format = placeholderSection != null ? (isDefault ? placeholderSection.getString("default") : placeholderSection.getString("normal")) : section.getString(formatter);
            }
            if (format == null) {
                KLogger.error("Unknown placeholder format '" + this.fn + "' in " + this);
            } else {
                translated = StringUtils.replaceOnce(format, '%', translated.toString());
            }
        }
        return translated;
    }

    public static Object modify(Modifier modifier, Object translated) {
        if (modifier == null) {
            return translated;
        }
        if (translated instanceof Number) {
            Number number = (Number)translated;
            if (modifier == Modifier.ROMAN) {
                return RomanNumber.toRoman(number.intValue());
            }
            if (modifier == Modifier.TIME) {
                return TimeFormatter.of(number.longValue());
            }
            if (modifier == Modifier.DATE) {
                return TimeFormatter.dateOf(number.longValue());
            }
            if (translated instanceof Double || translated instanceof Float) {
                double doubleValue = number.doubleValue();
                if (modifier == Modifier.SHORT) {
                    return MathUtils.getShortNumber(doubleValue);
                }
                return StringUtils.toFancyNumber(doubleValue);
            }
            double longValue = number.longValue();
            if (modifier == Modifier.SHORT) {
                return MathUtils.getShortNumber(longValue);
            }
            return StringUtils.toFancyNumber(longValue);
        }
        if (translated instanceof Boolean) {
            boolean enabled = (Boolean)translated;
            return (enabled ? KingdomsLang.ENABLED : KingdomsLang.DISABLED).parse(new Object[0]);
        }
        return translated;
    }

    public String getString(String parameter) {
        if (this.positional) {
            parameter = this.incArg();
        }
        return this.parameters.get(parameter);
    }

    public boolean getBool(String parameter) {
        switch (StringUtils.toLatinLowerCase(StringUtils.deleteWhitespace(this.positional ? this.incArg() : parameter))) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        this.err("boolean", parameter);
        return false;
    }

    public boolean fnIs(String fn) {
        return this.positional || this.fn != null && this.fn.equalsIgnoreCase(fn);
    }

    public int getNumber(String parameter) {
        try {
            String value = this.parameters.get(this.positional ? this.incArg() : parameter);
            if (value == null) {
                return 0;
            }
            return Integer.parseInt(StringUtils.deleteWhitespace(value));
        }
        catch (NumberFormatException ex) {
            this.err("number", parameter);
            ex.printStackTrace();
            return 0;
        }
    }

    public static enum Modifier {
        SHORT,
        FANCY,
        ROMAN,
        BOOL,
        TIME,
        DATE;

        public final int skip = this.name().length() + 1;
        public final String constName = this.name() + '_';
        public static final Modifier[] MODIFIERS;

        static {
            MODIFIERS = Modifier.values();
        }

        public static final class Data {
            public static final int MIN_LENGTH = Arrays.stream(MODIFIERS).min(Comparator.comparingInt(a -> a.name().length())).get().name().length();
        }
    }
}

