/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.placeholders;

import java.util.Locale;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Relational;
import me.clip.placeholderapi.expansion.manager.LocalExpansionManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.compiler.placeholders.Placeholder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.services.managers.SoftService;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u0000 \u00072\u00020\u0001:\u0007\u0007\b\t\n\u000b\f\rJ\b\u0010\u0002\u001a\u00020\u0003H&J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType;", "", "rebuild", "", "request", "contextProvider", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderContextBuilder;", "Companion", "ExternalOrLocal", "Internal", "Local", "Macro", "ModifiablePlaceholder", "Permission", "core"})
public interface PlaceholderType {
    @NotNull
    public static final Companion Companion = org.kingdoms.locale.compiler.placeholders.PlaceholderType$Companion.$$INSTANCE;

    @Nullable
    public Object request(@NotNull PlaceholderContextBuilder var1);

    @NotNull
    public String rebuild();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType$ModifiablePlaceholder;", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType;", "modifier", "Lorg/kingdoms/locale/compiler/placeholders/Placeholder$Modifier;", "(Lorg/kingdoms/locale/compiler/placeholders/Placeholder$Modifier;)V", "getModifier", "()Lorg/kingdoms/locale/compiler/placeholders/Placeholder$Modifier;", "modify", "", "translated", "modifyString", "", "str", "core"})
    public static abstract class ModifiablePlaceholder
    implements PlaceholderType {
        @Nullable
        private final Placeholder.Modifier modifier;

        protected ModifiablePlaceholder(@Nullable Placeholder.Modifier modifier) {
            this.modifier = modifier;
        }

        @Nullable
        public final Placeholder.Modifier getModifier() {
            return this.modifier;
        }

        @NotNull
        protected final String modifyString(@NotNull String str) {
            String string;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            if (this.modifier == null) {
                string = '%' + str + '%';
            } else {
                StringBuilder stringBuilder = new StringBuilder().append('%');
                String string2 = this.modifier.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                string = stringBuilder.append(string2).append('_').append(str).append('%').toString();
            }
            return string;
        }

        @Nullable
        protected final Object modify(@Nullable Object translated) {
            return this.modifier == null || translated == null ? translated : Placeholder.modify(this.modifier, translated);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType$Permission;", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType$ModifiablePlaceholder;", "modifier", "Lorg/kingdoms/locale/compiler/placeholders/Placeholder$Modifier;", "permission", "", "(Lorg/kingdoms/locale/compiler/placeholders/Placeholder$Modifier;Ljava/lang/String;)V", "rebuild", "request", "", "contextProvider", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderContextBuilder;", "core"})
    public static final class Permission
    extends ModifiablePlaceholder {
        @NotNull
        private final String permission;

        public Permission(@Nullable Placeholder.Modifier modifier, @NotNull String permission) {
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            super(modifier);
            this.permission = permission;
        }

        @Override
        @Nullable
        public Object request(@NotNull PlaceholderContextBuilder contextProvider) {
            Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
            if (!(contextProvider.main instanceof Player)) {
                return null;
            }
            Object object = contextProvider.main;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
            return this.modify(((Player)object).hasPermission(this.permission));
        }

        @Override
        @NotNull
        public String rebuild() {
            return this.modifyString("perm_" + StringsKt.replace$default((String)this.permission, (char)'.', (char)'_', (boolean)false, (int)4, null));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType$ExternalOrLocal;", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType;", "relational", "", "identifier", "", "parameter", "(ZLjava/lang/String;Ljava/lang/String;)V", "rebuild", "request", "", "contextProvider", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderContextBuilder;", "toString", "core"})
    public static final class ExternalOrLocal
    implements PlaceholderType {
        private final boolean relational;
        @NotNull
        private final String identifier;
        @NotNull
        private final String parameter;

        public ExternalOrLocal(boolean relational, @NotNull String identifier, @NotNull String parameter) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            this.relational = relational;
            this.identifier = identifier;
            this.parameter = parameter;
        }

        @Override
        @Nullable
        public Object request(@NotNull PlaceholderContextBuilder contextProvider) {
            String string;
            Map<String, Object> map;
            Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
            PlaceholderContextBuilder $this$request_u24lambda_u2d4 = contextProvider;
            boolean bl = false;
            Map<String, Object> map2 = map = $this$request_u24lambda_u2d4.placeholders;
            if (map2 != null) {
                Intrinsics.checkNotNullExpressionValue(map2, (String)"placeholders");
                Map<String, Object> placeholders = map;
                boolean bl2 = false;
                Object object = placeholders.get(this.identifier + '_' + this.parameter);
                if (object != null) {
                    Object it = object;
                    boolean bl3 = false;
                    return it;
                }
            }
            Map<String, Object> map3 = map = $this$request_u24lambda_u2d4.groupedPlaceholders;
            if (map3 != null) {
                Object object;
                Intrinsics.checkNotNullExpressionValue(map3, (String)"groupedPlaceholders");
                Map<String, Object> gp = map;
                boolean bl4 = false;
                Object object2 = (PlaceholderContextProvider)gp.get(this.identifier);
                if (object2 != null && (object2 = (object = object2.processPlaceholder(this.parameter))) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"processPlaceholder(parameter)");
                    Object it = object;
                    boolean bl5 = false;
                    return it;
                }
            }
            if (!SoftService.PLACEHOLDERAPI.isAvailable()) {
                return null;
            }
            if (!($this$request_u24lambda_u2d4.main instanceof OfflinePlayer)) {
                return null;
            }
            LocalExpansionManager localExpansionManager = PlaceholderAPIPlugin.getInstance().getLocalExpansionManager();
            Intrinsics.checkNotNullExpressionValue((Object)localExpansionManager, (String)"getInstance().localExpansionManager");
            LocalExpansionManager expansions = localExpansionManager;
            PlaceholderExpansion placeholderExpansion = expansions.getExpansion(this.identifier);
            if (placeholderExpansion == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)placeholderExpansion, (String)"expansions.getExpansion(identifier) ?: return null");
            PlaceholderExpansion expansion = placeholderExpansion;
            if ($this$request_u24lambda_u2d4.canHandleRelational() && expansion instanceof Relational && $this$request_u24lambda_u2d4.relationalSecond instanceof Player && $this$request_u24lambda_u2d4.main instanceof Player) {
                string = ((Relational)expansion).onPlaceholderRequest((Player)$this$request_u24lambda_u2d4.main, (Player)$this$request_u24lambda_u2d4.relationalSecond, this.parameter);
            } else if ($this$request_u24lambda_u2d4.main instanceof OfflinePlayer) {
                string = expansion.onRequest((OfflinePlayer)$this$request_u24lambda_u2d4.main, this.parameter);
            } else {
                return null;
            }
            String translated = string;
            return Companion.wrapWithDefaultContextProvider(translated);
        }

        @Override
        @NotNull
        public String rebuild() {
            char c = '%';
            String string = this.relational ? "rel_" : "";
            return c + string + this.identifier + '_' + this.parameter + '%';
        }

        @NotNull
        public String toString() {
            return "ExternalOrLocal{ " + (this.relational ? "Relational " : "") + this.identifier + ':' + this.parameter + " }";
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType$Local;", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType$ModifiablePlaceholder;", "modifier", "Lorg/kingdoms/locale/compiler/placeholders/Placeholder$Modifier;", "identifier", "", "(Lorg/kingdoms/locale/compiler/placeholders/Placeholder$Modifier;Ljava/lang/String;)V", "rebuild", "request", "", "contextProvider", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderContextBuilder;", "toString", "core"})
    public static final class Local
    extends ModifiablePlaceholder {
        @NotNull
        private final String identifier;

        public Local(@Nullable Placeholder.Modifier modifier, @NotNull String identifier) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            super(modifier);
            this.identifier = identifier;
        }

        @Override
        @Nullable
        public Object request(@NotNull PlaceholderContextBuilder contextProvider) {
            int index;
            Object object;
            Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
            Map<String, Object> map = contextProvider.placeholders;
            if (map != null && (object = map.get(this.identifier)) != null) {
                Object it = object;
                boolean bl = false;
                return this.modify(it);
            }
            if (contextProvider.groupedPlaceholders != null && (index = StringsKt.indexOf$default((CharSequence)this.identifier, (char)'_', (int)0, (boolean)false, (int)6, null)) > 0) {
                String string = this.identifier.substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String id = string;
                String string2 = this.identifier.substring(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                String param = string2;
                PlaceholderContextProvider handler = contextProvider.groupedPlaceholders.get(id);
                if (handler != null) {
                    return this.modify(handler.processPlaceholder(param));
                }
            }
            return null;
        }

        @NotNull
        public String toString() {
            return "Local{ " + (this.getModifier() == null ? "" : "" + (Object)((Object)this.getModifier()) + '_') + this.identifier + " }";
        }

        @Override
        @NotNull
        public String rebuild() {
            return this.modifyString(this.identifier);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType$Macro;", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType;", "name", "", "(Ljava/lang/String;)V", "rebuild", "request", "", "contextProvider", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderContextBuilder;", "toString", "core"})
    public static final class Macro
    implements PlaceholderType {
        @NotNull
        private final String name;

        public Macro(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @Override
        @Nullable
        public Object request(@NotNull PlaceholderContextBuilder contextProvider) {
            Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
            if (!(contextProvider instanceof MessageBuilder)) {
                return MessageCompiler.compile("&cUnsupported provided context: " + contextProvider);
            }
            MessageObject macro = ((MessageBuilder)contextProvider).getLanguage().getVariable((MessageBuilder)contextProvider, this.name);
            MessageObject messageObject = macro;
            if (messageObject == null) {
                messageObject = MessageCompiler.compile("&8(&4Unknown variable &e'" + this.name + "'&8)");
            }
            return messageObject;
        }

        @Override
        @NotNull
        public String rebuild() {
            return "{$" + this.name + '}';
        }

        @NotNull
        public String toString() {
            return "Macro { " + this.name + " }";
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType$Internal;", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType;", "relational", "", "placeholder", "Lorg/kingdoms/locale/compiler/placeholders/Placeholder;", "(ZLorg/kingdoms/locale/compiler/placeholders/Placeholder;)V", "rebuild", "", "request", "", "contextProvider", "Lorg/kingdoms/locale/compiler/placeholders/PlaceholderContextBuilder;", "toString", "core"})
    public static final class Internal
    implements PlaceholderType {
        private final boolean relational;
        @NotNull
        private final Placeholder placeholder;

        public Internal(boolean relational, @NotNull Placeholder placeholder) {
            Intrinsics.checkNotNullParameter((Object)placeholder, (String)"placeholder");
            this.placeholder = placeholder;
            this.relational = relational || placeholder.isPointerOther();
        }

        @Override
        @Nullable
        public Object request(@NotNull PlaceholderContextBuilder contextProvider) {
            Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
            return Companion.wrapWithDefaultContextProvider(this.placeholder.request(contextProvider));
        }

        @NotNull
        public String toString() {
            return "Internal{ " + (this.relational ? "Relational " : "") + this.placeholder + " }";
        }

        @Override
        @NotNull
        public String rebuild() {
            StringBuilder str = new StringBuilder('%' + (this.relational ? "rel_" : "") + "kingdoms_");
            if (this.placeholder.modifier != null) {
                String string = this.placeholder.modifier.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                str.append(string).append('_');
            }
            String string = this.placeholder.identifier.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            str.append(string);
            if (this.placeholder.fn != null) {
                if (this.placeholder.hasFormat()) {
                    str.append('@').append(this.placeholder.fn);
                } else {
                    str.append(':').append(this.placeholder.fn).append(' ');
                    Map<String, String> map = this.placeholder.parameters;
                    Intrinsics.checkNotNullExpressionValue(map, (String)"placeholder.parameters");
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        str.append(key).append('=').append(value).append(", ");
                    }
                    Map<String, String> map2 = this.placeholder.parameters;
                    Intrinsics.checkNotNullExpressionValue(map2, (String)"placeholder.parameters");
                    if (!map2.isEmpty()) {
                        str.setLength(str.length() - 2);
                    }
                }
            }
            return "" + str + '%';
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0005"}, d2={"Lorg/kingdoms/locale/compiler/placeholders/PlaceholderType$Companion;", "", "()V", "wrapWithDefaultContextProvider", "placeholder", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @Nullable
        public final Object wrapWithDefaultContextProvider(@Nullable Object placeholder) {
            return !(placeholder instanceof String) ? placeholder : PlaceholderTranslationContext.withDefaultContext(placeholder);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

