/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.main;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.DebugSettings;
import org.kingdoms.utils.debugging.StacktraceSettings;
import org.kingdoms.utils.string.StringUtils;

public final class KLogger {
    private static final String DEBUG = "&7[&5DEBUG&7] &6";
    private static final Logger LOGGER = Kingdoms.get().getLogger();
    private static final Set<String> CONDITIONALS = new HashSet<String>();
    private static final AtomicInteger ID_GEN = new AtomicInteger();
    private static final Cooldown<String> COOLDOWN = new Cooldown();
    private boolean ignore;
    private int id;
    private final DebugNS ns;

    public KLogger(DebugNS ns) {
        this(ns, true, null, null);
    }

    public KLogger(DebugNS ns, boolean printHeader, Object cooldownObject, Duration cooldown) {
        this.ns = ns;
        if (!KLogger.isDebugging()) {
            return;
        }
        if (cooldownObject != null) {
            if (COOLDOWN.isInCooldown(cooldownObject.toString())) {
                this.ignore = true;
                return;
            }
            COOLDOWN.add(cooldownObject.toString(), cooldown);
        }
        this.id = ID_GEN.getAndIncrement();
        if (printHeader) {
            this.log("Debug Info&8:");
            this.log("   &7- &2Platform&8: &9" + Bukkit.getVersion() + " &8- &9" + Bukkit.getBukkitVersion());
            this.log("   &7- &2Plugin Version&8: &9" + Kingdoms.get().getDescription().getVersion());
            StackTraceElement stack = this.getFirstStackTrace();
            this.log("   &7- &2Source&8: &9" + stack.getClassName() + "&8.&9" + stack.getMethodName() + "&8: &5" + stack.getLineNumber());
        }
    }

    public static void info(Object str) {
        LOGGER.info(str.toString());
    }

    @Deprecated
    public static void temp(Object str) {
        KLogger.info(str);
    }

    public static boolean calledFrom(Class<?> clazz) {
        for (StackTraceElement stack : Thread.currentThread().getStackTrace()) {
            if (!stack.getClassName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public static void cond(String condition, String msg) {
        if (CONDITIONALS.contains(condition)) {
            KLogger.info('[' + condition + "] " + msg);
        }
    }

    public static boolean isCond(String condition) {
        return CONDITIONALS.contains(condition);
    }

    public static void cond(String condition) {
        CONDITIONALS.add(condition);
    }

    public static void debug(DebugNS ns, Supplier<Object> obj) {
        if (KLogger.isDebugging()) {
            String nsStr = ns == null ? "" : "&8[&5" + ns.namespace() + "&8] &6";
            String str = obj.get().toString();
            String fullMsg = DEBUG + nsStr + str;
            MessageHandler.sendConsolePluginMessage(fullMsg);
            Bukkit.getOnlinePlayers().stream().filter(x -> KingdomsPluginPermission.DEBUG.hasPermission((CommandSender)x, true)).filter(x -> ns == null || DebugSettings.getSettings((CommandSender)x).isWhitelist() == DebugSettings.getSettings((CommandSender)x).getList().contains(ns)).forEach(x -> MessageHandler.sendPlayerPluginMessage(x, fullMsg));
            if (ns != null && StacktraceSettings.isWhitelist == StacktraceSettings.list.contains(ns)) {
                StringUtils.printStackTrace();
            }
        }
    }

    public static boolean isDebugging() {
        return DebugContainer.DEBUGGING;
    }

    public static void debug(DebugNS ns, Object str) {
        KLogger.debug(ns, () -> str);
    }

    public static void cond(String cond, Object msg) {
        if (KLogger.isCond(cond)) {
            KLogger.info(msg);
        }
    }

    public static void end(String cond) {
        CONDITIONALS.remove(cond);
    }

    public static void warn(Object str) {
        LOGGER.warning(str.toString());
    }

    public static void error(Object str) {
        LOGGER.severe(str.toString());
    }

    public KLogger property(Object name, boolean bool) {
        this.property(name, (bool ? "&2" : "&c") + bool);
        return this;
    }

    public KLogger property(Object name, Object value) {
        this.log(name + "&8: &2" + value);
        return this;
    }

    private StackTraceElement getFirstStackTrace() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).filter(x -> !x.getClassName().startsWith(this.getClass().getName())).findFirst().orElseThrow(() -> new IllegalStateException("Cannot obtain stack trace"));
    }

    public void end() {
        this.log("-------------------------------------------------");
    }

    public void log(Object str) {
        this.log(this.ns, str);
    }

    public void log(DebugNS ns, Object str) {
        this.log(ns, () -> str);
    }

    public void log(Supplier<Object> str) {
        this.log(this.ns, str);
    }

    public void log(DebugNS ns, Supplier<Object> str) {
        if (this.ignore) {
            return;
        }
        KLogger.debug(null, () -> "&8[&5" + ns.namespace() + "&8][&7" + this.id + "&8] &6" + str.get());
    }

    private static final class DebugContainer {
        private static final boolean DEBUGGING = KingdomsConfig.DEBUG.getBoolean();

        private DebugContainer() {
        }
    }
}

