/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import com.google.common.base.Strings;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.config.KeyedConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.PvPManager;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.integer.IntHashMap;
import org.kingdoms.utils.internal.integer.IntHashSet;
import org.kingdoms.utils.string.StringUtils;

public final class FlyManager
implements Listener {
    private static final IntHashMap<Integer> WARNINGS_LAND = new IntHashMap();
    private static final IntHashMap<Integer> WARNINGS_UNFRIENDLY = new IntHashMap();
    private static final IntHashMap<Integer> WARNINGS_CHARGES = new IntHashMap();
    private static final IntHashSet PREVENT_FALL_DAMAGE = new IntHashSet();

    public static void preventFallDamage(Entity entity) {
        PREVENT_FALL_DAMAGE.add(entity.getEntityId());
    }

    @EventHandler
    public void onFlightDisableDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (!PREVENT_FALL_DAMAGE.remove(event.getEntity().getEntityId())) {
            return;
        }
        event.setCancelled(true);
        KLogger.debug((DebugNS)KingdomsDebug.FALL$DAMAGE, () -> "Prevented fall damage for " + event.getEntity());
    }

    public static boolean handleCharges(Player player, KingdomPlayer kp, Pair<KeyedConfigAccessor, KingdomsLang> playerCosts, Pair<KeyedConfigAccessor, KingdomsLang> kingdomCosts) {
        String kingdomEqn;
        String chargesEqn;
        Kingdom kingdom = kp.getKingdom();
        Runnable finalizePlayerCosts = null;
        if (SoftService.VAULT.isAvailable() && ServiceVault.isAvailable(ServiceVault.Component.ECO) && !Strings.isNullOrEmpty((String)(chargesEqn = playerCosts.getKey().forWorld((Entity)player).getString()))) {
            double playerCharges = MathUtils.eval(chargesEqn, (OfflinePlayer)player, new Object[0]);
            if (ServiceVault.hasMoney((OfflinePlayer)player, playerCharges)) {
                finalizePlayerCosts = () -> {
                    ServiceVault.withdraw((OfflinePlayer)player, playerCharges);
                    if (KingdomsConfig.KINGDOM_FLY_CHARGES_PLAYERS_PAY_KINGDOM_ENABLED.getBoolean()) {
                        boolean useRp = KingdomsConfig.KINGDOM_FLY_CHARGES_PLAYERS_PAY_KINGDOM_RESOURCE_POINTS.getBoolean();
                        if (useRp) {
                            kingdom.addResourcePoints((long)playerCharges);
                        } else {
                            kingdom.addBank(playerCharges);
                        }
                    }
                };
            } else {
                playerCosts.getValue().sendError((CommandSender)player, "money", StringUtils.toFancyNumber(playerCharges), "interval", KingdomsConfig.KINGDOM_FLY_CHARGES_EVERY_SECONDS.getInt());
                return false;
            }
        }
        if (Strings.isNullOrEmpty((String)(kingdomEqn = kingdomCosts.getKey().forWorld((Entity)player).getString()))) {
            return true;
        }
        double kingdomCharges = MathUtils.eval(kingdomEqn, (OfflinePlayer)player, new Object[0]);
        boolean useRp = KingdomsConfig.KINGDOM_FLY_CHARGES_KINGDOMS_RESOURCE_POINTS.getBoolean();
        if (useRp ? kingdom.hasResourcePoints((long)kingdomCharges) : kingdom.hasMoney(kingdomCharges)) {
            if (useRp) {
                kingdom.addResourcePoints((long)(-kingdomCharges));
            } else {
                kingdom.hasMoney(-kingdomCharges);
            }
        } else {
            kingdomCosts.getValue().sendError((CommandSender)player, "amount", StringUtils.toFancyNumber(kingdomCharges), "interval", KingdomsConfig.KINGDOM_FLY_CHARGES_EVERY_SECONDS.getInt());
            return false;
        }
        if (finalizePlayerCosts != null) {
            finalizePlayerCosts.run();
        }
        return true;
    }

    private static void handleCharges(Player player) {
        if (!player.getAllowFlight()) {
            return;
        }
        if (KingdomsPluginPermission.FLIGHT_BYPASS_CHARGES.hasPermission((CommandSender)player)) {
            return;
        }
        if (PlayerUtils.invulnerableGameMode(player)) {
            return;
        }
        if (WARNINGS_CHARGES.containsKey(player.getEntityId())) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.isFlying() || kp.isAdmin()) {
            return;
        }
        if (!FlyManager.handleCharges(player, kp, Pair.of(KingdomsConfig.KINGDOM_FLY_CHARGES_PLAYERS_AMOUNT.getManager(), KingdomsLang.FLY_CHARGES_CANT_AFFORD), Pair.of(KingdomsConfig.KINGDOM_FLY_CHARGES_KINGDOMS_AMOUNT.getManager(), KingdomsLang.FLY_CHARGES_CANT_AFFORD_KINGDOM))) {
            FlyManager.handleCantPay(player, kp);
        }
    }

    private static void handleCantPay(final Player player, final KingdomPlayer kp) {
        final int warning = KingdomsConfig.KINGDOM_FLY_WARNINGS_CHARGES.getInt();
        if (warning <= 0) {
            FlyManager.disableFly(player, kp);
            return;
        }
        int task = new BukkitRunnable(){
            int counter;
            {
                this.counter = warning;
            }

            public void run() {
                if (this.counter == 0) {
                    WARNINGS_CHARGES.remove(player.getEntityId());
                    FlyManager.disableFlight(kp, player);
                    this.cancel();
                    return;
                }
                KingdomsLang.FLY_WARNINGS_CHARGES.sendError((CommandSender)player, "counter", this.counter);
                --this.counter;
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 20L).getTaskId();
        WARNINGS_CHARGES.put(player.getEntityId(), task);
    }

    private static boolean isNearUnfriendly(final Player player, final int range, boolean action) {
        if (!player.getAllowFlight()) {
            return false;
        }
        if (KingdomsPluginPermission.FLIGHT_NEARBY$ENEMIES.hasPermission((CommandSender)player)) {
            return false;
        }
        if (PlayerUtils.invulnerableGameMode(player)) {
            return false;
        }
        final KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.isFlying() || kp.isAdmin()) {
            return false;
        }
        Kingdom kingdom = kp.getKingdom();
        for (Entity nearby : player.getNearbyEntities((double)range, (double)range, (double)range)) {
            Kingdom otherKingdom;
            KingdomPlayer enemyKp;
            Player enemy;
            if (!(nearby instanceof Player) || PlayerUtils.invulnerableGameMode(enemy = (Player)nearby) || (enemyKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)enemy)).isInSneakMode() || kingdom.hasAttribute(otherKingdom = enemyKp.getKingdom(), (RelationAttribute)StandardRelationAttribute.FLY)) continue;
            if (action && !WARNINGS_UNFRIENDLY.containsKey(player.getEntityId())) {
                final int warning = KingdomsConfig.KINGDOM_FLY_WARNINGS_UNFRIENDLY_NEARBY.getInt();
                if (warning <= 0) {
                    KingdomsLang.FLY_ENEMIES_NEARBY.sendError((CommandSender)player, new Object[0]);
                    FlyManager.disableFly(player, kp);
                } else {
                    int task = new BukkitRunnable(){
                        int counter;
                        {
                            this.counter = warning;
                        }

                        public void run() {
                            if (this.counter == 0) {
                                KingdomsLang.FLY_ENEMIES_NEARBY.sendError((CommandSender)player, new Object[0]);
                                WARNINGS_UNFRIENDLY.remove(player.getEntityId());
                                FlyManager.disableFlight(kp, player);
                                this.cancel();
                                return;
                            }
                            if (FlyManager.isNearUnfriendly(player, range, false)) {
                                KingdomsLang.FLY_WARNINGS_UNFRIENDLY_NEARBY_WARN.sendError((CommandSender)player, "counter", this.counter);
                                --this.counter;
                            } else {
                                KingdomsLang.FLY_WARNINGS_UNFRIENDLY_NEARBY_SAFE.sendMessage((CommandSender)player, "counter", this.counter);
                                WARNINGS_UNFRIENDLY.remove(player.getEntityId());
                                this.cancel();
                            }
                        }
                    }.runTaskTimer((Plugin)Kingdoms.get(), 0L, 20L).getTaskId();
                    WARNINGS_UNFRIENDLY.put(player.getEntityId(), task);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean canFlyInLand(Player player, KingdomPlayer kp, Land to) {
        Kingdom kingdom;
        if (PlayerUtils.invulnerableGameMode(player)) {
            return true;
        }
        if (kp.isAdmin()) {
            return true;
        }
        Kingdom kingdom2 = kingdom = to == null ? null : to.getKingdom();
        if (kingdom == null) {
            return KingdomsConfig.KINGDOM_FLY_ALLOW_UNCLAIMED.getBoolean();
        }
        if (!kp.getKingdom().hasAttribute(kingdom, (RelationAttribute)StandardRelationAttribute.FLY)) {
            Boolean attr;
            Regulator regulator = to.getStructure(Regulator.class);
            if (regulator != null && (attr = regulator.hasAttribute((OfflinePlayer)player, Regulator.Attribute.FLY)) != null) {
                return attr;
            }
            return false;
        }
        return true;
    }

    private static void cancelTasks(Player player) {
        int id = player.getEntityId();
        Integer task = WARNINGS_UNFRIENDLY.remove(id);
        if (task != null) {
            Bukkit.getScheduler().cancelTask(task.intValue());
        }
        if ((task = WARNINGS_LAND.remove(id)) != null) {
            Bukkit.getScheduler().cancelTask(task.intValue());
        }
    }

    private static void disableFlight(KingdomPlayer kp, Player player) {
        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> FlyManager.disableFly(player, kp));
    }

    public static void disableFly(Player player, KingdomPlayer kp) {
        kp.disableFlying(player);
        FlyManager.noFallDamage(player);
    }

    public static void noFallDamage(final Player player) {
        new BukkitRunnable(){
            private int tries;

            public void run() {
                ++this.tries;
                if (player.isOnGround()) {
                    PREVENT_FALL_DAMAGE.remove(player.getEntityId());
                    this.cancel();
                    return;
                }
                if (this.tries / 20 >= 2) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 1L, 1L);
        PREVENT_FALL_DAMAGE.add(player.getEntityId());
    }

    public static void onFlyLandChange(LandChangeEvent event) {
        final Player player = event.getPlayer();
        if (KingdomsPluginPermission.FLIGHT_LANDS.hasPermission((CommandSender)player)) {
            return;
        }
        if (!player.getAllowFlight()) {
            return;
        }
        if (PlayerUtils.invulnerableGameMode(player)) {
            return;
        }
        if (WARNINGS_LAND.containsKey(player.getEntityId())) {
            return;
        }
        final KingdomPlayer kp = event.getKingdomPlayer();
        if (kp.isAdmin() || !kp.isFlying()) {
            return;
        }
        Land to = event.getToLand();
        if (!FlyManager.canFlyInLand(player, kp, to)) {
            final int warning = KingdomsConfig.KINGDOM_FLY_WARNINGS_LAND.getInt();
            if (warning <= 0) {
                KingdomsLang.FLY_OUT_OF_LAND.sendError((CommandSender)player, new Object[0]);
                FlyManager.disableFly(player, kp);
            } else {
                int task = new BukkitRunnable(){
                    int counter;
                    {
                        this.counter = warning;
                    }

                    public void run() {
                        if (this.counter == 0) {
                            KingdomsLang.FLY_OUT_OF_LAND.sendError((CommandSender)player, new Object[0]);
                            WARNINGS_LAND.remove(player.getEntityId());
                            FlyManager.disableFlight(kp, player);
                            this.cancel();
                            return;
                        }
                        if (FlyManager.canFlyInLand(player, kp, Land.getLand(player.getLocation()))) {
                            KingdomsLang.FLY_WARNINGS_OUT_OF_LAND_SAFE.sendMessage((CommandSender)player, "counter", this.counter);
                            WARNINGS_LAND.remove(player.getEntityId());
                            this.cancel();
                        } else {
                            KingdomsLang.FLY_WARNINGS_OUT_OF_LAND_WARN.sendError((CommandSender)player, "counter", this.counter);
                            --this.counter;
                        }
                    }
                }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 20L).getTaskId();
                WARNINGS_LAND.put(player.getEntityId(), task);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlyDamage(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (PvPManager.getDamager(event.getDamager()) == null) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!player.getAllowFlight()) {
            return;
        }
        if (KingdomsPluginPermission.FLIGHT_DAMAGE.hasPermission((CommandSender)player)) {
            return;
        }
        if (!KingdomsConfig.KINGDOM_FLY_DISABLE_ON_DAMAGE.getBoolean()) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin() || !kp.isFlying()) {
            return;
        }
        FlyManager.disableFly(player, kp);
        KingdomsLang.FLY_DAMAGE.sendError((CommandSender)player, new Object[0]);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        PREVENT_FALL_DAMAGE.remove(event.getPlayer().getEntityId());
        FlyManager.cancelTasks(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTeleport(PlayerTeleportEvent event) {
        PREVENT_FALL_DAMAGE.remove(event.getPlayer().getEntityId());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onUnclaim(UnclaimLandEvent event) {
        for (SimpleChunkLocation land : event.getLandLocations()) {
            Chunk chunk = land.toChunk();
            for (Entity entity : chunk.getEntities()) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
                FlyManager.flightInUnclaimed(kp);
            }
        }
    }

    static void flightInUnclaimed(KingdomPlayer kp) {
        Player player;
        if (kp.isFlying() && !kp.isAdmin() && (player = kp.getPlayer()) != null && !KingdomsPluginPermission.FLIGHT_LANDS.hasPermission((CommandSender)player)) {
            FlyManager.disableFly(player, kp);
            FlyManager.cancelTasks(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void duringFlyKingdomLeaveEvent(KingdomLeaveEvent event) {
        KingdomPlayer kp = event.getPlayer();
        FlyManager.flightInUnclaimed(kp);
    }

    static {
        int range = KingdomsConfig.KINGDOM_FLY_NEARBY_UNFRIENDLY_RANGE.getInt();
        Bukkit.getScheduler().runTaskTimer((Plugin)Kingdoms.get(), () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
                if (kp.hasKingdom() && kp.isFlying() && !kp.hasPermission(StandardKingdomPermission.FLY)) {
                    StandardKingdomPermission.FLY.sendDeniedMessage(player);
                    FlyManager.disableFly(player, kp);
                    continue;
                }
                FlyManager.isNearUnfriendly(player, range, true);
            }
        }, 1200L, 100L);
        if (KingdomsConfig.KINGDOM_FLY_CHARGES_ENABLED.getBoolean()) {
            long chargesTicks = (long)KingdomsConfig.KINGDOM_FLY_CHARGES_EVERY_SECONDS.getInt() * 20L;
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Kingdoms.get(), () -> {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    FlyManager.handleCharges(player);
                }
            }, 1200L, chargesTicks);
        }
    }
}

