/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.bukkit.plugin.Plugin;
import org.kingdoms.addons.AddonRegistry;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.network.Metrics;

public final class MetricsLoader {
    public static void init(final Kingdoms plugin) {
        Metrics metrics = new Metrics((Plugin)plugin, 7903);
        metrics.addCustomChart(new Metrics.SingleLineChart("turret_limit", new Callable<Integer>(){

            @Override
            public Integer call() {
                return KingdomsConfig.Turrets.LIMIT.getManager().getInt();
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("nations", new Callable<Integer>(){

            @Override
            public Integer call() {
                return plugin.getDataCenter().getNationManager().size();
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("kingdoms", new Callable<Integer>(){

            @Override
            public Integer call() {
                return plugin.getDataCenter().getKingdomManager().size();
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("lands", new Callable<Integer>(){

            @Override
            public Integer call() {
                return plugin.getDataCenter().getLandManager().size();
            }
        }));
        metrics.addCustomChart(new Metrics.DrilldownPie("addons", () -> {
            HashMap map = new HashMap(1);
            AddonRegistry.getAddons().keySet().forEach(x -> {
                HashMap<String, Integer> addons = new HashMap<String, Integer>();
                addons.put("dummy", 1);
                map.put(x, addons);
            });
            return map;
        }));
        metrics.addCustomChart(new Metrics.DrilldownPie("language_packs", () -> {
            HashMap map = new HashMap(1);
            Arrays.stream(SupportedLanguage.VALUES).filter(x -> x != SupportedLanguage.EN).filter(SupportedLanguage::isInstalled).forEach(x -> {
                HashMap<String, Integer> langs = new HashMap<String, Integer>();
                langs.put("dummy", 1);
                map.put(x.getNativeName(), langs);
            });
            return map;
        }));
    }
}

