/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.managers.abstraction.CustomResourcePointDescription;
import org.kingdoms.utils.cache.LazySupplier;
import org.kingdoms.utils.nbt.ItemNBT;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;

public final class ResourcePointManager {
    private static final String RESOURCE_POINTS = "ResourcePoints";
    private static CustomResourcePointDescription[] customResourcePointDescriptions;

    public static void loadSettings() {
        YamlConfigAccessor section = KingdomsConfig.ResourcePoints.ADVANCED.getManager().noDefault().getSection();
        if (section == null) {
            customResourcePointDescriptions = new CustomResourcePointDescription[0];
            KLogger.error("'advanced' section of resource-points.yml is not found.");
            return;
        }
        Set<String> keys = section.getKeys();
        customResourcePointDescriptions = new CustomResourcePointDescription[keys.size()];
        int i = 0;
        for (String key : keys) {
            YamlConfigAccessor customSection = section.gotoSection(key);
            ResourcePointManager.customResourcePointDescriptions[i++] = new CustomResourcePointDescription(key, customSection.getSection());
        }
    }

    public static CustomResourcePointDescription[] getCustomResourcePointDescriptions() {
        return customResourcePointDescriptions;
    }

    public static String getResourcePointsNBTTag() {
        return RESOURCE_POINTS;
    }

    private static Long getCustomWorth(ItemStack item, ItemMeta meta, NBTWrappers.NBTTagCompound nbt) {
        for (CustomResourcePointDescription description : customResourcePointDescriptions) {
            if (!description.matches(item, meta, LazySupplier.of(() -> nbt))) continue;
            return (long)description.getWorth();
        }
        return null;
    }

    public static ItemStack injectWorth(@NonNull ItemStack item, double resourcePoints) {
        NBTWrappers.NBTTagCompound nbt = ItemNBT.getTag(item);
        NBTWrappers.NBTTagCompound kingdoms = nbt.getCompound("Kingdoms");
        if (kingdoms == null) {
            kingdoms = new NBTWrappers.NBTTagCompound();
            nbt.set("Kingdoms", kingdoms);
        }
        kingdoms.set(RESOURCE_POINTS, NBTType.DOUBLE, resourcePoints);
        return ItemNBT.setTag(item, nbt);
    }

    public static @Nullable Double getInjectedWorth(@NonNull ItemStack item) {
        return ResourcePointManager.getInjectedWorth(ItemNBT.getTag(item));
    }

    public static Double getInjectedWorth(NBTWrappers.NBTTagCompound nbt) {
        NBTWrappers.NBTTagCompound kingdoms = nbt.getCompound("Kingdoms");
        return kingdoms == null ? null : kingdoms.get(RESOURCE_POINTS, NBTType.DOUBLE);
    }

    public static Double removeInjectedWorth(@NonNull ItemStack item) {
        NBTWrappers.NBTTagCompound nbt = ItemNBT.getTag(item);
        NBTWrappers.NBTTagCompound kingdoms = nbt.getCompound("Kingdoms");
        if (kingdoms == null) {
            return null;
        }
        NBTWrappers.NBTTagDouble worth = (NBTWrappers.NBTTagDouble)kingdoms.remove(RESOURCE_POINTS);
        return (Double)worth.getValue();
    }

    public static Pair<ItemStack, Double> buildItem(String name) {
        YamlConfigAccessor section = Objects.requireNonNull(KingdomsConfig.ResourcePoints.CUSTOM_ITEMS.getManager().getSection(), "Cannot find the custom items section in the config");
        if ((section = section.noDefault().gotoSection(name)) == null) {
            return null;
        }
        ItemStack item = XItemStack.deserialize(section.toBukkitConfigurationSection(), MessageHandler::colorize);
        double rp = section.getDouble("resource-points");
        item = ResourcePointManager.injectWorth(item, rp);
        return Pair.of(item, rp);
    }

    public static long getWorth(ItemStack item) {
        return ResourcePointManager.getWorth(item, item.getAmount());
    }

    public static long getWorth(ItemStack item, int amount) {
        Pair<Long, List<ItemStack>> result = ResourcePointManager.convertToResourcePoints(Collections.singleton(item), null);
        return result.getKey() * (long)amount;
    }

    public static @NonNull Pair<Long, List<ItemStack>> convertToResourcePoints(@NonNull Collection<ItemStack> donations, @Nullable BiFunction<ItemStack, List<ItemStack>, Long> function) {
        List<String> list2 = KingdomsConfig.ResourcePoints.GENERAL_FILTERS_MATERIAL_LIST.getManager().getStringList();
        boolean blacklist = KingdomsConfig.ResourcePoints.GENERAL_FILTERS_MATERIAL_BLACKLIST.getManager().getBoolean();
        KeyedYamlConfigAccessor loreFilterOpt = KingdomsConfig.ResourcePoints.GENERAL_FILTERS_LORE.getManager();
        KeyedYamlConfigAccessor enchantFilterOpt = KingdomsConfig.ResourcePoints.GENERAL_FILTERS_ENCHANTED.getManager();
        List<String> loreFilter = loreFilterOpt.isSet() ? loreFilterOpt.getStringList() : null;
        Boolean enchantFilter = enchantFilterOpt.isSet() ? Boolean.valueOf(enchantFilterOpt.getBoolean()) : null;
        int forEach = KingdomsConfig.ResourcePoints.FOR_EACH.getManager().getInt();
        int giveAmt = KingdomsConfig.ResourcePoints.GIVE.getManager().getInt();
        boolean notZero = forEach != 0 && giveAmt != 0;
        YamlConfigAccessor customMaterials = KingdomsConfig.ResourcePoints.CUSTOM.getManager().getSection().noDefault();
        ArrayList<ItemStack> leftOvers = new ArrayList<ItemStack>();
        long total = 0L;
        for (ItemStack item : donations) {
            Long amount;
            if (function != null && (amount = function.apply(item, leftOvers)) != null) {
                total += amount.longValue();
                continue;
            }
            int amount2 = item.getAmount();
            NBTWrappers.NBTTagCompound nbt = ItemNBT.getTag(item);
            Double injected = ResourcePointManager.getInjectedWorth(nbt);
            if (injected != null) {
                total = (long)((double)total + injected * (double)amount2);
                continue;
            }
            ItemMeta meta = item.getItemMeta();
            Long advancedRp = ResourcePointManager.getCustomWorth(item, meta, nbt);
            if (advancedRp != null) {
                total += advancedRp * (long)amount2;
                continue;
            }
            boolean hasLore = meta.hasLore();
            if (hasLore && loreFilter != null && !meta.getLore().equals(loreFilter)) {
                leftOvers.add(item);
                continue;
            }
            boolean hasEnchants = meta.hasEnchants();
            if (hasEnchants && enchantFilter != null && hasEnchants != enchantFilter) {
                leftOvers.add(item);
                continue;
            }
            XMaterial material = XMaterial.matchXMaterial(item);
            int special = customMaterials.getInt(material.name());
            if (special != 0) {
                total += (long)special * (long)amount2;
                continue;
            }
            if (!notZero) continue;
            if (blacklist == material.isOneOf(list2)) {
                leftOvers.add(item);
                continue;
            }
            total += (long)(amount2 / forEach) * (long)giveAmt;
            int remainder = amount2 % forEach;
            if (remainder == 0) continue;
            item.setAmount(remainder);
            leftOvers.add(item);
        }
        return Pair.of(total, leftOvers);
    }

    static {
        ResourcePointManager.loadSettings();
    }
}

