/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.abstraction;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.data.StartupCache;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.daily.DailyChecksManager;
import org.kingdoms.managers.daily.ElectionsManager;
import org.kingdoms.managers.daily.TimeZoneHandler;
import org.kingdoms.managers.logger.KingdomsLogger;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.time.TimeUtils;

public abstract class ProlongedTask {
    private static final long ONE_DAY_TiCKS = TimeUnit.DAYS.toSeconds(1L) * 20L;
    private final Duration interval;
    private final LocalTime fixedPerformTime;
    private final String taskName;
    private final String[] lastPerformConfigPath;
    private final long[] countdowns;
    private boolean skip;
    private BukkitTask task;
    private BukkitTask reminder;

    protected ProlongedTask(Duration interval, LocalTime fixedPerformTime, String taskName, String[] lastPerformConfigPath, List<String> countdowns) {
        this.interval = interval;
        this.taskName = taskName;
        this.fixedPerformTime = fixedPerformTime;
        this.lastPerformConfigPath = lastPerformConfigPath;
        this.countdowns = countdowns == null ? null : ProlongedTask.parseCountdowns(countdowns);
    }

    public static void init() {
        StartupCache.whenLoaded(x -> {
            DailyChecksManager.getInstance().load();
            ElectionsManager.getInstance().load();
        });
    }

    public void runAndRenew() {
        KingdomsLogger.getMain().log("Force running " + this.taskName + " interval checks...");
        this.task.cancel();
        if (this.reminder != null) {
            this.reminder.cancel();
        }
        this.runAndSet();
        this.load();
        KingdomsLogger.getMain().log("Done");
    }

    private static long[] parseCountdowns(List<String> countdown) {
        return countdown.stream().map(TimeUtils::parseTime).filter(Objects::nonNull).mapToLong(x -> x).toArray();
    }

    public abstract void run();

    public abstract void remind(String var1);

    public boolean isSkipping() {
        return this.skip;
    }

    public void setSkipped(boolean skip) {
        this.skip = skip;
    }

    public long untilNextChecks(ChronoUnit unit) {
        LocalDateTime now = LocalDateTime.now(TimeZoneHandler.SERVER_TIME_ZONE);
        LocalDateTime lastPerform = this.lastPerform();
        if (this.fixedPerformTime == null) {
            if (lastPerform == null) {
                return now.until(now.plus(this.interval), unit);
            }
            if (lastPerform.plus(this.interval).isBefore(now)) {
                return 0L;
            }
            return now.until(lastPerform.plus(this.interval), unit);
        }
        if (lastPerform == null) {
            return now.until(LocalDateTime.of(now.toLocalDate(), this.fixedPerformTime), unit);
        }
        LocalDateTime runAt = LocalDateTime.of(lastPerform.plus(this.interval).toLocalDate(), this.fixedPerformTime);
        if (now.isBefore(runAt)) {
            return now.until(runAt, unit);
        }
        return TimeZoneHandler.convert(unit, TimeUnit.DAYS, 1L) - this.fixedPerformTime.until(now, unit);
    }

    public LocalDateTime lastPerform() {
        long millis = ConfigManager.getGlobals().getLong(this.lastPerformConfigPath);
        if (millis <= 0L) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), TimeZoneHandler.SERVER_TIME_ZONE);
    }

    public long getIntervalTicks() {
        return this.fixedPerformTime == null ? this.interval.toMillis() : ONE_DAY_TiCKS;
    }

    public void runAndSet() {
        ConfigManager.getGlobals().set(this.lastPerformConfigPath, (Object)System.currentTimeMillis());
        ConfigManager.getGlobalsAdapter().saveConfig();
        this.run();
    }

    public void load() {
        long next = this.untilNextChecks(ChronoUnit.MILLIS);
        this.task = new BukkitRunnable(){

            public void run() {
                if (!ProlongedTask.this.isSkipping()) {
                    ProlongedTask.this.runAndSet();
                } else {
                    ProlongedTask.this.skip = false;
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), TimeUtils.millisToTicks(next), this.getIntervalTicks());
        this.reminder(Kingdoms.get());
    }

    private void reminder(final Kingdoms plugin) {
        if (this.countdowns == null || this.skip) {
            return;
        }
        long nextCheck = this.untilNextChecks(ChronoUnit.MILLIS);
        Long millisUntilNextCooldown = null;
        for (long countdown : this.countdowns) {
            if (countdown >= nextCheck) continue;
            millisUntilNextCooldown = nextCheck - countdown;
            break;
        }
        if (millisUntilNextCooldown == null) {
            return;
        }
        KingdomsLogger.getMain().log("Triggered reminder. Next: " + TimeFormatter.ofRaw(millisUntilNextCooldown));
        this.reminder = new BukkitRunnable(){

            public void run() {
                ProlongedTask.this.reminder(plugin);
                ProlongedTask.this.remind(TimeFormatter.ofRaw(ProlongedTask.this.untilNextChecks(ChronoUnit.MILLIS)));
            }
        }.runTaskLaterAsynchronously((Plugin)plugin, TimeUtils.toTicks(Duration.ofMillis(millisUntilNextCooldown).plusMillis(100L)));
    }
}

