/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chat;

import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.abstraction.MoveSensitiveAction;
import org.kingdoms.managers.chat.ChatInputHandler;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.internal.integer.IntHashMap;

public final class ChatInputManager
implements Listener {
    private static final IntHashMap<ChatInputHandler<?>> CONVERSATIONS = new IntHashMap();

    public static boolean startConversation(Player player, ChatInputHandler<?> handler) {
        Objects.requireNonNull(player, "Player conversation cannot be null");
        Objects.requireNonNull(handler, "Conversation handler cannot be null");
        CONVERSATIONS.put(player.getEntityId(), handler);
        return true;
    }

    public static void endAllConversations() {
        CONVERSATIONS.clear();
    }

    public static boolean isConversing(Player player) {
        return CONVERSATIONS.containsKey(player.getEntityId());
    }

    public static boolean endConversation(Player player) {
        return CONVERSATIONS.remove(player.getEntityId()) != null;
    }

    public static <V> CompletableFuture<V> awaitInput(Player player, Function<String, V> supplier) {
        ChatInputHandler handler = new ChatInputHandler();
        CompletableFuture completableFuture = new CompletableFuture();
        handler.onInput((AsyncPlayerChatEvent event) -> {
            String msg = event.getMessage();
            Object result = supplier.apply(msg);
            if (result == null) {
                return false;
            }
            completableFuture.complete(result);
            return true;
        });
        handler.onCancel(() -> completableFuture.complete(null));
        ChatInputManager.startConversation(player, handler);
        player.closeInventory();
        return completableFuture;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onInput(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        ChatInputHandler<?> handler = CONVERSATIONS.get(player.getEntityId());
        if (handler == null) {
            return;
        }
        event.setCancelled(true);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        String translatedCancel = KingdomsLang.CHAT_INPUT_CANCEL.parse(player, new Object[0]);
        Locale locale = kp.getLanguage().getLocale();
        if (event.getMessage().toLowerCase(locale).equals(translatedCancel.toLowerCase(locale))) {
            ChatInputManager.endConversation(player);
            handler.onCancel.run();
            return;
        }
        if (!handler.sync || Bukkit.isPrimaryThread()) {
            if (handler.onInput.apply(event).booleanValue()) {
                ChatInputManager.endConversation(player);
            }
        } else {
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
                if (handler.onInput.apply(event).booleanValue()) {
                    ChatInputManager.endConversation(player);
                }
            });
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onCancel(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String cmd = event.getMessage().substring(1);
        if (!cmd.equalsIgnoreCase("cancel")) {
            return;
        }
        ChatInputHandler<?> handler = CONVERSATIONS.get(player.getEntityId());
        if (handler == null) {
            return;
        }
        event.setCancelled(true);
        ChatInputManager.endConversation(player);
        handler.onCancel.run();
    }

    public static InteractiveGUI createAnvilInputs(Player player, Messenger question) {
        MessageBuilder settings = new MessageBuilder().parse("question", question.getMessageObject(KingdomPlayer.getKingdomPlayer((OfflinePlayer)player).getLanguage()));
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.INPUT, settings);
        gui.option("done").onNormalClicks(() -> {}).done();
        gui.option("cancel").onNormalClicks(() -> {}).done();
        gui.open();
        return gui;
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        ChatInputManager.endConversation(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        int id = event.getEntity().getEntityId();
        MoveSensitiveAction task = CONVERSATIONS.get(id);
        if (task != null && task.onDamage != null && task.onDamage.apply(event).booleanValue()) {
            CONVERSATIONS.remove(id);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onMove(PlayerMoveEvent event) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            if (!LocationUtils.hasMoved(event.getFrom(), event.getTo())) {
                return;
            }
            int id = event.getPlayer().getEntityId();
            MoveSensitiveAction task = CONVERSATIONS.get(id);
            if (task != null && task.onMove != null && task.onMove.apply(event).booleanValue()) {
                CONVERSATIONS.remove(id);
            }
        });
    }
}

