/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chat;

import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.data.Pair;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.PlaceholderTranslationContext;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.chat.ChatTagManager;
import org.kingdoms.managers.chat.KingdomChatChannelListener;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.ConditionProcessor;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.debugging.KingdomsDebug;

public final class KingdomsChatProcessor {
    private static final String PARSE_AS_PLACEHOLDER = "{KINGDOMS}";
    private final Player player;
    private final KingdomPlayer kp;
    private final KingdomsChatChannel chan;
    private final KLogger logger = new KLogger(KingdomsDebug.CHAT);
    private final AsyncPlayerChatEvent event;
    private final MessageObject adminFormat;
    private boolean bypassRanged;
    private boolean parseAsPlaceholder = false;
    private final MessageBuilder settings = new MessageBuilder();

    public KingdomsChatProcessor(AsyncPlayerChatEvent event) {
        this.event = event;
        this.player = event.getPlayer();
        this.kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
        this.chan = this.kp.getChatChannel();
        boolean colorize = KingdomsPluginPermission.CHAT_COLORS.hasPermission((CommandSender)this.player, true);
        PlaceholderTranslationContext msgCtx = new PlaceholderTranslationContext(event.getMessage(), new MessageCompilerSettings(false, true, colorize, true, false, null).withTokenHandler(ChatTagManager.INSTANCE));
        this.settings.viewer(this.kp).withContext(this.player).raw("message", msgCtx).parse("channel", this.chan.getColor() + this.chan.getName().buildPlain(MessageBuilder.DEFAULT)).raw("channel_id", this.chan.getId());
        String adminFormatString = this.chan.getAdminFormat().stream().filter(x -> x.getKey() == null || ConditionProcessor.process((ConditionalCompiler.LogicalOperand)x.getKey(), this.settings)).map(Pair::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException("Missing else option for admin formats: " + this.chan.getId()));
        this.adminFormat = MessageCompiler.compile(adminFormatString);
    }

    public void process() {
        String format;
        String prefix;
        this.logger.log(() -> "Player " + this.player.getName() + " sent a message to '" + this.chan.getId() + "' channel: " + this.event.getMessage());
        this.logger.log(() -> "Chat recipients: " + this.event.getRecipients().stream().map(Player::getName).collect(Collectors.toList()));
        if (this.kp.getMutedChannels().contains(this.chan.getDataId())) {
            KingdomsLang.COMMAND_CHAT_MUTED_CHANNEL.sendError((CommandSender)this.player, this.settings);
            this.logger.log("That channel was muted for the player.");
            this.event.setCancelled(true);
            return;
        }
        boolean isGlobal = this.chan.isGlobal();
        if (isGlobal && !KingdomsConfig.Chat.GLOBAL_CHANNEL_FORMAT.getManager().getBoolean()) {
            return;
        }
        if (KingdomsPluginPermission.CHAT_BYPASS_RANGED.hasPermission((CommandSender)this.player) && !Strings.isNullOrEmpty((String)(prefix = this.chan.getBypassPrefix())) && this.event.getMessage().startsWith(prefix)) {
            this.event.setMessage(this.event.getMessage().substring(prefix.length()));
            this.settings.raw("distance", 0);
            this.logger.property((Object)"Range Bypassed", true);
            this.bypassRanged = true;
        }
        if (isGlobal) {
            format = KingdomChatChannelListener.escapeStringFormatter(this.adminFormat.buildPlain(this.settings));
            if (KingdomsConfig.Chat.GLOBAL_CHANNEL_PARSE_AS_PLACEHOLDER.getManager().getBoolean()) {
                this.parseAsPlaceholder = true;
                KingdomChatChannelListener.setFormat(this.event, MessageHandler.replace(this.event.getFormat(), PARSE_AS_PLACEHOLDER, format));
                return;
            }
            KingdomChatChannelListener.setFormat(this.event, format);
            this.logger.log(() -> "Parsing the message as placeholder with format: " + this.event.getFormat());
        }
        if (KingdomsConfig.Chat.CANCEL.getManager().getBoolean()) {
            this.event.setCancelled(true);
            format = this.adminFormat.buildPlain(this.settings.ignoreColors());
            if (isGlobal) {
                ServiceHandler.sendGlobalMessage(this.player, format);
            } else {
                ServiceHandler.logPrivateMessage(this.player, format);
            }
            this.settings.dontIgnoreColors();
            this.adminFormat.getSimpleProvider().send((CommandSender)Bukkit.getConsoleSender(), this.settings);
        }
        this.logger.property((Object)"Cancelled", this.event.isCancelled());
        if (!KingdomsConfig.Chat.RECIPIENTS_RESPECT_OTHERS.getManager().getBoolean()) {
            this.event.getRecipients().clear();
            this.event.getRecipients().addAll(Bukkit.getOnlinePlayers());
        }
        Kingdom kingdom = this.kp.getKingdom();
        Iterator iter = this.event.getRecipients().iterator();
        ConditionalCompiler.LogicalOperand condition = this.chan.getRecipientCondition();
        while (iter.hasNext()) {
            boolean send;
            Player recipient = (Player)iter.next();
            this.changeSettings(recipient);
            KingdomPlayer recipientKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)recipient);
            if (recipientKp.getMutedChannels().contains(this.chan.getDataId())) {
                iter.remove();
                this.logger.log("Recipient " + recipient.getName() + " has this channel muted.");
                continue;
            }
            boolean bl = send = condition == null || ConditionProcessor.process(condition, this.settings);
            if (send) {
                if (!this.event.isCancelled()) continue;
                MessageObject format2 = this.getFormatter(this.settings);
                format2.getSimpleProvider().send((CommandSender)recipient, this.settings);
                continue;
            }
            this.logger.log(() -> "Not sending to: " + recipient.getName() + ", rel=" + (Object)((Object)kingdom.getRelationWith(recipientKp.getKingdom())));
            iter.remove();
        }
        if (!this.parseAsPlaceholder && KingdomsConfig.Chat.RECIPIENTS_CLEAR_WHEN_DONE.getManager().getBoolean()) {
            this.event.getRecipients().clear();
        }
        this.logger.end();
    }

    private static double getDistance(Player one, Player two) {
        if (one.getWorld() != two.getWorld()) {
            return -1.0;
        }
        return LocationUtils.distanceSquared(one.getLocation(), two.getLocation());
    }

    private void changeSettings(Player other) {
        this.settings.other(other);
        if (this.bypassRanged) {
            return;
        }
        this.settings.raw("distance", KingdomsChatProcessor.getDistance(this.player, other));
    }

    public MessageObject getFormatter(MessageBuilder settings) {
        return this.chan.getFormats().get(settings);
    }
}

