/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chunkrestoration;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.block.data.BlockData;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.chunkrestoration.ChunkSnapshot;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.time.TimeUtils;

public final class ChunkSnapshotManager {
    private static final Set<SimpleChunkLocation> CHUNK_RESTORATION_QUEUE = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final Hashtable<SimpleChunkLocation, ChunkSnapshot> ACTIVE_RESTORING_CHUNKS = new Hashtable();
    private static final LinkedHashSet<SimpleChunkLocation> SNAPSHOT_GENERATOR_QUEUE = new LinkedHashSet();
    private static final Path DATA_FOLDER = KingdomsDataCenter.DATA_FOLDER.resolve("chunk-snapshots");
    private static final Queue<Runnable> SNAPSHOT_SAVE_QUEUE = new ConcurrentLinkedQueue<Runnable>();
    private static final BukkitTask QUERY_TASK = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Kingdoms.get(), () -> {
        while (!SNAPSHOT_SAVE_QUEUE.isEmpty()) {
            Runnable operation = SNAPSHOT_SAVE_QUEUE.poll();
            operation.run();
        }
    }, 100L, 5L);

    public static void init() {
    }

    public static void saveSnapshot(ChunkSnapshot snapshot) {
        Path path = ChunkSnapshotManager.getSnapshotZipPath(snapshot.getLocation());
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (ZipOutputStream output = new ZipOutputStream(Files.newOutputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);){
            output.putNextEntry(new ZipEntry(ChunkSnapshotManager.getSnapshotInternalFileName(snapshot.getLocation())));
            try (DataOutputStream fout = new DataOutputStream(output);){
                ChunkSnapshotManager.writeSnapshotData(fout, snapshot);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeSnapshotData(DataOutputStream fout, ChunkSnapshot snapshot) throws IOException {
        fout.writeByte(snapshot.getVersion());
        for (Map.Entry<SimpleLocation.WorldlessWrapper, BlockData> block : snapshot.getBlocks().entrySet()) {
            SimpleLocation.WorldlessWrapper loc = block.getKey();
            fout.writeByte(loc.getX());
            fout.writeShort(loc.getY());
            fout.writeByte(loc.getZ());
            fout.writeUTF(block.getValue().getAsString(true));
        }
    }

    public static void finalizeSnapshotRestoration(ChunkSnapshot snapshot) {
        KLogger.debug((DebugNS)KingdomsDebug.CHUNK$SNAPSHOT, () -> "Snapshot restoration completed for: " + snapshot);
        ChunkSnapshotManager.removeFromActiveRegeneration(snapshot);
        ChunkSnapshotManager.deleteSnapshot(snapshot);
        snapshot.getLocation().toChunk().removePluginChunkTicket((Plugin)Kingdoms.get());
    }

    public static void queueSnapshotGeneration(SimpleChunkLocation chunk) {
        SNAPSHOT_GENERATOR_QUEUE.add(chunk);
    }

    public static boolean hasPendingSnapshotGeneration() {
        return !SNAPSHOT_GENERATOR_QUEUE.isEmpty();
    }

    public static SimpleChunkLocation getNextPendingChunk() {
        Iterator iterator = SNAPSHOT_GENERATOR_QUEUE.iterator();
        SimpleChunkLocation next = (SimpleChunkLocation)iterator.next();
        iterator.remove();
        return next;
    }

    public static void queueRestoration(SimpleChunkLocation chunk) {
        CHUNK_RESTORATION_QUEUE.add(chunk);
    }

    public static boolean hasPendingRestorationQueue() {
        return !CHUNK_RESTORATION_QUEUE.isEmpty();
    }

    public static boolean hasActiveRestoration() {
        return !ACTIVE_RESTORING_CHUNKS.isEmpty();
    }

    public static boolean isBeingRestoredActively(SimpleChunkLocation chunk) {
        return ACTIVE_RESTORING_CHUNKS.containsKey(chunk);
    }

    public static void removeFromActiveRegeneration(ChunkSnapshot snapshot) {
        ACTIVE_RESTORING_CHUNKS.remove(snapshot.getLocation());
    }

    public static void restoreActively(ChunkSnapshot snapshot) {
        ACTIVE_RESTORING_CHUNKS.put(snapshot.getLocation(), snapshot);
    }

    public static void queueSaveSnapshot(ChunkSnapshot snapshot) {
        if (ChunkSnapshotManager.loadSnapshot(snapshot.getLocation()) == null) {
            SNAPSHOT_SAVE_QUEUE.add(() -> ChunkSnapshotManager.saveSnapshot(snapshot));
        }
    }

    public static ChunkSnapshot getSnapshot(SimpleChunkLocation chunk) {
        return ChunkSnapshotManager.loadSnapshot(chunk);
    }

    public static void finishTasks() {
        QUERY_TASK.cancel();
        while (!SNAPSHOT_SAVE_QUEUE.isEmpty()) {
            SNAPSHOT_SAVE_QUEUE.poll().run();
        }
    }

    public static ChunkSnapshot loadSnapshot(SimpleChunkLocation chunk) {
        ChunkSnapshot chunkSnapshot;
        Path path = ChunkSnapshotManager.getSnapshotZipPath(chunk);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        ZipFile zipFile = new ZipFile(path.toFile());
        try {
            InputStream stream = zipFile.getInputStream(zipFile.entries().nextElement());
            chunkSnapshot = ChunkSnapshotManager.loadSnapshotFromStream(chunk, stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        zipFile.close();
        return chunkSnapshot;
    }

    private static ChunkSnapshot loadSnapshotFromStream(SimpleChunkLocation chunk, InputStream stream) {
        byte version = 1;
        HashMap<SimpleLocation.WorldlessWrapper, BlockData> blocks = new HashMap<SimpleLocation.WorldlessWrapper, BlockData>(1000);
        try {
            DataInputStream fin = new DataInputStream(stream);
            try {
                version = fin.readByte();
                while (true) {
                    byte x = fin.readByte();
                    short y = fin.readShort();
                    byte z = fin.readByte();
                    BlockData blockData = Bukkit.getServer().createBlockData(fin.readUTF());
                    blocks.put(new SimpleLocation.WorldlessWrapper(x, y, z), blockData);
                }
            }
            catch (Throwable throwable) {
                try {
                    fin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException fin) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ChunkSnapshot(chunk, version, blocks);
    }

    public static void deleteSnapshot(ChunkSnapshot snapshot) {
        try {
            Files.delete(ChunkSnapshotManager.getSnapshotZipPath(snapshot.getLocation()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean hasSnapshot(SimpleChunkLocation chunk) {
        return Files.exists(ChunkSnapshotManager.getSnapshotZipPath(chunk), new LinkOption[0]);
    }

    private static Path getSnapshotZipPath(SimpleChunkLocation chunk) {
        return DATA_FOLDER.resolve(chunk.getWorld()).resolve(chunk.getX() + ", " + chunk.getZ() + ".zip");
    }

    private static String getSnapshotInternalFileName(SimpleChunkLocation chunk) {
        return chunk.getX() + ", " + chunk.getZ() + ".chunk-snapshot";
    }

    static {
        Bukkit.getScheduler().runTaskTimer((Plugin)Kingdoms.get(), () -> {
            if (ChunkSnapshotManager.hasActiveRestoration()) {
                for (ChunkSnapshot snapshots : ACTIVE_RESTORING_CHUNKS.values()) {
                    if (!snapshots.restoreNextBlock()) continue;
                    ChunkSnapshotManager.finalizeSnapshotRestoration(snapshots);
                }
            }
        }, 100L, (long)KingdomsConfig.Claims.RESTORATION_BLOCK_RESTORATION_RATE.getManager().getInt());
        Bukkit.getScheduler().runTaskTimer((Plugin)Kingdoms.get(), () -> {
            if (ChunkSnapshotManager.hasPendingSnapshotGeneration()) {
                SimpleChunkLocation next = ChunkSnapshotManager.getNextPendingChunk();
                ChunkSnapshot snapshot = ChunkSnapshot.generateFor(next);
                ChunkSnapshotManager.queueSaveSnapshot(snapshot);
                if (!ChunkSnapshotManager.hasPendingSnapshotGeneration()) {
                    KLogger.debug((DebugNS)KingdomsDebug.CHUNK$SNAPSHOT, "All chunk snapshots are completed.");
                }
            }
        }, 100L, 20L);
        int maxActiveChunks = KingdomsConfig.Claims.RESTORATION_MAX_ACTIVE_RESTORING_CHUNKS.getManager().getInt();
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Kingdoms.get(), () -> {
            if (ACTIVE_RESTORING_CHUNKS.size() < maxActiveChunks && ChunkSnapshotManager.hasPendingRestorationQueue()) {
                Iterator<SimpleChunkLocation> iterator = CHUNK_RESTORATION_QUEUE.iterator();
                while (iterator.hasNext()) {
                    SimpleChunkLocation chunk = iterator.next();
                    if (ChunkSnapshotManager.isBeingRestoredActively(chunk)) continue;
                    ChunkSnapshot snapshot = ChunkSnapshotManager.getSnapshot(chunk);
                    if (snapshot != null) {
                        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> chunk.toChunk().addPluginChunkTicket((Plugin)Kingdoms.get()));
                        ChunkSnapshotManager.restoreActively(snapshot);
                    }
                    iterator.remove();
                }
            }
        }, 100L, TimeUtils.toTicks(Duration.ofMinutes(1L)));
    }
}

