/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.daily;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.string.StringUtils;

public final class TopRewardsManager {
    public static void rewardTopKingdoms() {
        int limit = KingdomsConfig.TOP_KINGDOMS_REWARDS_TOP.getInt();
        if (limit <= 0) {
            return;
        }
        String rp = KingdomsConfig.TOP_KINGDOMS_REWARDS_RESOURCE_POINTS.getString();
        String bank = KingdomsConfig.TOP_KINGDOMS_REWARDS_BANK.getString();
        List<Kingdom> topKingdoms = KingdomsDataCenter.get().getKingdomManager().getTopKingdoms(0, limit);
        int ranking = 0;
        for (Kingdom kingdom : topKingdoms) {
            long rewardRp = (long)MathUtils.eval(rp, kingdom, "rank", ++ranking);
            double bankReward = MathUtils.eval(bank, kingdom, "rank", ranking);
            kingdom.addResourcePoints(rewardRp);
            kingdom.addBank(bankReward);
            Object[] edits = new Object[]{"rank", ranking, "money", StringUtils.toFancyNumber(bankReward), "rp", StringUtils.toFancyNumber(rewardRp)};
            for (Player member : kingdom.getOnlineMembers()) {
                KingdomsLang.TOP_REWARDS_KINGDOM.sendMessage((CommandSender)member, edits);
            }
        }
    }

    public static void rewardTopNations() {
        int limit = KingdomsConfig.TOP_NATIONS_REWARDS_TOP.getInt();
        if (limit <= 0) {
            return;
        }
        String rp = KingdomsConfig.TOP_NATIONS_REWARDS_RESOURCE_POINTS.getString();
        String bank = KingdomsConfig.TOP_NATIONS_REWARDS_BANK.getString();
        List<Nation> topNations = KingdomsDataCenter.get().getNationManager().getTopNations(0, limit);
        int ranking = 0;
        for (Nation nation : topNations) {
            long rewardRp = (long)MathUtils.eval(rp, nation, "rank", ++ranking);
            double bankReward = MathUtils.eval(bank, nation, "rank", ranking);
            nation.addResourcePoints(rewardRp);
            nation.addBank(bankReward);
            Object[] edits = new Object[]{"rank", ranking, "money", StringUtils.toFancyNumber(bankReward), "rp", StringUtils.toFancyNumber(rewardRp)};
            for (Player member : nation.getOnlineMembers()) {
                KingdomsLang.TOP_REWARDS_NATION.sendMessage((CommandSender)member, edits);
            }
        }
    }
}

