/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.entity;

import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomEntity;

public final class KingdomEntityManager
implements Listener {
    private static final ParticleDisplay DEATH_DISPLAY = ParticleDisplay.simple(null, Particle.CLOUD).offset(1.0, 1.0, 1.0).withCount(50);

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onKingdomMobDeath(EntityDeathEvent event) {
        if (KingdomEntityRegistry.isKingdomEntity(event.getEntity())) {
            event.getDrops().clear();
            event.setDroppedExp(0);
            DEATH_DISPLAY.spawn(event.getEntity().getLocation());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomSlimeSplit(SlimeSplitEvent event) {
        KingdomEntityManager.checkEntity(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPortalTeleport(EntityPortalEvent event) {
        KingdomEntityManager.checkEntity(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPickupItem(EntityPickupItemEvent event) {
        KingdomEntityManager.checkEntity(event);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomSlimeSplit(EntityTameEvent event) {
        KingdomEntityManager.checkEntity(event);
    }

    static <T extends EntityEvent> void checkEntity(T event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (KingdomEntityRegistry.isKingdomEntity((LivingEntity)entity)) {
            ((Cancellable)event).setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTarget(EntityTargetEvent event) {
        Entity rightTarget;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity guard = (LivingEntity)event.getEntity();
        KingdomEntity kingdomEntity = KingdomEntityRegistry.getKingdomEntity((Entity)guard);
        if (kingdomEntity == null) {
            return;
        }
        Entity target = event.getTarget();
        if (target != (rightTarget = kingdomEntity.getTarget())) {
            event.setTarget(rightTarget);
        }
    }
}

