/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.entity;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.kingdoms.managers.entity.types.KingdomEntity;

public final class KingdomEntityRegistry {
    private static final Map<Entity, KingdomEntity> KINGDOM_MOBS = new WeakHashMap<Entity, KingdomEntity>();

    public static KingdomEntity addMob(KingdomEntity entity) {
        return KINGDOM_MOBS.put(entity.getEntity(), entity);
    }

    public static KingdomEntity removeMob(LivingEntity entity) {
        return KINGDOM_MOBS.remove(entity);
    }

    public static Map<Entity, KingdomEntity> getKingdomMobs() {
        return Collections.unmodifiableMap(KINGDOM_MOBS);
    }

    public static boolean isKingdomEntity(LivingEntity entity) {
        return entity != null && KINGDOM_MOBS.containsKey(entity);
    }

    public static KingdomEntity getKingdomEntity(Entity entity) {
        return KINGDOM_MOBS.get(entity);
    }

    public static void removeAllKingdomMobs() {
        for (Entity entity : KINGDOM_MOBS.keySet()) {
            entity.remove();
        }
        KINGDOM_MOBS.clear();
    }
}

