/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.data.managers.LandManager;
import org.kingdoms.events.lands.AsyncBatchLandLoadEvent;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.events.lands.LandUnloadEvent;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;

public final class ChunkManager
implements Listener {
    private static void handleLandChange(PlayerMoveEvent event, PlayerTeleportEvent.TeleportCause cause) {
        SimpleChunkLocation fromChunk = SimpleChunkLocation.of(event.getFrom());
        SimpleChunkLocation toChunk = SimpleChunkLocation.of(event.getTo());
        if (fromChunk.getX() != toChunk.getX() || fromChunk.getZ() != toChunk.getZ()) {
            LandChangeEvent chunkChangeEvent = new LandChangeEvent(event, fromChunk, toChunk, cause);
            Bukkit.getPluginManager().callEvent((Event)chunkChangeEvent);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        LandManager.queryLand(SimpleChunkLocation.of(chunk));
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        SimpleChunkLocation loc = SimpleChunkLocation.of(chunk);
        if (!Kingdoms.get().getDataCenter().getLandManager().isLoaded(loc)) {
            return;
        }
        Land land = loc.getLand();
        if (land == null || !land.isClaimed()) {
            return;
        }
        LandUnloadEvent unloadEvent = new LandUnloadEvent(land);
        Bukkit.getPluginManager().callEvent((Event)unloadEvent);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onChunkChange(PlayerMoveEvent event) {
        ChunkManager.handleLandChange(event, null);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onTeleport(PlayerTeleportEvent event) {
        ChunkManager.handleLandChange((PlayerMoveEvent)event, event.getCause());
    }

    static {
        Duration delay = Duration.ofSeconds(30L);
        Kingdoms.taskScheduler().asyncRepeating(delay, delay, () -> {
            LandManager landManager = Kingdoms.get().getDataCenter().getLandManager();
            HashMap<SimpleChunkLocation, List<Consumer<Land>>> cloned = new HashMap<SimpleChunkLocation, List<Consumer<Land>>>(LandManager.QUERIED_LANDS);
            LandManager.QUERIED_LANDS.clear();
            Collection<Land> loaded = landManager.load(cloned.keySet());
            for (Land land : loaded) {
                List consumers = (List)cloned.get(land.getLocation());
                for (Consumer consumer : consumers) {
                    consumer.accept(land);
                }
            }
            AsyncBatchLandLoadEvent loadEvent = new AsyncBatchLandLoadEvent(loaded);
            Bukkit.getPluginManager().callEvent((Event)loadEvent);
        });
        int queried = 0;
        for (World world : Bukkit.getWorlds()) {
            if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(world)) continue;
            for (Chunk chunk : world.getLoadedChunks()) {
                ++queried;
                LandManager.queryLand(SimpleChunkLocation.of(chunk));
            }
        }
        if (queried != 0) {
            KLogger.info("A total of " + queried + " loaded chunks has been queried.");
        }
    }
}

