/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.claiming;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.ConfigUtils;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.managers.land.claiming.UnclaimProcessor;

public final class AutoClaimManager
implements Listener {
    public static void autoUnclaim(LandChangeEvent event, Kingdom kingdom, KingdomPlayer kp) {
        if (kp.getAutoClaim() != Boolean.FALSE) {
            return;
        }
        SimpleChunkLocation chunk = event.getToChunk();
        UnclaimProcessor processor = new UnclaimProcessor(chunk, kp, kingdom, true);
        processor.asAuto();
        processor.process();
        if (!processor.isSuccessful()) {
            processor.sendIssue((CommandSender)kp.getPlayer());
            return;
        }
        processor.finalizeRequest();
        Land land = chunk.getLand();
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
            if (land.unclaim(kp, UnclaimLandEvent.Reason.AUTO_UNCLAIMED).isCancelled()) {
                return;
            }
            KingdomsLang.AUTO_UNCLAIM_SUCCESS.sendMessage((CommandSender)player, "world", chunk.getWorld(), "x", chunk.getX(), "z", chunk.getZ());
        });
    }

    public static void autoClaim(LandChangeEvent event, Kingdom kingdom, KingdomPlayer kp) {
        if (kp.getAutoClaim() != Boolean.TRUE) {
            return;
        }
        Player player = event.getPlayer();
        SimpleChunkLocation chunk = event.getToChunk();
        ClaimProcessor processor = new ClaimProcessor(chunk, kp, kingdom);
        processor.asAuto();
        processor.process();
        if (processor.isSuccessful()) {
            processor.finalizeRequest();
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
                if (kingdom.claim(chunk, kp, ClaimLandEvent.Reason.AUTO_CLAIMED).isCancelled()) {
                    return;
                }
                KingdomsLang.AUTO_CLAIM_SUCCESS.sendMessage((CommandSender)player, "world", chunk.getWorld(), "x", chunk.getX(), "z", chunk.getZ());
            });
        } else {
            processor.sendIssue((CommandSender)player);
        }
    }

    @EventHandler
    public void onDisabledWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.isAdmin() && kp.getAutoClaim() != null && ConfigUtils.isInDisabledWorld(KingdomsConfig.Claims.DISABLED_WORLDS.getManager(), player, KingdomsLang.AUTO_CLAIM_DISABLED_WORLD)) {
            kp.setAutoClaim(null);
        }
    }
}

