/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.claiming;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.time.TimeFormatter;

public final class UnclaimProcessor
extends AbstractClaimProcessor {
    private static final Cooldown<SimpleChunkLocation> COOLDOWN = new Cooldown();
    private final boolean confirmed;

    public UnclaimProcessor(SimpleChunkLocation chunk, KingdomPlayer kp, Kingdom kingdom, boolean confirmed) {
        super(chunk, kp, kingdom);
        this.confirmed = confirmed;
    }

    @Override
    public AbstractClaimProcessor recompile() {
        return new UnclaimProcessor(this.chunk, this.kp, this.kingdom, this.confirmed).process();
    }

    @Override
    protected KingdomsLang checkConstants() {
        return null;
    }

    @Override
    public UnclaimProcessor process() {
        this.issue = this.processIssue();
        return this;
    }

    @Override
    public KingdomsLang processIssue() {
        boolean canUnclaimAny = this.kp.hasPermission(StandardKingdomPermission.UNCLAIM);
        if (!canUnclaimAny && !this.kp.hasPermission(StandardKingdomPermission.UNCLAIM_OWNED)) {
            return StandardKingdomPermission.UNCLAIM.getDeniedMessage();
        }
        Kingdom kingdom = this.kp.getKingdom();
        long unclaimCd = COOLDOWN.getTimeLeft(this.chunk);
        if (unclaimCd > 0L) {
            this.var("time", TimeFormatter.of(unclaimCd));
            return KingdomsLang.COMMAND_UNCLAIM_COOLDOWN;
        }
        Land land = this.chunk.getLand();
        if (land == null || !land.isClaimed()) {
            return KingdomsLang.COMMAND_UNCLAIM_NOT_CLAIMED;
        }
        if (!land.getKingdomId().equals(kingdom.getId())) {
            return KingdomsLang.COMMAND_UNCLAIM_OCCUPIED_LAND;
        }
        if (!this.kp.isAdmin()) {
            Pair<Long, Double> costs = UnclaimProcessor.calculateRefund(kingdom, 1, this.auto);
            if (costs != null) {
                this.rp = costs.getKey();
                this.money = costs.getValue();
                this.var("rp", this.rp);
                this.var("money", this.money);
            }
            if (land.getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNexus()) != null && !KingdomsConfig.NEXUS_ALLOW_REMOVAL.getBoolean()) {
                return KingdomsLang.COMMAND_UNCLAIM_CANNOT_REMOVE_NEXUS;
            }
        }
        if (!canUnclaimAny && !this.kp.getId().equals(land.getClaimedBy())) {
            this.var("claimer", Bukkit.getOfflinePlayer((UUID)land.getClaimedBy()).getName());
            return KingdomsLang.PERMISSIONS_UNCLAIM_OWNED;
        }
        if (!this.confirmed) {
            if (KingdomsConfig.Claims.UNCLAIM_CONFIRMATION_HOME.getManager().getBoolean() && land.isHomeLand()) {
                return KingdomsLang.COMMAND_UNCLAIM_CONFIRMATION_HOME;
            }
            if (KingdomsConfig.Claims.UNCLAIM_CONFIRMATION_STRUCTURES.getManager().getBoolean() && !land.getStructures().isEmpty()) {
                return KingdomsLang.COMMAND_UNCLAIM_CONFIRMATION_STRUCTURES;
            }
            if (KingdomsConfig.Claims.UNCLAIM_CONFIRMATION_TURRETS.getManager().getBoolean() && !land.getTurrets().isEmpty()) {
                return KingdomsLang.COMMAND_UNCLAIM_CONFIRMATION_TURRETS;
            }
        }
        if (Land.disconnectsLandsAfterUnclaim(this.chunk, kingdom)) {
            return KingdomsLang.COMMAND_UNCLAIM_DISCONNECTION;
        }
        return null;
    }

    public static Pair<Long, Double> calculateRefund(Kingdom kingdom, int lands, boolean auto) {
        int remainingLands;
        int starterPackLeft;
        int starterPack = KingdomsConfig.Claims.STARTER_FREE.getManager().getInt();
        int currentLands = kingdom.getLandLocations().size();
        if (currentLands - lands <= starterPack && (lands -= (starterPackLeft = starterPack - (remainingLands = currentLands - lands))) <= 0) {
            return null;
        }
        PlaceholderContextBuilder ctx = new PlaceholderContextBuilder().withContext(kingdom);
        KingdomsConfig.Claims rpOpt = auto ? KingdomsConfig.Claims.RESOURCE_POINTS_REFUND_AUTO_UNCLAIM : KingdomsConfig.Claims.RESOURCE_POINTS_REFUND_UNCLAIM;
        long rp = (long)MathUtils.eval(rpOpt.getManager().getMathExpression(), ctx);
        double money = 0.0;
        if (ServiceHandler.bankServiceAvailable()) {
            KingdomsConfig.Claims moneyOpt = auto ? KingdomsConfig.Claims.MONEY_REFUND_AUTO_UNCLAIM : KingdomsConfig.Claims.MONEY_REFUND_UNCLAIM;
            money = MathUtils.eval(moneyOpt.getManager().getMathExpression(), ctx);
        }
        return Pair.of(rp * (long)lands, money * (double)lands);
    }

    public static Cooldown<SimpleChunkLocation> getUnclaimCooldown() {
        return COOLDOWN;
    }
}

