/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.holograms;

import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.Land;
import org.kingdoms.data.managers.LandManager;
import org.kingdoms.events.lands.AsyncBatchLandLoadEvent;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.holograms.KingdomItemHologramProcessor;
import org.kingdoms.managers.land.holograms.TemporaryHologramProcessor;

public final class KingdomItemHologramManager
implements Listener {
    @EventHandler
    public void loadedLandsHologramLoad(AsyncBatchLandLoadEvent event) {
        KingdomItemHologramProcessor hologramProcessor = new KingdomItemHologramProcessor(true, false);
        for (Land land : event.getLands()) {
            hologramProcessor.add(land);
        }
        hologramProcessor.process(Bukkit.getOnlinePlayers());
    }

    public static void spawnHolograms(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            World world = player.getWorld();
            LandManager landManager = Kingdoms.get().getDataCenter().getLandManager();
            KingdomItemHologramProcessor hologramProcessor = new KingdomItemHologramProcessor(false, false);
            for (Land land : landManager.getLoadedData()) {
                if (!world.getName().equals(land.getLocation().getWorld())) continue;
                hologramProcessor.add(land);
            }
            hologramProcessor.process(Collections.singletonList(player));
        });
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        KingdomItemHologramManager.spawnHolograms(event.getPlayer());
    }

    @EventHandler
    public void onJoin(PlayerQuitEvent event) {
        TemporaryHologramProcessor.cancel(event.getPlayer());
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        KingdomItemHologramManager.spawnHolograms(event.getPlayer());
    }

    static {
        long hologramUpdateRate = KingdomsConfig.HOLOGRAM_UPDATE_TICKS.getLong();
        if (hologramUpdateRate > 0L) {
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Kingdoms.get(), () -> {
                LandManager landManager = Kingdoms.get().getDataCenter().getLandManager();
                KingdomItemHologramProcessor hologramProcessor = new KingdomItemHologramProcessor(true, true);
                for (Land land : landManager.getLoadedData()) {
                    hologramProcessor.add(land);
                }
                hologramProcessor.process(Bukkit.getOnlinePlayers());
            }, hologramUpdateRate, hologramUpdateRate);
        }
    }
}

