/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.holograms;

import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.utils.internal.Fn;

public final class KingdomItemHologramProcessor {
    private final Collection<Pair<SimpleChunkLocation, Collection<KingdomItem<?>>>> kingdomItems = new ArrayList(10);
    private final boolean checkWorlds;
    private final boolean isUpdating;

    public KingdomItemHologramProcessor(boolean checkWorlds, boolean isUpdating) {
        this.checkWorlds = checkWorlds;
        this.isUpdating = isUpdating;
    }

    public void add(Land land) {
        this.kingdomItems.add((Pair)Fn.cast(Pair.of(land.getLocation(), land.getTurrets().values())));
        this.kingdomItems.add((Pair)Fn.cast(Pair.of(land.getLocation(), land.getStructures().values())));
    }

    private Collection<? extends Player> filterPlayers(Collection<? extends Player> players, Kingdom itemKingdom) {
        ArrayList<Player> chosenPlayers = new ArrayList<Player>(players.size());
        for (Player player : players) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom playerKingdom = kp.getKingdom();
            if (!kp.isAdmin() && !KingdomsPluginPermission.SEE_OTHERS_HOLOGRAMS.hasPermission((CommandSender)player, false) && !StandardRelationAttribute.SHOW_HOLOGRAMS.hasAttribute(playerKingdom, itemKingdom)) continue;
            chosenPlayers.add(player);
        }
        return chosenPlayers;
    }

    public void process(Collection<? extends Player> players) {
        for (Pair<SimpleChunkLocation, Collection<KingdomItem<?>>> kingdomItemPair : this.kingdomItems) {
            Collection<? extends Player> chosenPlayersForWorld = players;
            if (this.checkWorlds) {
                ArrayList<? extends Player> playersInWorld = new ArrayList<Player>(players.size());
                chosenPlayersForWorld = playersInWorld;
                for (Player player : players) {
                    if (!player.getWorld().getName().equals(kingdomItemPair.getKey().getWorld())) continue;
                    playersInWorld.add((Player)player);
                }
            }
            for (KingdomItem<?> item : kingdomItemPair.getValue()) {
                if (this.isUpdating) {
                    if (((KingdomItemStyle)item.getStyle()).getOption("dont-update-holograms").getBoolean()) continue;
                    item.removeHolograms();
                }
                Kingdom kingdom = item.getLand().getKingdom();
                Collection<? extends Player> chosenPlayers = chosenPlayersForWorld;
                if (((KingdomItemStyle)item.getStyle()).hideHolograms()) {
                    chosenPlayers = this.filterPlayers(chosenPlayers, kingdom);
                }
                item.spawnHolograms(kingdom, chosenPlayers);
            }
        }
    }
}

