/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.protection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.libs.xseries.XEntity;
import org.kingdoms.libs.xseries.XPotion;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomEntity;
import org.kingdoms.managers.entity.types.KingdomLandEntity;
import org.kingdoms.services.ServiceMythicMobs;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.utils.ConditionProcessor;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.integer.IntHashMap;
import org.kingdoms.utils.string.StringUtils;

public final class KingdomGuardManager
implements Listener {
    public static final String GUARD_METADATA = "GUARDS";
    public static final IntHashMap<GuardSession> GUARDING = new IntHashMap();

    protected static void despawnGuards(Player player, boolean cancel) {
        GuardSession guards = GUARDING.remove(player.getEntityId());
        if (guards == null) {
            return;
        }
        if (cancel) {
            guards.autoCleaner.cancel();
        }
        ParticleDisplay display = ParticleDisplay.simple(null, Particle.SPELL_WITCH);
        for (KingdomEntity kingdomGuard : guards.guards) {
            LivingEntity guard = (LivingEntity)kingdomGuard.getEntity();
            if (!guard.isValid()) continue;
            display.spawn(guard.getLocation());
            guard.setHealth(0.0);
            KingdomEntityRegistry.removeMob(guard);
        }
    }

    public static void spawnGuards(MiscUpgrade type, Kingdom belongingKingdom, Player target, boolean useDelay, Function<Entity, KingdomEntity> entityCtor) {
        if (!type.isEnabled()) {
            return;
        }
        int lvl = belongingKingdom.getUpgradeLevel(type);
        if (lvl <= 0) {
            return;
        }
        ConfigSection mainSection = KingdomsConfig.MISC_UPGRADE.accessor().gotoSection(StringUtils.configOption(type)).getSection();
        KeyedYamlConfigAccessor option = KingdomsConfig.MiscUpgrades.LEVELS.getManager().noDefault().withOption("upgrade", StringUtils.configOption(type)).withProperty(String.valueOf(lvl));
        YamlConfigAccessor section = option.getSection();
        if (section == null) {
            MessageHandler.sendConsolePluginMessage("&4Unknown level entry for &e" + type + " &cmisc upgrade at level&8: &e" + lvl);
            return;
        }
        if (useDelay) {
            int delay = mainSection.getInt("spawn-delay");
            if (delay <= 0) {
                delay = 0;
            } else {
                KingdomsLang.KINGDOM_GUARDS_SPAWNING.sendMessage((CommandSender)target, new MessageBuilder().withContext(belongingKingdom));
            }
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)Kingdoms.get(), () -> KingdomGuardManager.spawnGuards(belongingKingdom, target, section, entityCtor), (long)delay);
        } else {
            KingdomGuardManager.spawnGuards(belongingKingdom, target, section, entityCtor);
        }
    }

    public static void spawnGuards(Kingdom belongingKingdom, Player target, YamlConfigAccessor section, Function<Entity, KingdomEntity> entityCtor) {
        Location location = target.getLocation();
        ArrayList group = new ArrayList();
        KLogger.debug((DebugNS)KingdomsDebug.GUARDS_SPAWN_SPAWNED, () -> "Spawning guards around " + target.getName() + " for kingdom " + belongingKingdom.getName());
        int insanity = belongingKingdom.getUpgradeLevel(MiscUpgrade.INSANITY);
        List<Object> effects = insanity > 0 ? XPotion.parseEffects(MiscUpgrade.INSANITY.getConfig().getStringList("effects", String.valueOf(insanity))) : new ArrayList();
        for (String guards : section.getKeys()) {
            YamlConfigAccessor guardSection = section.noDefault().gotoSection(guards);
            String mm = guardSection.getString("mythicmob");
            boolean isCustom = mm != null && SoftService.MYTHIC_MOBS.isAvailable();
            int total = Math.max(0, guardSection.getInt("amount"));
            int minRadius = 5;
            int maxRadius = 20;
            AtomicInteger i = new AtomicInteger();
            LocationUtils.attemptSafeLocation(minRadius, 3, maxRadius, 5, location, safeLoc -> {
                Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
                    Location finalLocation = safeLoc == null ? location : safeLoc;
                    LivingEntity guard = (LivingEntity)(isCustom ? ((ServiceMythicMobs)SoftService.MYTHIC_MOBS.getService()).spawnMythicMob(finalLocation, mm, section.getInt("lvl")) : XEntity.spawn(finalLocation, guardSection.getCurrentSection().toBukkitConfigurationSection()));
                    if (guard == null) {
                        MessageHandler.sendConsolePluginMessage("&4Unable to parse guard entity with entry &e" + guardSection.getCurrentPath() + "&8:");
                        guardSection.getEntries().forEach((k, v) -> MessageHandler.sendConsolePluginMessage("&6" + k + "&8: &e" + (v instanceof ConfigurationSection ? "" : v)));
                        return;
                    }
                    guard.setCustomName(MessageCompiler.compile(guardSection.getString("name")).buildPlain(new MessageBuilder().withContext(belongingKingdom)));
                    for (XPotion.Effect effect : effects) {
                        effect.apply(guard);
                    }
                    if (guard instanceof Monster) {
                        ((Monster)guard).setTarget((LivingEntity)target);
                    }
                    KingdomEntity mob = (KingdomEntity)entityCtor.apply((Entity)guard);
                    guard.setMetadata(GUARD_METADATA, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)mob));
                    group.add(mob);
                    KingdomEntityRegistry.addMob(mob);
                });
                return i.incrementAndGet() < total;
            });
        }
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> KingdomGuardManager.despawnGuards(target, false), 1200L);
        GUARDING.put(target.getEntityId(), new GuardSession(group, task));
    }

    @EventHandler
    public void onTargetQuit(PlayerQuitEvent event) {
        KingdomGuardManager.despawnGuards(event.getPlayer(), true);
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        KingdomGuardManager.despawnGuards(event.getEntity(), true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onTargetTeleport(PlayerTeleportEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT || event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            return;
        }
        KingdomGuardManager.despawnGuards(event.getPlayer(), true);
    }

    public static void onGuardSpawn(LandChangeEvent event) {
        Player player = event.getPlayer();
        if (player.isInvulnerable()) {
            return;
        }
        if (PlayerUtils.invulnerableGameMode(player)) {
            return;
        }
        if (PlayerUtils.isEffectivelyInvisible(player)) {
            return;
        }
        if (ServiceHandler.isVanished(player)) {
            return;
        }
        if (GUARDING.containsKey(player.getEntityId())) {
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player)) {
            return;
        }
        KLogger.debug((DebugNS)KingdomsDebug.GUARDS_SPAWN_SIMPLE$CHECKS, () -> "Kingdom guard spawning system has passed simple checks for " + player.getName());
        Land to = event.getToLand();
        if (to == null || !to.isClaimed()) {
            return;
        }
        KingdomPlayer kp = event.getKingdomPlayer();
        if (kp.isAdmin()) {
            return;
        }
        Kingdom playerKingdom = kp.getKingdom();
        if (playerKingdom != null && playerKingdom.isPacifist()) {
            return;
        }
        Kingdom landKingdom = to.getKingdom();
        if (StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(playerKingdom, landKingdom) || StandardRelationAttribute.CEASEFIRE.hasAttribute(playerKingdom, landKingdom)) {
            return;
        }
        MiscUpgrade upgrade = to.getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNexus()) != null ? MiscUpgrade.NEXUS_GUARDS : MiscUpgrade.GUARDS;
        ConditionalCompiler.LogicalOperand condition = upgrade.getConfig().getCondition("condition");
        if (condition != null && ConditionProcessor.process(condition, new MessageBuilder().withContext(player).other(landKingdom))) {
            KLogger.debug((DebugNS)KingdomsDebug.GUARDS_SPAWN_ATTEMPT, () -> "Condition " + condition + " not passed for " + upgrade + " -> " + upgrade.isEnabled() + " with level " + landKingdom.getUpgradeLevel(upgrade));
            return;
        }
        KLogger.debug((DebugNS)KingdomsDebug.GUARDS_SPAWN_ATTEMPT, () -> "Attempting to spawn guards while upgrade is " + upgrade + " -> " + upgrade.isEnabled() + " with level " + landKingdom.getUpgradeLevel(upgrade));
        KingdomGuardManager.spawnGuards(upgrade, landKingdom, player, true, guard -> new KingdomLandEntity((Entity)guard, to, (LivingEntity)player));
    }

    private static final class GuardSession {
        private final List<KingdomEntity> guards;
        private final BukkitTask autoCleaner;

        private GuardSession(List<KingdomEntity> guards, BukkitTask autoCleaner) {
            this.guards = guards;
            this.autoCleaner = autoCleaner;
        }
    }
}

