/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.protection;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.ItemMatcher;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.cooldown.BiCooldown;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.time.TimeUtils;

public final class MiscUpgradeManager
implements Listener {
    private static final Material SOIL = XMaterial.FARMLAND.parseMaterial();
    private static final Map<UUID, Integer> INVASION_COOLDOWN = new HashMap<UUID, Integer>();
    private static final BiCooldown<UUID, UUID> ALERTS = new BiCooldown();

    public static long getInvadeRefreshCd(Kingdom kingdom) {
        String eqn = MiscUpgrade.INVASIONS.getConfig().getString("refresh-cooldown");
        return (long)MathUtils.eval(eqn, kingdom, "lvl", kingdom.getUpgradeLevel(MiscUpgrade.INVASIONS));
    }

    public static boolean canPlaceItemInKingdomChest(ItemStack item) {
        ConfigSection config = MiscUpgrade.CHEST_SIZE.getConfig().getSection().getSection("items");
        if (config == null) {
            return true;
        }
        boolean blacklist = config.getBoolean("blacklist");
        for (ConfigSection itemConfig : config.getSection("list").getSections().values()) {
            ItemMatcher matcher = new ItemMatcher(itemConfig);
            if (matcher.matches(item) != blacklist) continue;
            return false;
        }
        return true;
    }

    public static void invaded(Kingdom attacker) {
        if (!MiscUpgrade.INVASIONS.isEnabled()) {
            return;
        }
        INVASION_COOLDOWN.compute(attacker.getId(), (k, v) -> v == null ? 1 : v + 1);
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> INVASION_COOLDOWN.computeIfPresent(attacker.getId(), (k, v) -> v - 1), TimeUtils.millisToTicks(MiscUpgradeManager.getInvadeRefreshCd(attacker)));
    }

    public static Map<UUID, Integer> getInvasionCooldown() {
        return INVASION_COOLDOWN;
    }

    public static boolean canInvade(Kingdom attacker) {
        if (!MiscUpgrade.INVASIONS.isEnabled()) {
            return true;
        }
        Integer count = INVASION_COOLDOWN.get(attacker.getId());
        if (count == null) {
            return true;
        }
        return (double)count.intValue() < MiscUpgrade.INVASIONS.getScaling(attacker);
    }

    public static void onEnemyEnterAlert(LandChangeEvent event) {
        if (ServiceHandler.isVanished(event.getPlayer())) {
            return;
        }
        KingdomPlayer kp = event.getKingdomPlayer();
        if (kp.isAdmin()) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        Land to = event.getToLand();
        if (to == null || !to.isClaimed()) {
            return;
        }
        Kingdom toKingdom = to.getKingdom();
        if (kingdom.getRelationWith(toKingdom) != KingdomRelation.ENEMY) {
            return;
        }
        if (toKingdom.isClaimed(event.getFromChunk())) {
            return;
        }
        if (ALERTS.isInCooldown(toKingdom.getId(), kp.getId())) {
            return;
        }
        ALERTS.add(toKingdom.getId(), kp.getId(), 1L, TimeUnit.MINUTES);
        Location loc = event.getPlayer().getLocation();
        MessageBuilder settings = new MessageBuilder().raws("world", loc.getWorld().getName(), "x", loc.getBlockX(), "y", loc.getBlockY(), "z", loc.getBlockZ());
        for (Player member : toKingdom.getOnlineMembers()) {
            KingdomsLang.MISC_UPGRADES_ALERTS_NOTIFY_MEMBERS.sendMessage((CommandSender)member, settings.withContext(event.getPlayer()));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCropTrample(PlayerInteractEvent event) {
        if (event.getAction() != Action.PHYSICAL) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block.getType() != SOIL) {
            return;
        }
        if (!MiscUpgrade.ANTI_TRAMPLE.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return;
        }
        Land land = Land.getLand(block);
        if (land == null || !land.isClaimed()) {
            return;
        }
        Kingdom kingdomLand = land.getKingdom();
        if (kingdomLand.hasAttribute(kp.getKingdom(), (RelationAttribute)StandardRelationAttribute.BUILD)) {
            return;
        }
        if (land.getKingdom().getUpgradeLevel(MiscUpgrade.ANTI_TRAMPLE) > 0) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onGlory(EntityDeathEvent event) {
        if (!MiscUpgrade.GLORY.isEnabled()) {
            return;
        }
        LivingEntity victim = event.getEntity();
        Player killer = victim.getKiller();
        if (killer == null) {
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)killer)) {
            return;
        }
        Land land = Land.getLand(victim.getLocation());
        if (land == null) {
            return;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            return;
        }
        int lvl = kingdom.getUpgradeLevel(MiscUpgrade.GLORY);
        if (lvl <= 0) {
            return;
        }
        int drop = event.getDroppedExp();
        if (victim.getType() == EntityType.PLAYER) {
            if (lvl > 1) {
                drop *= 5;
            }
        } else {
            drop *= 3;
        }
        event.setDroppedExp(drop);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPearlTeleport(PlayerTeleportEvent event) {
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            return;
        }
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Land toLand = Land.getLand(event.getTo());
        if (toLand == null || !toLand.isClaimed()) {
            return;
        }
        Kingdom toLandKingdom = toLand.getKingdom();
        if (toLandKingdom.getUpgradeLevel(MiscUpgrade.ANTI_TRAMPLE) < 3) {
            return;
        }
        Kingdom playerKingdom = kp.getKingdom();
        if (!StandardRelationAttribute.CEASEFIRE.hasAttribute(toLandKingdom, playerKingdom) || !StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(toLandKingdom, playerKingdom)) {
            event.setCancelled(true);
            ParticleDisplay.of(Particle.CLOUD).withCount(10).spawn(event.getTo());
            KingdomsLang.LANDS_ENDER_PEARL_PROTECTION.sendError((CommandSender)player, new Object[0]);
        }
    }

    @EventHandler
    public void onResourcePointsPenalty(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player)) {
            return;
        }
        if (KingdomsConfig.ResourcePoints.DEATH_PENALTY_DISABLED_WORLDS.getManager().isInDisabledWorld((Entity)player)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        long penalty = (long)MathUtils.eval(KingdomsConfig.ResourcePoints.DEATH_PENALTY_AMOUNT.getManager().getString(), (OfflinePlayer)player, new Object[0]);
        if (penalty == 0L) {
            return;
        }
        if (kingdom.hasResourcePoints(penalty)) {
            kingdom.addResourcePoints(-penalty);
            Object[] edits = new Object[]{"penalty", StringUtils.toFancyNumber(penalty), "name", player.getName()};
            for (Player member : kingdom.getOnlineMembers()) {
                KingdomsLang.DEATH_PENALTY.sendMessage((CommandSender)member, (OfflinePlayer)player, edits);
            }
        }
    }
}

