/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.logger;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.daily.TimeZoneHandler;
import org.kingdoms.utils.cache.CacheHandler;
import org.kingdoms.utils.time.TimeUtils;

public final class KingdomsLogger {
    private static final DateTimeFormatter DATE_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final Path PARENT = Kingdoms.get().getDataFolder().toPath().resolve("logs");
    private static final String EXTENSION = ".log";
    private static final KingdomsLogger MAIN = new KingdomsLogger();
    private BufferedWriter writer;

    public KingdomsLogger(BufferedWriter writer) {
        this.writer = writer;
    }

    public KingdomsLogger(Path path) {
        this.setupWriter(path);
    }

    public KingdomsLogger() {
        this.setupWriter(PARENT.resolve(this.buildFilePath()));
    }

    public static KingdomsLogger getMain() {
        return MAIN;
    }

    private static Path setupDir(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return path;
    }

    private static String getTime() {
        return '[' + TimeUtils.TIME_FORMAT.format(ZonedDateTime.now(TimeZoneHandler.SERVER_TIME_ZONE)) + ']';
    }

    public void flush() {
        try {
            KingdomsLogger.MAIN.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setupWriter(Path path) {
        BufferedWriter writer;
        try {
            KingdomsLogger.setupDir(path);
            writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
            writer = null;
        }
        this.writer = writer;
    }

    public KingdomsLogger log(String str) {
        try {
            this.writer.write(KingdomsLogger.getTime() + ' ' + str);
            this.writer.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public KingdomsLogger newLine() {
        try {
            this.writer.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public String buildFilePath() {
        return ZonedDateTime.now(TimeZoneHandler.SERVER_TIME_ZONE).format(DATE_PATTERN) + EXTENSION;
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        Duration time = TimeUtils.getTimeUntilTomrrow(TimeZoneHandler.SERVER_TIME_ZONE);
        CacheHandler.newScheduler().scheduleAtFixedRate(() -> {
            MAIN.close();
            Path path = KingdomsLogger.setupDir(PARENT.resolve(MAIN.buildFilePath()));
            MAIN.setupWriter(path);
        }, time.toMillis(), TimeUnit.DAYS.toMillis(1L), TimeUnit.MILLISECONDS);
    }
}

