/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.logger.gui;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIPagination;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.daily.TimeZoneHandler;
import org.kingdoms.managers.logger.gui.AuditLogFilter;
import org.kingdoms.managers.logger.gui.AuditLogPlayerFilter;
import org.kingdoms.managers.logger.gui.AuditLogTimeFilter;
import org.kingdoms.managers.logger.gui.AuditLogTypeFilter;
import org.kingdoms.managers.logger.gui.SortType;
import org.kingdoms.managers.structures.NexusManager;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;
import org.kingdoms.utils.time.TimeUtils;

public final class KingdomLogGUI {
    private final Map<Class<? extends AuditLogFilter>, AuditLogFilter> filters = new HashMap<Class<? extends AuditLogFilter>, AuditLogFilter>();
    private final Set<SortType> sortTypes = new QuickEnumSet((Enum[])SortType.values());
    private final Player player;
    private final Group group;
    private final Consumer<InteractiveGUI> modifier;
    private int page;

    public KingdomLogGUI(Player player, Group group, int page, Consumer<InteractiveGUI> modifier) {
        this.player = player;
        this.group = group;
        this.modifier = modifier;
        this.page = page;
    }

    public Collection<AuditLog> prepareLogs() {
        LinkedList<AuditLog> rawLogs = this.group.getLogs();
        if (this.filters.isEmpty() && this.sortTypes.isEmpty()) {
            return rawLogs;
        }
        ArrayList<AuditLog> newLogs = new ArrayList<AuditLog>(rawLogs);
        newLogs.removeIf(x -> this.filters.values().stream().anyMatch(y -> !y.include((AuditLog)x)));
        if (!this.sortTypes.isEmpty()) {
            Comparator<AuditLog> mixedComparator = (a, b) -> 0;
            for (SortType sortType : this.sortTypes) {
                mixedComparator = mixedComparator.thenComparing(sortType.getComparator());
            }
            newLogs.sort(mixedComparator);
        }
        return newLogs;
    }

    private Function<ItemStack, ItemStack> typeModifier(AuditLogProvider provider) {
        return provider == null ? null : item -> {
            InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.STRUCTURES_NEXUS_LOGS);
            String name = provider.getNamespace().getConfigOptionName();
            ItemStack entryItem = gui.option("entry").setEdits("type", name).constructGUIOptionObject().getItem();
            item.setType(entryItem.getType());
            return item;
        };
    }

    public InteractiveGUI sortingAndFiltersGUI() {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.STRUCTURES_NEXUS_LOGS$FILTERS$AND$SORTING);
        if (gui == null) {
            return null;
        }
        this.filters.values().forEach(x -> x.addEdits(gui.getSettings()));
        AuditLogPlayerFilter playerFilter = (AuditLogPlayerFilter)this.filters.get(AuditLogPlayerFilter.class);
        gui.option("filters-player").setEdits("enabled", this.filters.containsKey(AuditLogPlayerFilter.class)).on(ClickType.LEFT, ctx -> {
            ctx.sendMessage(KingdomsLang.AUDIT_LOGS_FILTERS_PLAYER_ENTER, new Object[0]);
            ctx.startConversation();
        }).setConversation((ctx, input) -> {
            OfflinePlayer target = PlayerUtils.getOfflinePlayerWarn(this.player, input);
            if (target == null) {
                return;
            }
            this.filters.put(AuditLogPlayerFilter.class, new AuditLogPlayerFilter(target.getUniqueId()));
            ctx.endConversation();
            this.sortingAndFiltersGUI();
        }).on(ClickType.RIGHT, () -> {
            this.filters.remove(AuditLogPlayerFilter.class);
            this.sortingAndFiltersGUI();
        }).pushHead(playerFilter == null ? null : Bukkit.getOfflinePlayer((UUID)playerFilter.getPlayer()));
        AuditLogTypeFilter typeFilter = (AuditLogTypeFilter)this.filters.get(AuditLogTypeFilter.class);
        gui.option("filters-type").setEdits("enabled", typeFilter != null).on(ClickType.LEFT, ctx -> {
            ctx.sendMessage(KingdomsLang.AUDIT_LOGS_FILTERS_TYPE_ENTER, new Object[0]);
            ctx.startConversation();
        }).setConversation((ctx, input) -> {
            AuditLogProvider type;
            Namespace ns;
            try {
                ns = Namespace.fromConfigString(input);
            }
            catch (Exception ex) {
                ns = null;
            }
            AuditLogProvider auditLogProvider = type = ns == null ? null : (AuditLogProvider)Kingdoms.get().getAuditLogRegistry().getRegistered(ns);
            if (type == null) {
                ctx.sendError(KingdomsLang.AUDIT_LOGS_FILTERS_TYPE_INVALID, "type", input);
                return;
            }
            this.filters.put(AuditLogTypeFilter.class, new AuditLogTypeFilter(type));
            ctx.endConversation();
            this.sortingAndFiltersGUI();
        }).on(ClickType.RIGHT, () -> {
            this.filters.remove(AuditLogTypeFilter.class);
            this.sortingAndFiltersGUI();
        }).editItem(this.typeModifier(typeFilter == null ? null : typeFilter.getType())).done();
        gui.option("filters-time").setEdits("enabled", this.filters.containsKey(AuditLogTimeFilter.class)).on(ClickType.LEFT, ctx -> {
            ctx.sendMessage(KingdomsLang.AUDIT_LOGS_FILTERS_TIME_ENTER, new Object[0]);
            ctx.startConversation();
        }).setConversation((ctx, input) -> {
            String beforeStr;
            String[] split = input.split("-");
            String afterStr = split[0];
            Long after = KingdomLogGUI.parseDate(afterStr);
            if (after == null) {
                ctx.sendError(KingdomsLang.AUDIT_LOGS_FILTERS_TIME_INVALID, "input", afterStr);
                return;
            }
            Long before = null;
            if (split.length > 1 && (before = KingdomLogGUI.parseDate(beforeStr = split[1])) == null) {
                ctx.sendError(KingdomsLang.AUDIT_LOGS_FILTERS_TIME_INVALID, "input", beforeStr);
                return;
            }
            this.filters.put(AuditLogTimeFilter.class, new AuditLogTimeFilter(after, before == null ? Long.MAX_VALUE : before));
            ctx.endConversation();
            this.sortingAndFiltersGUI();
        }).on(ClickType.RIGHT, () -> {
            this.filters.remove(AuditLogTimeFilter.class);
            this.sortingAndFiltersGUI();
        }).done();
        gui.option("sort-ascending-time").setEdits("enabled", this.sortTypes.contains((Object)SortType.TIME_ASCENDING)).onNormalClicks(() -> {
            if (this.sortTypes.remove((Object)SortType.TIME_DESCENDING) || !this.sortTypes.remove((Object)SortType.TIME_ASCENDING)) {
                this.sortTypes.add(SortType.TIME_ASCENDING);
            }
            this.sortingAndFiltersGUI();
        }).done();
        gui.option("sort-descending-time").setEdits("enabled", this.sortTypes.contains((Object)SortType.TIME_DESCENDING)).onNormalClicks(() -> {
            if (this.sortTypes.remove((Object)SortType.TIME_ASCENDING) || !this.sortTypes.remove((Object)SortType.TIME_DESCENDING)) {
                this.sortTypes.add(SortType.TIME_DESCENDING);
            }
            this.sortingAndFiltersGUI();
        }).done();
        gui.option("sort-type").setEdits("enabled", this.sortTypes.contains((Object)SortType.TYPE)).onNormalClicks(() -> {
            if (!this.sortTypes.remove((Object)SortType.TYPE)) {
                this.sortTypes.add(SortType.TYPE);
            }
            this.sortingAndFiltersGUI();
        }).done();
        gui.push("back", this::openGUI, new Object[0]);
        gui.open();
        return gui;
    }

    public static Long parseDate(String str) {
        try {
            LocalDate localDateTime = LocalDate.parse(str, DateTimeFormatter.ofPattern("yyyy/M/d"));
            return TimeUnit.DAYS.toMillis(localDateTime.toEpochDay());
        }
        catch (DateTimeParseException e) {
            Long time = TimeUtils.parseTime(str);
            if (time == null) {
                return null;
            }
            return ZonedDateTime.now(TimeZoneHandler.SERVER_TIME_ZONE).minus(time, ChronoUnit.MILLIS).toInstant().toEpochMilli();
        }
    }

    public InteractiveGUI openGUI() {
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
        if (!NexusManager.admin(this.player) && !kp.hasPermission(StandardKingdomPermission.VIEW_LOGS)) {
            StandardKingdomPermission.VIEW_LOGS.sendDeniedMessage(this.player);
            return null;
        }
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.STRUCTURES_NEXUS_LOGS);
        if (gui == null) {
            return null;
        }
        Pair<ReusableOptionHandler, Collection<AuditLog>> pagination = GUIPagination.paginate(gui, this.prepareLogs(), "entry", this.page, openPage -> {
            this.page = openPage;
            this.openGUI();
        });
        this.filters.values().forEach(x -> x.addEdits(gui.getSettings()));
        gui.getSettings().addGroupedPlaceholder("filters", id -> {
            Class filterType;
            switch (id) {
                case "player": {
                    filterType = AuditLogPlayerFilter.class;
                    break;
                }
                case "time": {
                    filterType = AuditLogTimeFilter.class;
                    break;
                }
                case "type": {
                    filterType = AuditLogTypeFilter.class;
                    break;
                }
                default: {
                    return false;
                }
            }
            return this.filters.containsKey(filterType);
        });
        gui.getSettings().addGroupedPlaceholder("sorting", id -> {
            Optional type = Enums.getIfPresent(SortType.class, (String)id.toUpperCase(Locale.ENGLISH));
            if (!type.isPresent()) {
                return false;
            }
            return this.sortTypes.contains(type.get());
        });
        gui.push("filters-and-sorting", this::sortingAndFiltersGUI, new Object[0]);
        for (AuditLog log : pagination.getValue()) {
            ReusableOptionHandler opt = pagination.getKey().setSettings(log.getEdits());
            opt.getSettings().raw("type", log.getProvider().getNamespace().getConfigOptionName());
            ((OptionHandler)opt).done();
        }
        this.modifier.accept(gui);
        return gui;
    }
}

