/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.structures;

import java.awt.Color;
import java.awt.Dimension;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.general.misc.CommandColor;
import org.kingdoms.commands.general.misc.CommandKick;
import org.kingdoms.commands.general.ranking.CommandPromote;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePointsDeposit;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePointsWithdraw;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.ConfigAccessorConfigurationSection;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.logs.lands.LogKingdomInvaded;
import org.kingdoms.constants.group.model.logs.purchases.kingdomitem.LogPurchaseStructure;
import org.kingdoms.constants.group.model.logs.purchases.kingdomitem.LogPurchaseTurret;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.group.upgradable.Powerup;
import org.kingdoms.constants.group.upgradable.champion.ChampionUpgrade;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.events.general.ChampionChangeEvent;
import org.kingdoms.events.general.GroupFlagChangeEvent;
import org.kingdoms.events.general.GroupResourcePointConvertEvent;
import org.kingdoms.events.general.GroupShieldPurchaseEvent;
import org.kingdoms.events.general.KingdomPacifismStateChangeEvent;
import org.kingdoms.events.general.ranks.PlayerRankChangeEvent;
import org.kingdoms.events.general.upgrade.KingdomChampionUpgradeUpgradeEvent;
import org.kingdoms.events.general.upgrade.KingdomMiscUpgradeToggleEvent;
import org.kingdoms.events.general.upgrade.KingdomMiscUpgradeUpgradeEvent;
import org.kingdoms.events.general.upgrade.KingdomPowerupUpgradeEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InteractiveGUIManager;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.ResourcePointManager;
import org.kingdoms.managers.land.protection.KingdomVaultManager;
import org.kingdoms.managers.land.protection.MiscUpgradeManager;
import org.kingdoms.managers.logger.LogManager;
import org.kingdoms.managers.logger.gui.KingdomLogGUI;
import org.kingdoms.managers.mails.MailUserAgent;
import org.kingdoms.managers.structures.RankEditor;
import org.kingdoms.managers.structures.SiegeManager;
import org.kingdoms.managers.structures.StructureManager;
import org.kingdoms.managers.turrets.TurretManager;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.internal.enumeration.OrderedSet;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.time.TimeUtils;

public final class NexusManager {
    private static final Cooldown<UUID> KINGDOM_FLAG_COOLDOWN = new Cooldown();
    private final Group group;
    private final Player player;
    private final KingdomPlayer kp;
    private final MessageBuilder settings;
    private final Kingdom kingdom;
    private final boolean isNation;

    public NexusManager(Group group, Player player) {
        Nation nation;
        this.group = Objects.requireNonNull(group);
        this.player = Objects.requireNonNull(player);
        this.kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        this.isNation = group instanceof Nation;
        Kingdom kingdom = this.kingdom = group instanceof Kingdom ? (Kingdom)group : null;
        Object placeholder = this.kingdom != null ? (this.kingdom.isMember((OfflinePlayer)player) ? player : Bukkit.getOfflinePlayer((UUID)this.kingdom.getKingId())) : ((nation = (Nation)group).isMember(this.kp.getKingdomId()) ? player : nation.getCapital().getKing().getOfflinePlayer());
        this.settings = new MessageBuilder().withContext((OfflinePlayer)placeholder);
    }

    public static boolean admin(Player player) {
        return KingdomsPluginPermission.STRUCTURES_INTERACT.hasPermission((CommandSender)player, false);
    }

    public static void init() {
    }

    public InteractiveGUI openNexus() {
        InteractiveGUI gui = this.nexus();
        if (gui != null) {
            gui.open();
        }
        return gui;
    }

    public InteractiveGUI nexus() {
        if (!NexusManager.admin(this.player) && !this.kp.hasPermission(StandardKingdomPermission.NEXUS)) {
            StandardKingdomPermission.NEXUS.sendDeniedMessage(this.player);
            return null;
        }
        InteractiveGUI gui = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_NEXUS);
        if (gui == null) {
            return null;
        }
        gui.push("members", () -> this.openMembers(0), new Object[0]).push("settings", this::openSettings, new Object[0]).push("ranks", this::openRanks, new Object[0]).push("nexus-chest", this::openNexusChest, new Object[0]).push("misc-upgrades", this::openMiscUpgrades, new Object[0]).push("champion-upgrades", this::openChampionUpgrades, new Object[0]).push("structures", this::openStructures, new Object[0]).push("turrets", this::openTurrets, new Object[0]).push("resource-points", () -> this.openRp(rp -> rp.push("back", () -> {
            ((InventoryInteractiveGUI)rp).returnItems();
            this.openNexus();
        }, new Object[0])), new Object[0]);
        gui.push("mailbox", () -> {
            InteractiveGUI mailbox = MailUserAgent.getMailbox(this.player, this.kingdom, mailboxGUI -> mailboxGUI.push("back", this::openNexus, new Object[0]));
            if (mailbox == null) {
                return;
            }
            mailbox.open();
        }, new Object[0]);
        gui.push("logs", () -> new KingdomLogGUI(this.player, this.kingdom, 0, logs -> {
            logs.push("back", this::openNexus, new Object[0]);
            logs.open();
        }).openGUI(), new Object[0]);
        for (Powerup powerup : Powerup.values()) {
            int maxLevel = powerup.getMaxLevel(gui.getSettings());
            MessageBuilder settings = new MessageBuilder().raw("name", powerup.getDisplayName()).raw("powerup", powerup.getDisplayName()).raw("level", this.kingdom.getUpgradeLevel(powerup)).raw("cost", this.kingdom.getUpgradeCost(powerup)).raw("max-level", maxLevel);
            gui.option(StringUtils.configOption(powerup)).setSettings(settings).onNormalClicks(ctx -> {
                if (!StructureManager.hasPermission(this.player, StandardKingdomPermission.UPGRADE)) {
                    StandardKingdomPermission.UPGRADE.sendDeniedMessage(this.player);
                    return;
                }
                int lvl = this.kingdom.getUpgradeLevel(powerup);
                if (lvl >= maxLevel) {
                    ctx.sendError(KingdomsLang.UPGRADES_POWERUP_MAX, new Object[0]);
                    return;
                }
                long cost = this.kingdom.getUpgradeCost(powerup);
                if (!this.kp.isAdmin() && !this.kingdom.hasResourcePoints(cost)) {
                    ctx.sendError(KingdomsLang.UPGRADES_POWERUP_NOT_ENOUGH_RESOURCEPOINTS, new Object[0]);
                    return;
                }
                KingdomPowerupUpgradeEvent event = new KingdomPowerupUpgradeEvent(this.kingdom, powerup, this.kp, lvl, lvl + 1, cost);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                if (!this.kp.isAdmin()) {
                    this.kingdom.addResourcePoints(-cost);
                }
                this.kingdom.setUpgradeLevel(powerup, event.getNewLevel());
                ctx.getSettings().raw("new_level", event.getNewLevel());
                ctx.sendMessage(KingdomsLang.UPGRADES_POWERUP_UPGRADE, new Object[0]);
                this.openNexus();
            }).done();
        }
        return gui;
    }

    private InteractiveGUI prepare(KingdomsGUI gui) {
        return GUIAccessor.prepare(this.player, gui, this.settings);
    }

    public InteractiveGUI openTurrets() {
        if (!NexusManager.admin(this.player) && !this.kp.hasPermission(StandardKingdomPermission.TURRETS)) {
            StandardKingdomPermission.TURRETS.sendDeniedMessage(this.player);
            return null;
        }
        InteractiveGUI turrets = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_TURRETS);
        if (turrets == null) {
            return null;
        }
        turrets.push("back", this::openNexus, new Object[0]);
        PlayerInventory inv = this.player.getInventory();
        for (Map.Entry<String, TurretStyle> turret : TurretRegistry.getStyles().entrySet()) {
            TurretStyle style = turret.getValue();
            long cost = (long)style.getCost(this.kingdom);
            if (!style.hasItem()) {
                throw new IllegalStateException("Misconfigured turret '" + style.getName() + "' no 'item' option present.");
            }
            turrets.push(StringUtils.configOption(turret.getKey()), () -> this.lambda$openTurrets$32((Inventory)inv, cost, style), "cost", cost);
        }
        turrets.open();
        return turrets;
    }

    public InteractiveGUI openStructures() {
        if (!NexusManager.admin(this.player) && !this.kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
            StandardKingdomPermission.STRUCTURES.sendDeniedMessage(this.player);
            return null;
        }
        InteractiveGUI structures = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_STRUCTURES);
        if (structures == null) {
            return null;
        }
        structures.push("back", this::openNexus, new Object[0]);
        PlayerInventory inv = this.player.getInventory();
        for (StructureStyle style : StructureRegistry.getStyles().values()) {
            if (((StructureType)style.getType()).isNexus()) continue;
            long cost = (long)style.getCost(this.kingdom);
            if (!style.hasItem()) {
                throw new IllegalStateException("Misconfigured structure '" + style.getName() + "' no 'item' option present.");
            }
            structures.push(style.getName(), () -> this.lambda$openStructures$34((Inventory)inv, cost, style), "cost", cost);
        }
        structures.open();
        return structures;
    }

    public void openNexusChest() {
        if (!NexusManager.admin(this.player) && !this.kp.hasPermission(StandardKingdomPermission.NEXUS_CHEST)) {
            StandardKingdomPermission.NEXUS_CHEST.sendDeniedMessage(this.player);
            return;
        }
        if (!this.kp.isAdmin() && this.player.getGameMode() == GameMode.CREATIVE && !KingdomsPluginPermission.GUIS_BYPASS_CREATIVE.hasPermission((CommandSender)this.player, false)) {
            KingdomsLang.GUIS_CREATIVE.sendError((CommandSender)this.player, new Object[0]);
            return;
        }
        if (!this.kp.isAdmin() && !this.kingdom.isMember(this.kp)) {
            KingdomsLang.NEXUS_CHEST_OTHERS.sendMessage((CommandSender)this.player);
            this.player.closeInventory();
            return;
        }
        XSound.BLOCK_CHEST_OPEN.play((Entity)this.player);
        Inventory nexusChest = this.kingdom.getNexusChest();
        if (!this.kp.isAdmin()) {
            KingdomVaultManager.asViewer(this.player);
        }
        this.player.openInventory(nexusChest);
    }

    public InventoryInteractiveGUI openRp(Consumer<InteractiveGUI> modifier) {
        return this.openRp(modifier, false);
    }

    InventoryInteractiveGUI openRp(Consumer<InteractiveGUI> modifier, boolean refreshing) {
        Kingdom kingdom;
        InventoryInteractiveGUI rp;
        MessageBuilder edits = new MessageBuilder().withContext(this.player);
        if (!refreshing) {
            edits.raw("total_worth", 0);
            rp = (InventoryInteractiveGUI)new GUIBuilder(this.group instanceof Kingdom ? KingdomsGUI.STRUCTURES_NEXUS_RESOURCE$POINTS$CONVERTER : KingdomsGUI.STRUCTURES_NEXUS_NATION_RESOURCE$POINTS$CONVERTER).forPlayer(this.player).withSettings(edits).inventoryGUIOnly().build();
        } else {
            rp = (InventoryInteractiveGUI)InteractiveGUIManager.getGuis().get(this.player.getEntityId());
            rp.resetOptions();
            List<ItemStack> stackedX = XItemStack.stack(rp.getInteractableItems());
            long totalWorth = ResourcePointManager.convertToResourcePoints(stackedX, null).getKey();
            rp.setSettings(edits.raw("total_worth", totalWorth));
        }
        if (rp == null) {
            return null;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
        rp.onDelayedInteractableSlot(event -> this.openRp(modifier, true));
        AtomicBoolean refresh = new AtomicBoolean(false);
        rp.push("apply", () -> {
            List<ItemStack> leftOvers;
            List<ItemStack> stacked = XItemStack.stack(rp.getInteractableItems());
            Pair<Long, List<ItemStack>> result = ResourcePointManager.convertToResourcePoints(stacked, null);
            long added = result.getKey();
            GroupResourcePointConvertEvent event = kp.donate(this.group, added, stacked, leftOvers = result.getValue());
            if (!event.isCancelled()) {
                added = event.getAmount();
                leftOvers = event.getLeftOvers();
                this.group.addResourcePoints(added);
                if (leftOvers != null) {
                    XItemStack.giveOrDrop(this.player, true, leftOvers.toArray(new ItemStack[0]));
                }
                KingdomsLang.NEXUS_RESOURCE_POINTS.sendMessage((CommandSender)this.player, "amount", StringUtils.toFancyNumber(added));
            }
            refresh.set(true);
            this.openRp(modifier);
        }, new Object[0]);
        Kingdom kingdom2 = kingdom = this.group instanceof Kingdom ? (Kingdom)this.group : null;
        if (kingdom != null) {
            rp.push("deposit", () -> {
                if (ServiceHandler.bankServiceNotAvailable((CommandSender)this.player)) {
                    return;
                }
                rp.returnItems();
                rp.clearReturnableItems();
                KingdomsLang.NEXUS_RESOURCE_POINTS_ENTER_VALUE.sendMessage((CommandSender)this.player);
                rp.startConversation("deposit", true);
            }, input -> {
                long amount;
                try {
                    amount = Long.parseLong(input);
                }
                catch (NumberFormatException ignored) {
                    KingdomsLang.INVALID_NUMBER.sendError((CommandSender)this.player, new MessageBuilder().raws("needed", "rp", "arg", input).withContext(this.player));
                    return;
                }
                if (amount == 0L) {
                    KingdomsLang.COMMAND_RESOURCEPOINTS_ZERO.sendError((CommandSender)this.player, new Object[0]);
                    return;
                }
                if (amount < 0L) {
                    KingdomsLang.COMMAND_RESOURCEPOINTS_NEGATIVE.sendError((CommandSender)this.player, new Object[0]);
                    return;
                }
                if (CommandResourcePointsDeposit.handleDeposit(kp, this.player, kingdom, amount)) {
                    rp.endConversation();
                    this.openRp(modifier);
                }
            }, new Object[0]).push("withdraw", () -> {
                if (ServiceHandler.bankServiceNotAvailable((CommandSender)this.player)) {
                    return;
                }
                rp.returnItems();
                rp.clearReturnableItems();
                KingdomsLang.NEXUS_RESOURCE_POINTS_ENTER_VALUE.sendMessage((CommandSender)this.player);
                rp.startConversation("withdraw", true);
            }, input -> {
                long amount;
                try {
                    amount = Long.parseLong(input);
                }
                catch (NumberFormatException ignored) {
                    KingdomsLang.INVALID_NUMBER.sendError((CommandSender)this.player, new MessageBuilder().raws("needed", "rp", "arg", input).withContext(this.player));
                    return;
                }
                if (amount == 0L) {
                    KingdomsLang.COMMAND_RESOURCEPOINTS_ZERO.sendError((CommandSender)this.player, new Object[0]);
                    return;
                }
                if (amount < 0L) {
                    KingdomsLang.COMMAND_RESOURCEPOINTS_NEGATIVE.sendError((CommandSender)this.player, new Object[0]);
                    return;
                }
                if (CommandResourcePointsWithdraw.handleWithdraw(kp, this.player, kingdom, amount)) {
                    rp.endConversation();
                    this.openRp(modifier);
                }
            }, new Object[0]);
        }
        rp.onClose(() -> {
            if (!refresh.get()) {
                rp.returnItems();
            }
        });
        modifier.accept(rp);
        if (!refreshing) {
            rp.open();
        } else {
            rp.setRemainingOptions();
        }
        return rp;
    }

    public InteractiveGUI openMiscUpgrades() {
        return this.openMiscUpgrades(false);
    }

    public InteractiveGUI openMiscUpgrades(boolean allowOpeningOthers) {
        if (!NexusManager.admin(this.player)) {
            if (!allowOpeningOthers && !this.kingdom.isMember(this.kp)) {
                KingdomsLang.NEXUS_MISC_UPGRADES_OTHERS.sendError((CommandSender)this.player, new Object[0]);
                this.player.closeInventory();
                return null;
            }
            if (!this.kp.hasPermission(StandardKingdomPermission.UPGRADE)) {
                StandardKingdomPermission.UPGRADE.sendDeniedMessage(this.player);
                this.player.closeInventory();
                return null;
            }
        }
        InteractiveGUI misc = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_MISC$UPGRADES);
        misc.push("back", this::openNexus, new Object[0]);
        for (MiscUpgrade upgrade : MiscUpgrade.values()) {
            Messenger name = upgrade.getDisplayName();
            int upgradeLevel = this.kingdom.getMiscUpgrades().getOrDefault(upgrade, 0);
            long cost = Math.abs(this.kingdom.getUpgradeCost(upgrade));
            int usedInvasions = MiscUpgradeManager.getInvasionCooldown().getOrDefault(this.kingdom.getId(), 0);
            int totalInvasions = (int)MiscUpgrade.INVASIONS.getScaling(this.kingdom);
            PlaceholderContextBuilder ctx = new PlaceholderContextBuilder().withContext(this.kingdom);
            Object[] edits = new Object[]{"name", name, "level", Math.abs(upgradeLevel), "cost", cost, "max-level", upgrade.getMaxLevel(ctx), "enabled", upgradeLevel >= 0, "maxxed", Math.abs(upgradeLevel) >= upgrade.getMaxLevel(ctx), "invasions", usedInvasions, "invasion-limit", totalInvasions, "max_turrets_per_land", TurretManager.getTotalTurretLimitPerLand(this.kingdom), "invasion-refresh-cooldown", TimeFormatter.of(MiscUpgradeManager.getInvadeRefreshCd(this.kingdom))};
            String option = StringUtils.configOption(upgrade);
            misc.option(option).setEdits(edits).on(ClickType.LEFT, () -> {
                int lvl = this.kingdom.getMiscUpgrades().getOrDefault(upgrade, 0);
                if (lvl < 0) {
                    KingdomMiscUpgradeToggleEvent event = new KingdomMiscUpgradeToggleEvent(this.kingdom, upgrade, this.kp, true);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    KingdomsLang.UPGRADES_MISC_ENABLED.sendMessage((CommandSender)this.player, "upgrade", name, "level", lvl + 1, "cost", cost);
                    this.kingdom.getMiscUpgrades().put(upgrade, -lvl);
                    this.openMiscUpgrades();
                    return;
                }
                if (lvl >= upgrade.getMaxLevel(ctx)) {
                    KingdomsLang.UPGRADES_MISC_MAX.sendError((CommandSender)this.player, "upgrade", name);
                    return;
                }
                if (!this.kp.isAdmin() && !this.kingdom.hasResourcePoints(cost)) {
                    KingdomsLang.UPGRADES_MISC_NOT_ENOUGH_RESOURCEPOINTS.sendError((CommandSender)this.player, "upgrade", name, "level", lvl + 1, "cost", cost);
                    return;
                }
                KingdomMiscUpgradeUpgradeEvent event = new KingdomMiscUpgradeUpgradeEvent(this.kingdom, upgrade, this.kp, lvl, lvl + 1, cost);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                if (!this.kp.isAdmin()) {
                    this.kingdom.addResourcePoints(-cost);
                }
                int newLevel = event.getNewLevel();
                this.kingdom.setUpgradeLevel(upgrade, newLevel);
                KingdomsLang.UPGRADES_MISC_UPGRADE.sendMessage((CommandSender)this.player, "upgrade", name, "level", lvl, "new_level", newLevel, "cost", cost);
                if (upgrade == MiscUpgrade.CHEST_SIZE) {
                    this.kingdom.updateChest();
                }
                this.openMiscUpgrades();
            }).on(ClickType.RIGHT, () -> {
                int lvl = this.kingdom.getMiscUpgrades().getOrDefault(upgrade, 0);
                if (!upgrade.canBeDisabled()) {
                    KingdomsLang.UPGRADES_MISC_CANNOT_BE_DISABLED.sendMessage((CommandSender)this.player, "upgrade", upgrade.toString(), "level", 0, "cost", cost);
                    return;
                }
                if (lvl == 0) {
                    KingdomsLang.UPGRADES_MISC_NOT_UPGRADED.sendMessage((CommandSender)this.player, "upgrade", name, "level", 0, "cost", cost);
                    return;
                }
                boolean enabled = lvl < 0;
                KingdomMiscUpgradeToggleEvent event = new KingdomMiscUpgradeToggleEvent(this.kingdom, upgrade, this.kp, enabled);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                (enabled ? KingdomsLang.UPGRADES_MISC_ENABLED : KingdomsLang.UPGRADES_MISC_DISABLED).sendMessage((CommandSender)this.player, "upgrade", name, "level", lvl + 1, "cost", cost);
                this.kingdom.getMiscUpgrades().put(upgrade, -lvl);
                this.openMiscUpgrades();
            }).done();
        }
        misc.open();
        return misc;
    }

    public InteractiveGUI openChampionUpgrades() {
        if (!NexusManager.admin(this.player) && !this.kp.hasPermission(StandardKingdomPermission.UPGRADE)) {
            StandardKingdomPermission.UPGRADE.sendDeniedMessage(this.player);
            return null;
        }
        InteractiveGUI champion = GUIAccessor.prepare(this.player, this.kp.getOfflinePlayer(), "structures/nexus/champion-upgrades", new Object[0]);
        if (champion == null) {
            return null;
        }
        champion.push("back", this::openNexus, new Object[0]);
        for (ChampionUpgrade upgrade : ChampionUpgrade.values()) {
            if (upgrade == ChampionUpgrade.EQUIPMENT) continue;
            LanguageEntryMessenger name = upgrade.getDisplayName();
            int lvl = this.kingdom.getUpgradeLevel(upgrade);
            long cost = this.kingdom.getUpgradeCost(upgrade);
            String scaling = StringUtils.toFancyNumber(upgrade.getScaling(this.kingdom));
            String option = StringUtils.configOption(upgrade);
            MessageBuilder settings = new MessageBuilder().viewer(this.kp).withContext(this.kingdom).raws("upgrade", name, "name", name, "level", lvl, "lvl", lvl, "cost", cost, "scaling", scaling);
            settings.raw("max_level", upgrade.getMaxLevel(settings));
            Long cooldown = upgrade.getOption("cooldown").getTime(settings);
            if (cooldown != null) {
                settings.raw("cooldown", TimeFormatter.of(cooldown));
            }
            champion.option(option).setSettings(settings).onNormalClicks(ctx -> {
                if (this.kingdom.getUpgradeLevel(upgrade) >= upgrade.getMaxLevel(null)) {
                    ctx.sendError(KingdomsLang.UPGRADES_CHAMPION_MAX, new Object[0]);
                    return;
                }
                if (!this.kp.isAdmin() && !this.kingdom.hasResourcePoints(cost)) {
                    ctx.sendError(KingdomsLang.UPGRADES_CHAMPION_NOT_ENOUGH_RESOURCEPOINTS, new Object[0]);
                    return;
                }
                KingdomChampionUpgradeUpgradeEvent event = new KingdomChampionUpgradeUpgradeEvent(this.kingdom, upgrade, this.kp, lvl, lvl + 1, cost);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                int newLevel = event.getNewLevel();
                if (!this.kp.isAdmin()) {
                    this.kingdom.addResourcePoints(-cost);
                }
                this.kingdom.setUpgradeLevel(upgrade, newLevel);
                ctx.getSettings().raw("new_level", event.getNewLevel());
                ctx.sendMessage(KingdomsLang.UPGRADES_CHAMPION_UPGRADE, new Object[0]);
                this.openChampionUpgrades();
            }).done();
        }
        champion.push("settings", this::openChampionSettings, new Object[0]);
        champion.open();
        return null;
    }

    public InteractiveGUI openRanks() {
        if (!NexusManager.admin(this.player) && !(!this.isNation ? this.kp.hasPermission(StandardKingdomPermission.EDIT_RANKS) : this.kp.hasNationPermission(StandardKingdomPermission.EDIT_RANKS))) {
            StandardKingdomPermission.EDIT_RANKS.sendDeniedMessage(this.player);
            return null;
        }
        if (!this.kp.isAdmin() && !this.kingdom.isMember(this.kp)) {
            KingdomsLang.NEXUS_RANK_EDITOR_OTHER.sendMessage((CommandSender)this.player);
            this.player.closeInventory();
            return null;
        }
        RankEditor.openRanks(KingdomsGUI.STRUCTURES_NEXUS_RANKS_RANKS, this.player, this.kp, this.kingdom, gui -> gui.push("back", this::openNexus, new Object[0]));
        return null;
    }

    public InteractiveGUI openChampionSettings() {
        InteractiveGUI champion = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_CHAMPION$SETTINGS);
        if (champion == null) {
            return null;
        }
        champion.push("back", this::openChampionUpgrades, new Object[0]);
        ConfigAccessor championConfig = this.kingdom.findChampionSection();
        String name = championConfig.getString("name");
        int maxLevel = championConfig.getInt("max-level");
        ChampionUpgrade upgrade = ChampionUpgrade.EQUIPMENT;
        int lvl = this.kingdom.getUpgradeLevel(upgrade);
        long cost = (long)MathUtils.eval(championConfig.getString("cost"), this.kingdom, "lvl", lvl);
        champion.push("change", this::openChampionTypes, new Object[0]).push("upgrade", () -> {
            ConfigSection sounds = champion.getOptionsSection().getSection("upgrade", "sounds");
            if (this.kingdom.getUpgradeLevel(upgrade) >= maxLevel) {
                KingdomsLang.UPGRADES_CHAMPION_MAX.sendMessage((CommandSender)this.player, "upgrade", name, "level", lvl + 1, "cost", cost);
                if (sounds != null) {
                    XSound.play(this.player, sounds.getString("max-level"));
                }
                return;
            }
            if (!this.kingdom.hasResourcePoints(cost)) {
                KingdomsLang.UPGRADES_CHAMPION_NOT_ENOUGH_RESOURCEPOINTS.sendMessage((CommandSender)this.player, "upgrade", name, "level", lvl + 1, "cost", cost);
                if (sounds != null) {
                    XSound.play(this.player, sounds.getString("not-enough-resource-points"));
                }
            }
            KingdomChampionUpgradeUpgradeEvent event = new KingdomChampionUpgradeUpgradeEvent(this.kingdom, upgrade, this.kp, lvl, lvl + 1, cost);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            long finalCost = event.getResourcePointsCost();
            int newLevel = event.getNewLevel();
            if (this.kingdom.hasResourcePoints(finalCost)) {
                this.kingdom.setUpgradeLevel(upgrade, newLevel);
                this.kingdom.addResourcePoints(-finalCost);
                if (sounds != null) {
                    XSound.play(this.player, sounds.getString("upgraded"));
                }
                KingdomsLang.UPGRADES_CHAMPION_UPGRADE.sendMessage((CommandSender)this.player, "upgrade", name, "new_level", newLevel, "cost", finalCost);
                this.openChampionSettings();
            } else {
                KingdomsLang.UPGRADES_CHAMPION_NOT_ENOUGH_RESOURCEPOINTS.sendMessage((CommandSender)this.player, "upgrade", name, "level", newLevel, "cost", finalCost);
                if (sounds != null) {
                    XSound.play(this.player, sounds.getString("not-enough-resource-points"));
                }
            }
        }, "level", lvl, "cost", cost);
        champion.open();
        return champion;
    }

    public void openChampionTypes() {
        InteractiveGUI gui = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_CHAMPIONS);
        if (gui == null) {
            return;
        }
        gui.push("back", this::openNexus, new Object[0]);
        ConfigAccessorConfigurationSection config = KingdomsConfig.CHAMPION_UPGRADES.accessor().gotoSection("champions").toBukkitConfigurationSection();
        for (String champion : config.getKeys(false)) {
            if (champion.equalsIgnoreCase("default")) continue;
            gui.push(champion, () -> {
                if (this.kingdom.getChampionType().equals(champion)) {
                    KingdomsLang.CHAMPION_TYPE_ALREADY_IN_USE.sendMessage((CommandSender)this.player, "champion", champion);
                    this.player.closeInventory();
                } else {
                    ChampionChangeEvent champChange = new ChampionChangeEvent(this.kingdom, this.kingdom.getChampionType(), champion, this.kp);
                    Bukkit.getPluginManager().callEvent((Event)champChange);
                    if (champChange.isCancelled()) {
                        return;
                    }
                    String newChamp = champChange.getNewType();
                    for (Player member : this.kingdom.getOnlineMembers()) {
                        KingdomsLang.CHAMPION_TYPE_CHANGED.sendMessage((CommandSender)member, "old_champion", this.kingdom.getChampionType(), "new_champion", newChamp);
                    }
                    this.kingdom.setChampionType(newChamp);
                    this.openChampionSettings();
                }
            }, new Object[0]);
        }
        gui.open();
    }

    public InteractiveGUI openSettings() {
        long left;
        if (this.kingdom != null && this.kingdom.isBeingInvaded()) {
            KingdomsLang.GUIS_CANT_OPEN_DURING_INVASION.sendError((CommandSender)this.player, new Object[0]);
            return null;
        }
        Long pacifismCd = KingdomsConfig.Invasions.PACIFISM_COOLDOWN.getManager().getTimeMillis(TimeUnit.HOURS);
        if (pacifismCd <= 0L) {
            pacifismCd = null;
        }
        long diff = this.kingdom == null ? 0L : (this.kingdom.getLastInvasion() == 0L ? 0L : System.currentTimeMillis() - this.kingdom.getLastInvasion());
        long l = left = diff == 0L || pacifismCd == null ? 0L : pacifismCd - diff;
        if (left < 0L) {
            left = 0L;
        }
        long finalLeft = left;
        MessageObjectBuilder leftStr = TimeFormatter.of(left);
        KingdomsGUI guiPath = this.group instanceof Nation ? KingdomsGUI.STRUCTURES_NEXUS_NATION_SETTINGS_SETTINGS : KingdomsGUI.STRUCTURES_NEXUS_SETTINGS_SETTINGS;
        InteractiveGUI gui = GUIAccessor.prepare(this.player, guiPath, this.settings.clone().inheritPlaceholders(new PlaceholderContextBuilder().placeholders("pacifism", this.kingdom == null ? null : (this.kingdom.isPacifist() ? "&aEnabled" : "&cDisabled"), "invites", this.group.requiresInvite() ? "&aEnabled" : "&cDisabled", "tax_equation", this.group.getTaxOrDefault(), "pacifism_cooldown", leftStr, "pacifism_left", left, "public_home", this.group.isHomePublic())));
        if (gui == null) {
            return null;
        }
        boolean hasSettingsPermission = NexusManager.admin(this.player) || (this.isNation ? this.kp.hasNationPermission(StandardKingdomPermission.SETTINGS) : this.kp.hasPermission(StandardKingdomPermission.SETTINGS));
        Color kColor = this.group.getColor();
        if (kColor == null) {
            kColor = Color.BLACK;
        }
        Object[] colorEdits = new Object[]{"r", kColor.getRed(), "b", kColor.getBlue(), "g", kColor.getGreen()};
        gui.push("back", () -> {
            if (this.group instanceof Nation) {
                this.nationalNexus();
            } else {
                this.openNexus();
            }
        }, new Object[0]);
        Long finalPacifismCd = pacifismCd;
        gui.push("pacifism", () -> {
            if (!NexusManager.admin(this.player) && !hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.player);
                return;
            }
            if (finalPacifismCd == null) {
                KingdomsLang.NEXUS_PACIFISM_PERMANENT.sendMessage((CommandSender)this.player);
                return;
            }
            if (finalLeft > 0L) {
                KingdomsLang.NEXUS_PACIFISM_COOLDOWN.sendMessage((CommandSender)this.player, "cooldown", leftStr);
                return;
            }
            KingdomPacifismStateChangeEvent event = new KingdomPacifismStateChangeEvent(this.kingdom, !this.kingdom.isPacifist(), this.kp);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            this.kingdom.setPacifist(!this.kingdom.isPacifist());
            KingdomsLang lang = this.kingdom.isPacifist() ? KingdomsLang.NEXUS_PACIFISM_ENABLE : KingdomsLang.NEXUS_PACIFISM_DISABLE;
            lang.sendMessage((CommandSender)this.player);
            this.openSettings();
        }, new Object[0]).push("public-home", () -> {
            if (!NexusManager.admin(this.player) && !hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.player);
                return;
            }
            this.group.setPublicHome(!this.group.isHomePublic());
            KingdomsLang lang = this.group.isHomePublic() ? KingdomsLang.NEXUS_HOME_PUBLIC : KingdomsLang.NEXUS_HOME_NOT_PUBLIC;
            lang.sendMessage((CommandSender)this.player);
            this.openSettings();
        }, new Object[0]).push("hidden", () -> {
            if (!NexusManager.admin(this.player) && !hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.player);
                return;
            }
            if (this.group.setHidden(!this.group.isHidden(), this.kp).isCancelled()) {
                return;
            }
            KingdomsLang lang = this.group.isHidden() ? KingdomsLang.NEXUS_HIDDEN_ENABLED : KingdomsLang.NEXUS_HIDDEN_DISABLED;
            lang.sendMessage((CommandSender)this.player);
            this.openSettings();
        }, new Object[0]).push("invites", () -> {
            if (!NexusManager.admin(this.player) && !hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.player);
                return;
            }
            this.group.setRequiresInvite(!this.group.requiresInvite());
            KingdomsLang lang = this.group.requiresInvite() ? KingdomsLang.NEXUS_INVITES_ENABLE : KingdomsLang.NEXUS_INVITES_DISABLE;
            lang.sendMessage((CommandSender)this.player);
            this.openSettings();
        }, new Object[0]).push("relations", () -> this.openRelations(innerGUI -> innerGUI.push("back", this::openSettings, new Object[0])), new Object[0]).push("tax", () -> {
            if (ServiceHandler.bankServiceNotAvailable((CommandSender)this.player)) {
                return;
            }
            if (!NexusManager.admin(this.player) && !hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.player);
                return;
            }
            KingdomsLang.NEXUS_SETTINGS_TAX_ENTER_VALUE.sendMessage((CommandSender)this.player);
            gui.startConversation("tax");
        }, tax -> {
            double amount;
            double money = ServiceVault.getMoney((OfflinePlayer)this.player);
            int illegalIndex = StringUtils.indexOfAny(tax, new String[]{"kingdoms_tax", "kingdoms_fancy_tax", "kingdoms_short_tax"});
            if (illegalIndex != -1) {
                KingdomsLang.NEXUS_SETTINGS_TAX_ILLEGAL_VARIABLE.sendMessage((CommandSender)this.player, "tax", tax, "index", illegalIndex);
                return;
            }
            try {
                amount = MathUtils.eval(tax, (OfflinePlayer)this.player, "money", money);
            }
            catch (Exception ex) {
                KingdomsLang.NEXUS_SETTINGS_TAX_INVALID.sendMessage((CommandSender)this.player, "tax", tax, "reason", ex.getMessage());
                return;
            }
            KingdomsLang.NEXUS_SETTINGS_TAX_SET.sendMessage((CommandSender)this.player, "tax", tax, "test", amount);
            this.group.setTax((String)tax);
            gui.endConversation();
            this.openSettings();
        }, new Object[0]).push("flag", () -> {
            long flagCd;
            if (!NexusManager.admin(this.player) && !hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.player);
                return;
            }
            if (!this.kp.isAdmin() && (flagCd = KINGDOM_FLAG_COOLDOWN.getTimeLeft(this.group.getId())) != 0L) {
                KingdomsLang.NEXUS_SETTINGS_FLAG_COOLDOWN.sendMessage((CommandSender)this.player, "cooldown", TimeFormatter.of(flagCd));
                return;
            }
            KingdomsLang.NEXUS_SETTINGS_FLAG_ENTER_VALUE.sendMessage((CommandSender)this.player);
            if (this.group.getFlag() != null) {
                KingdomsLang.NEXUS_SETTINGS_FLAG_CURRENT.sendMessage((CommandSender)this.player);
            }
            gui.startConversation("flag");
        }, flag -> Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            if (flag.equalsIgnoreCase("remove")) {
                KingdomsLang.NEXUS_SETTINGS_FLAG_REMOVED.sendMessage((CommandSender)this.player);
                this.group.setFlag(null, this.kp);
                gui.endConversation();
                this.openSettings();
                return;
            }
            URL url = StringUtils.validateURL(flag);
            if (url == null) {
                KingdomsLang.NEXUS_SETTINGS_FLAG_WRONG_URL.sendMessage((CommandSender)this.player, "flag", flag);
                return;
            }
            if (!this.kp.isAdmin()) {
                boolean blacklist = KingdomsConfig.FLAG_LINKS_BLACKLIST.getManager().getBoolean();
                List<String> contains = KingdomsConfig.FLAG_LINKS_CONTAINS.getManager().getStringList();
                for (String contain : contains) {
                    boolean matches = flag.contains(contain);
                    if (blacklist != matches) continue;
                    KingdomsLang.NEXUS_SETTINGS_FLAG_CONTAINS.sendMessage((CommandSender)this.player, "flag", flag);
                    return;
                }
                List<String> regexs = KingdomsConfig.FLAG_LINKS_REGEX.getManager().getStringList();
                for (String regex : regexs) {
                    boolean matches = Pattern.compile(regex).matcher((CharSequence)flag).find();
                    if (blacklist != matches) continue;
                    KingdomsLang.NEXUS_SETTINGS_FLAG_REGEX.sendMessage((CommandSender)this.player, "flag", flag);
                    return;
                }
            }
            KingdomsLang.NEXUS_SETTINGS_FLAG_VALIDATE.sendMessage((CommandSender)this.player);
            int height = KingdomsConfig.FLAG_SIZE_LIMIT_HEIGHT.getManager().getInt();
            int width = KingdomsConfig.FLAG_SIZE_LIMIT_WIDTH.getManager().getInt();
            if (height > 0 || width > 0) {
                Dimension dim = StringUtils.getImageSize(url);
                if (dim == null) {
                    KingdomsLang.NEXUS_SETTINGS_FLAG_SIZE_LIMIT_FAIL.sendMessage((CommandSender)this.player, "flag", flag);
                    return;
                }
                if (!this.kp.isAdmin()) {
                    if (dim.getHeight() > (double)height) {
                        KingdomsLang.NEXUS_SETTINGS_FLAG_SIZE_LIMIT_HEIGHT.sendMessage((CommandSender)this.player, "flag", flag, "limit", height, "height", dim.getHeight());
                        return;
                    }
                    if (dim.getWidth() > (double)width) {
                        KingdomsLang.NEXUS_SETTINGS_FLAG_SIZE_LIMIT_HEIGHT.sendMessage((CommandSender)this.player, "flag", flag, "limit", width, "height", dim.getWidth());
                        return;
                    }
                }
            }
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> {
                String finalFlag = flag;
                GroupFlagChangeEvent event = this.group.setFlag(finalFlag, this.kp);
                if (event.isCancelled()) {
                    return;
                }
                finalFlag = event.getNewFlag();
                KINGDOM_FLAG_COOLDOWN.add(this.group.getId(), KingdomsConfig.FLAG_COOLDOWN.getManager().getTimeMillis());
                KingdomsLang.NEXUS_SETTINGS_FLAG_SET.sendMessage((CommandSender)this.player, "flag", finalFlag);
                gui.endConversation();
                this.openSettings();
            });
        }), new Object[0]).push("color", () -> {
            if (!NexusManager.admin(this.player) && !hasSettingsPermission) {
                StandardKingdomPermission.SETTINGS.sendDeniedMessage(this.player);
                return;
            }
            CommandColor.getColorPicker(this.player, this.group, innerGUI -> innerGUI.push("back", this::openSettings, new Object[0]));
        }, colorEdits).push("shields", () -> {
            if (!NexusManager.admin(this.player) && !(!this.isNation ? this.kp.hasPermission(StandardKingdomPermission.UPGRADE) : this.kp.hasNationPermission(StandardKingdomPermission.UPGRADE))) {
                StandardKingdomPermission.UPGRADE.sendDeniedMessage(this.player);
                return;
            }
            InteractiveGUI shields = GUIAccessor.prepare(this.player, this.kp.getOfflinePlayer(), "structures/nexus/" + (this.group instanceof Nation ? "nation/" : "") + "settings/shields", new Object[0]);
            for (String holder : shields.getRemainingOptions("shield")) {
                ConfigSection shield = shields.getOptionsSection().getSection(holder);
                long cost = (long)MathUtils.eval(shield.getMathExpression("cost"), (PlaceholderContextProvider)gui.getSettings());
                Long time = TimeUtils.parseTime(shield.getString("time"), TimeUnit.HOURS);
                if (time == null) continue;
                shields.option(holder).setEdits("cost", StringUtils.toFancyNumber(cost)).onNormalClicks(() -> {
                    if (!this.group.hasResourcePoints(cost)) {
                        KingdomsLang.NEXUS_SETTINGS_SHIELD_NOT_ENOUGH_RESOURCE_POINTS.sendMessage((CommandSender)this.player);
                        return;
                    }
                    if (this.kingdom != null) {
                        long passedSinceTheHit;
                        long passedSinceTheInvade;
                        long passedSinceTheLastInvasion;
                        long cooldown = KingdomsConfig.Invasions.SHIELDS_PURCHASE_COOLDOWN_LAST_INVASION_ATTACKED.getManager().getTimeMillis();
                        if (cooldown > 0L && (passedSinceTheLastInvasion = System.currentTimeMillis() - this.kingdom.getLastInvasion()) < cooldown) {
                            KingdomsLang.NEXUS_SETTINGS_SHIELD_COOLDOWN_INVASIONS_ATTACKED.sendError((CommandSender)this.player, "time", TimeFormatter.of(cooldown - passedSinceTheLastInvasion), "last", TimeFormatter.of(passedSinceTheLastInvasion));
                            return;
                        }
                        Long wasInvaded = this.kingdom.getNewestLog(LogKingdomInvaded.class, x -> x.getResult().isSuccessful() ? Long.valueOf(x.getTime()) : null);
                        long invadeCooldown = KingdomsConfig.Invasions.SHIELDS_PURCHASE_COOLDOWN_LAST_INVASION_DEFENDED.getManager().getTimeMillis();
                        if (wasInvaded != null && invadeCooldown > 0L && (passedSinceTheInvade = System.currentTimeMillis() - wasInvaded) < invadeCooldown) {
                            KingdomsLang.NEXUS_SETTINGS_SHIELD_COOLDOWN_INVASIONS_DEFENDED.sendError((CommandSender)this.player, "time", TimeFormatter.of(invadeCooldown - passedSinceTheInvade), "last", TimeFormatter.of(passedSinceTheInvade));
                            return;
                        }
                        long siegeHitCd = KingdomsConfig.Invasions.SHIELDS_PURCHASE_COOLDOWN_LAST_SIEGE_CANNON_HIT.getManager().getTimeMillis();
                        long lastSiegeHit = SiegeManager.SIEGE_LAST_ATTACK.getTimeLeft(this.kingdom.getId());
                        if (siegeHitCd > 0L && lastSiegeHit > 0L && (passedSinceTheHit = System.currentTimeMillis() - lastSiegeHit) < siegeHitCd) {
                            KingdomsLang.NEXUS_SETTINGS_SHIELD_COOLDOWN_SIEGE_CANNON.sendError((CommandSender)this.player, "time", TimeFormatter.of(siegeHitCd - passedSinceTheHit), "last", TimeFormatter.of(passedSinceTheHit));
                            return;
                        }
                    }
                    GroupShieldPurchaseEvent event = new GroupShieldPurchaseEvent(this.group, this.kp, time, cost);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.group.addResourcePoints(-event.getResourcePointsCost());
                    this.group.activateShield(event.getShieldDuration());
                    KingdomsLang.NEXUS_SETTINGS_SHIELD_ACTIVATED.sendMessage((CommandSender)this.player);
                }).done();
            }
            shields.option("back").onNormalClicks(this::openSettings).done();
            shields.open();
        }, new Object[0]);
        gui.open();
        return gui;
    }

    public InteractiveGUI openRelations(Consumer<InteractiveGUI> editor) {
        if (!NexusManager.admin(this.player) && !this.kp.hasPermission(StandardKingdomPermission.RELATION_ATTRIBUTES)) {
            StandardKingdomPermission.RELATION_ATTRIBUTES.sendDeniedMessage(this.player);
            return null;
        }
        InteractiveGUI gui = GUIAccessor.prepare(this.player, this.kp.getOfflinePlayer(), "structures/nexus/settings/relations", new Object[0]);
        if (gui == null) {
            return null;
        }
        for (KingdomRelation relation : KingdomRelation.values()) {
            String holder = relation.name().toLowerCase(Locale.ENGLISH);
            gui.push(holder, () -> this.openRelationEditor(relation, editor), new Object[0]);
        }
        editor.accept(gui);
        gui.open();
        return gui;
    }

    public InteractiveGUI nationalNexus() {
        if (!NexusManager.admin(this.player) && !this.kp.hasNationPermission(StandardKingdomPermission.NEXUS)) {
            StandardKingdomPermission.NEXUS.sendDeniedMessage(this.player);
            return null;
        }
        InteractiveGUI gui = this.prepare(KingdomsGUI.STRUCTURES_NEXUS_NATION_NEXUS);
        if (gui == null) {
            return null;
        }
        gui.push("settings", this::openSettings, new Object[0]).push("ranks", () -> {
            if (!StructureManager.hasPermission(this.player, StandardKingdomPermission.EDIT_RANKS)) {
                StandardKingdomPermission.EDIT_RANKS.sendDeniedMessage(this.player);
                return;
            }
            RankEditor.openRanks(KingdomsGUI.STRUCTURES_NEXUS_NATION_RANKS_RANKS, this.player, this.kp, this.group, innerGUI -> innerGUI.push("back", this::nationalNexus, new Object[0]));
        }, new Object[0]).push("resource-points", () -> this.openRp(rp -> rp.push("back", () -> {
            ((InventoryInteractiveGUI)rp).returnItems();
            this.nationalNexus();
        }, new Object[0])), new Object[0]);
        gui.open();
        return gui;
    }

    public void openRelationEditor(KingdomRelation relation, Consumer<InteractiveGUI> relationsEditor) {
        String guiPath = this.group instanceof Nation ? "structures/nexus/nation/settings/relation-editor" : "structures/nexus/settings/relation-editor";
        InteractiveGUI gui = GUIAccessor.prepare(this.player, this.kp.getOfflinePlayer(), guiPath, new Object[0]);
        if (gui == null) {
            return;
        }
        Set<RelationAttribute> attributesOpt = this.group.getAttributes().get((Object)relation);
        if (attributesOpt == null) {
            attributesOpt = new OrderedSet<RelationAttribute>(10);
        }
        gui.push("back", () -> this.openRelations(relationsEditor), new Object[0]);
        Set<RelationAttribute> attributes = attributesOpt;
        for (RelationAttribute attribute : Kingdoms.get().getRelationAttributeRegistry().getRegistry().values()) {
            boolean enabled = attributes.contains(attribute);
            gui.push(attribute.getNamespace().getConfigOptionName(), () -> {
                if (enabled) {
                    attributes.remove(attribute);
                } else {
                    attributes.add(attribute);
                }
                if (!attributes.isEmpty()) {
                    this.group.getAttributes().put(relation, attributes);
                }
                this.openRelationEditor(relation, relationsEditor);
            }, "enabled", enabled);
        }
        gui.open();
    }

    public InteractiveGUI openMembers(int page) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.STRUCTURES_NEXUS_MEMBERS.getGUIPath(), this.settings.clone().raw("page", page + 1));
            gui.push("back", this::openNexus, new Object[0]);
            ReusableOptionHandler holder = Objects.requireNonNull(gui.getReusableOption("members"), "Missing 'members' option from members GUI");
            List<KingdomPlayer> members = this.kingdom.getKingdomPlayers();
            int eachPage = holder.slotsCount();
            int maxPages = MathUtils.getPageNumbers(members.size(), eachPage);
            gui.getSettings().raw("pages", maxPages);
            gui.push("next-page", () -> {
                if (page + 1 >= maxPages) {
                    KingdomsLang.GUIS_PAGES_NEXT_PAGE_NOT_AVAILABLE.sendError((CommandSender)this.player, "pages", maxPages, "page", page + 1);
                    return;
                }
                this.openMembers(page + 1);
            }, new Object[0]);
            gui.push("previous-page", () -> {
                if (page == 0) {
                    KingdomsLang.GUIS_PAGES_PREVIOUS_PAGE_NOT_AVAILABLE.sendError((CommandSender)this.player, "pages", maxPages);
                    return;
                }
                this.openMembers(page - 1);
            }, new Object[0]);
            members.sort(KingdomPlayer::compareTo);
            for (KingdomPlayer member : (KingdomPlayer[])members.stream().skip((long)page * (long)eachPage).limit(eachPage).toArray(KingdomPlayer[]::new)) {
                OfflinePlayer memberPlayer = member.getOfflinePlayer();
                if (NexusManager.admin(this.player) || this.kp.hasPermission(StandardKingdomPermission.MANAGE_RANKS) || this.kp.hasPermission(StandardKingdomPermission.KICK)) {
                    holder.onNormalClicks(() -> this.openMember(member, memberGUI -> memberGUI.push("back", () -> this.openMembers(page), new Object[0])));
                }
                holder.pushHead(memberPlayer);
            }
            gui.open();
        });
        return null;
    }

    public InteractiveGUI openMember(KingdomPlayer member, Consumer<InteractiveGUI> handlers) {
        OfflinePlayer placeholder = member.getOfflinePlayer();
        KingdomPlayer viewerKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.player);
        Kingdom kingdom = member.getKingdom();
        if (!viewerKp.isAdmin() && !kingdom.isMember(viewerKp)) {
            KingdomsLang.NEXUS_MEMBERS_OTHERS.sendMessage((CommandSender)this.player);
            this.player.closeInventory();
            return null;
        }
        InteractiveGUI memberGUI = GUIAccessor.prepare(this.player, viewerKp.getOfflinePlayer(), KingdomsGUI.STRUCTURES_NEXUS_MEMBER.getGUIPath(), new Object[0]);
        ReusableOptionHandler memberHead = memberGUI.getReusableOption("member");
        memberHead.pushHead(placeholder);
        boolean hasHigherPriority = this.kp.isAdmin() || this.kp.getRank().isHigherThan(member.getRank());
        boolean canChangeRank = hasHigherPriority && this.kp.hasPermission(StandardKingdomPermission.MANAGE_RANKS);
        memberGUI.getSettings().raw("can_demote", canChangeRank).raw("can_promote", canChangeRank).raw("can_kick", hasHigherPriority && this.kp.hasPermission(StandardKingdomPermission.KICK));
        memberGUI.push("kick", () -> {
            CommandKick.kick(kingdom, this.player, placeholder, NexusManager.admin(this.player));
            this.player.closeInventory();
        }, new Object[0]).push("demote", () -> {
            if (!NexusManager.admin(this.player) && !viewerKp.hasPermission(StandardKingdomPermission.MANAGE_RANKS)) {
                StandardKingdomPermission.MANAGE_RANKS.sendDeniedMessage(this.player);
                return;
            }
            Rank rank = member.getRank();
            if (rank.isKing()) {
                KingdomsLang.COMMAND_DEMOTE_CANT_DEMOTE_KING.sendError((CommandSender)this.player, "demoted", placeholder.getName());
                return;
            }
            if (!NexusManager.admin(this.player) && !viewerKp.getRank().isHigherThan(rank)) {
                KingdomsLang.COMMAND_DEMOTE_CANT_DEMOTE.sendError((CommandSender)this.player, "demoted", placeholder.getName());
                return;
            }
            if (kingdom.getRanks().isMemberRank(rank)) {
                KingdomsLang.COMMAND_DEMOTE_MEMBER.sendError((CommandSender)this.player, new Object[0]);
                return;
            }
            @NonNull PlayerRankChangeEvent demoteEvent = member.demote(viewerKp);
            if (demoteEvent.isCancelled()) {
                return;
            }
            rank = demoteEvent.getRank();
            for (Player kingdomMembers : kingdom.getOnlineMembers()) {
                KingdomsLang.COMMAND_DEMOTE_DEMOTED.sendMessage((CommandSender)kingdomMembers, (OfflinePlayer)this.player, new Object[]{"rank", rank.getColor() + rank.getName(), "demoted", placeholder.getName()});
            }
            this.openMember(member, handlers);
        }, new Object[0]).push("promote", () -> {
            if (!NexusManager.admin(this.player) && !viewerKp.hasPermission(StandardKingdomPermission.MANAGE_RANKS)) {
                StandardKingdomPermission.MANAGE_RANKS.sendDeniedMessage(this.player);
                return;
            }
            if (CommandPromote.promote(viewerKp, member)) {
                this.openMember(member, handlers);
            }
        }, new Object[0]);
        handlers.accept(memberGUI);
        memberGUI.open();
        return memberGUI;
    }

    private /* synthetic */ void lambda$openStructures$34(Inventory inv, long cost, StructureStyle style) {
        ItemStack item;
        if (inv.firstEmpty() == -1) {
            KingdomsLang.NEXUS_STRUCTURE_INVENTORY_FULL.sendError((CommandSender)this.player, new Object[0]);
            return;
        }
        if (!this.kp.isAdmin()) {
            if (!this.kingdom.hasResourcePoints(cost)) {
                KingdomsLang.NEXUS_STRUCTURE_RESOURCEPOINTS.sendError((CommandSender)this.player, "cost", cost);
                return;
            }
            this.kingdom.addResourcePoints(-cost);
        }
        if ((item = style.buildItem(this.kingdom)) != null) {
            XItemStack.addItems((Inventory)this.player.getInventory(), false, item);
        }
        KingdomsLang.NEXUS_STRUCTURE_PURCHASED.sendMessage((CommandSender)this.player, "structure", style.getDisplayName(), "cost", cost);
        LogManager.handlePurchase(this.kingdom, new LogPurchaseStructure(cost, this.player.getUniqueId(), 1, style), collector -> new LogPurchaseStructure(collector.getResourcePointsCost(), this.player.getUniqueId(), collector.getAmount(), style));
    }

    private /* synthetic */ void lambda$openTurrets$32(Inventory inv, long cost, TurretStyle style) {
        ItemStack item;
        if (inv.firstEmpty() == -1) {
            KingdomsLang.NEXUS_TURRET_INVENTORY_FULL.sendMessage((CommandSender)this.player);
            this.player.closeInventory();
            return;
        }
        if (!this.kp.isAdmin()) {
            if (!this.kingdom.hasResourcePoints(cost)) {
                KingdomsLang.NEXUS_TURRET_RESOURCEPOINTS.sendError((CommandSender)this.player, "cost", cost);
                return;
            }
            this.kingdom.addResourcePoints(-cost);
        }
        if ((item = style.buildItem(this.kingdom)) != null) {
            inv.addItem(new ItemStack[]{item});
        }
        KingdomsLang.NEXUS_TURRET_PURCHASED.sendMessage((CommandSender)this.player, "turret", style.getDisplayName(), "cost", cost);
        LogManager.handlePurchase(this.kingdom, new LogPurchaseTurret(cost, this.player.getUniqueId(), 1, style), collector -> new LogPurchaseTurret(collector.getResourcePointsCost(), this.player.getUniqueId(), collector.getAmount(), style));
    }

    static {
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_NEXUS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openNexus());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_STRUCTURES, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openStructures());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_TURRETS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openTurrets());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_SETTINGS_SETTINGS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openSettings());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_SETTINGS_RELATIONS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openRelations(gui -> gui.push("back", () -> inf.senderAsPlayer().closeInventory(), new Object[0])));
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_MEMBERS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openMembers(0));
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_RANKS_RANKS, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openRanks());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_CHAMPION$UPGRADES, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openChampionUpgrades());
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_MISC$UPGRADES, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openMiscUpgrades());
        GUIConfig.registerIndependentGUI(KingdomsGUI.MAILS_MAILBOX, inf -> {
            InteractiveGUI mailbox = MailUserAgent.getMailbox(inf.senderAsPlayer(), inf.getKingdom(), mailboxGUI -> mailboxGUI.push("back", () -> inf.senderAsPlayer().closeInventory(), new Object[0]));
            if (mailbox == null) {
                return null;
            }
            mailbox.open();
            return mailbox;
        });
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_LOGS, inf -> {
            Player player = inf.senderAsPlayer();
            return new KingdomLogGUI(player, inf.getKingdom(), 0, logs -> {
                logs.push("back", () -> ((Player)player).closeInventory(), new Object[0]);
                logs.open();
            }).openGUI();
        });
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_RESOURCE$POINTS$CONVERTER, inf -> new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openRp(gui -> gui.push("back", () -> inf.senderAsPlayer().closeInventory(), new Object[0])));
        GUIConfig.registerIndependentGUI(KingdomsGUI.STRUCTURES_NEXUS_MEMBER, inf -> {
            KingdomPlayer member;
            if (inf.assertArgs(1)) {
                OfflinePlayer player = inf.getOfflinePlayer(0);
                if (player == null) {
                    return null;
                }
                member = KingdomPlayer.getKingdomPlayer(player);
                if (!inf.getKingdom().isMember(member)) {
                    inf.sendError(KingdomsLang.NOT_FOUND_IN_YOUR_KINGDOM, new Object[0]);
                    return null;
                }
            } else {
                member = inf.getKingdomPlayer();
            }
            return new NexusManager(inf.getKingdom(), inf.senderAsPlayer()).openMember(member, gui -> gui.push("back", () -> inf.senderAsPlayer().closeInventory(), new Object[0]));
        });
    }
}

