/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.structures;

import org.bukkit.Location;
import org.bukkit.entity.Animals;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;

public class RegulatorManager
implements Listener {
    private static final QuickEnumSet<CreatureSpawnEvent.SpawnReason> ACCEPTED_REASONS = new QuickEnumSet((Enum[])CreatureSpawnEvent.SpawnReason.values()).addAll((Enum[])new CreatureSpawnEvent.SpawnReason[]{CreatureSpawnEvent.SpawnReason.NATURAL, CreatureSpawnEvent.SpawnReason.LIGHTNING, CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK});

    @EventHandler(ignoreCancelled=true)
    public void onSpawn(CreatureSpawnEvent event) {
        Regulator.Rule rule;
        if (event.getEntityType() == EntityType.ARMOR_STAND) {
            return;
        }
        if (!ACCEPTED_REASONS.contains(event.getSpawnReason())) {
            return;
        }
        Location location = event.getLocation();
        Land land = Land.getLand(location);
        if (land == null || !land.isClaimed()) {
            return;
        }
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator == null) {
            return;
        }
        Regulator.Rule rule2 = rule = event.getEntity() instanceof Animals ? Regulator.Rule.DISABLE_ANIMAL_SPAWNING : Regulator.Rule.DISABLE_MOB_SPAWNING;
        if (regulator.hasRule(rule)) {
            event.setCancelled(true);
        }
    }
}

