/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.structures;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPermission;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.KingdomItemPlaceEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.ItemMatcher;
import org.kingdoms.managers.land.LandProtectionManager;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.nbt.NBTTagCompound;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class StructureManager {
    public static boolean hasPermission(Player player, KingdomPermission perm) {
        return KingdomsPluginPermission.STRUCTURES_INTERACT.hasPermission((CommandSender)player, false) || KingdomPlayer.getKingdomPlayer((OfflinePlayer)player).hasPermission(perm);
    }

    public static void onStructurePlace(PlayerInteractEvent event, NBTTagCompound nbt, String tag) {
        BlockData data;
        event.setCancelled(true);
        Block block = event.getClickedBlock().getRelative(event.getBlockFace());
        if (!XBlock.isAir(block.getType())) {
            KingdomsLang.STRUCTURES_BLOCK_OCCUPIED.sendError((CommandSender)event.getPlayer(), "material", KingdomsLang.translateMaterial(XMaterial.matchXMaterial(block.getType())));
            return;
        }
        Structure structure = StructureManager.structurePlace(KingdomItemPlaceEvent.fromInteractEvent(event, block), event.getPlayer(), block, nbt, tag);
        if (structure == null) {
            return;
        }
        if (XMaterial.supports(13) && (data = block.getBlockData()) instanceof Directional) {
            Directional dir = (Directional)data;
            BlockFace facing = event.getBlockFace();
            if (facing == BlockFace.UP || facing == BlockFace.DOWN) {
                facing = LocationUtils.getPlayerBlockFace(event.getPlayer());
            }
            if (facing != BlockFace.UP && facing != BlockFace.DOWN && facing != null) {
                dir.setFacing(facing);
                block.setBlockData(data, true);
            }
        }
        ItemStack item = event.getItem();
        item.setAmount(item.getAmount() - 1);
    }

    public static Structure structurePlace(BlockPlaceEvent event, Player player, Block block, NBTTagCompound nbt, String tag) {
        int totalSpecificCount;
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_STRUCTURES_USE.sendError((CommandSender)player, new Object[0]);
            return null;
        }
        if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
            StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
            return null;
        }
        Land land = SimpleChunkLocation.of(block).getLand();
        if (land == null || !land.isClaimed()) {
            KingdomsLang.UNCLAIMED_PLACE_STRUCTURES.sendError((CommandSender)player, new Object[0]);
            return null;
        }
        if (!(KingdomsPluginPermission.STRUCTURES_BUILD_PLACE.hasPermission((CommandSender)player, true) || land.getKingdomId().equals(kp.getKingdomId()) || land.getKingdom().hasAttribute(kp.getKingdom(), (RelationAttribute)StandardRelationAttribute.MANAGE_STRUCTURES))) {
            KingdomsLang.OTHER_KINGDOMS_STRUCTURE_PLACE.sendError((CommandSender)player, new Object[0]);
            return null;
        }
        int totalLimit = KingdomsConfig.Structures.TOTAL_LIMIT_PER_LAND.getManager().getInt();
        if (totalLimit > 0 && land.getStructures().size() >= totalLimit) {
            KingdomsLang.STRUCTURES_LIMIT.sendError((CommandSender)player, "limit", totalLimit);
            return null;
        }
        StructureStyle style = StructureRegistry.getStyle(tag);
        int structuresOfSameType = 0;
        for (Structure struct2 : land.getStructures().values()) {
            if (struct2.getStyle() != style) continue;
            ++structuresOfSameType;
        }
        int limitIndividualPerLand = style.getOption("limits", "per-land").getInt();
        if (limitIndividualPerLand > 0 && structuresOfSameType > 0 && structuresOfSameType >= limitIndividualPerLand) {
            KingdomsLang.STRUCTURES_SPECIFIC_LIMIT.sendError((CommandSender)player, "limit", limitIndividualPerLand, "style", style.getDisplayName());
            return null;
        }
        int totalSpecificLimit = style.getOption("limits", "total").getInt();
        if (totalSpecificLimit > 0 && (totalSpecificCount = land.getKingdom().countStructures(struct -> struct.getStyle() == style)) >= totalSpecificLimit) {
            KingdomsLang.STRUCTURES_SPECIFIC_TOTAL_LIMIT.sendError((CommandSender)player, "limit", totalSpecificCount, "style", style.getDisplayName());
            return null;
        }
        if (!kp.isAdmin() && !style.canBePlacedInBiome(block.getLocation())) {
            KingdomsLang.STRUCTURES_CANT_PLACE_IN_BIOME.sendError((CommandSender)player, new Object[0]);
            return null;
        }
        SimpleLocation location = SimpleLocation.of(block);
        KingdomItem structure = ((StructureType)style.getType()).build(new KingdomItemBuilder(style, location, kp));
        ((Structure)structure).setDataFromNBT(nbt);
        KingdomItemPlaceEvent<KingdomItem> placeEvent = new KingdomItemPlaceEvent<KingdomItem>(event, kp, land, structure);
        Bukkit.getPluginManager().callEvent(placeEvent);
        if (placeEvent.isCancelled()) {
            return null;
        }
        StructureManager.processStructureProperties(land, (Structure)structure, VersionSupport.getPlayerFacing(player).getOppositeFace());
        return structure;
    }

    public static List<Structure> breakExtraStructures(Kingdom kingdom, Land land) {
        List<Structure> extra = StructureManager.getExtraStructures(kingdom, land);
        for (Structure structure : extra) {
            structure.remove(new KingdomItemRemoveContext());
        }
        return extra;
    }

    public static List<Structure> getExtraStructures(Kingdom kingdom, Land land) {
        ArrayList<Structure> returnedStructures = new ArrayList<Structure>();
        int totalLimit = KingdomsConfig.Structures.TOTAL_LIMIT_PER_LAND.getManager().getInt();
        if (totalLimit > 0 && land.getStructures().size() >= totalLimit) {
            returnedStructures.addAll(land.getStructures().values());
            return returnedStructures;
        }
        for (Structure structure : land.getStructures().values()) {
            int totalSpecificCount;
            StructureStyle style = (StructureStyle)structure.getStyle();
            int structuresOfSameType = (int)land.getStructures().values().stream().filter(struct -> struct.getStyle() == style).count();
            int limitIndividualPerLand = style.getOption("limits", "per-land").getInt();
            if (limitIndividualPerLand > 0 && structuresOfSameType > 0 && structuresOfSameType >= limitIndividualPerLand) {
                returnedStructures.add(structure);
                continue;
            }
            int totalSpecificLimit = style.getOption("limits", "total").getInt();
            if (totalSpecificLimit <= 0 || (totalSpecificCount = kingdom.countStructures(struct -> struct.getStyle() == style)) < totalSpecificLimit) continue;
            returnedStructures.add(structure);
        }
        return returnedStructures;
    }

    public static void processStructureProperties(Land land, Structure structure, BlockFace facing) {
        land.getStructures().put(structure.getLocation(), structure);
        structure.spawnHolograms(land.getKingdom());
        structure.playSound("place");
        structure.displayParticle("place");
        StructureStyle type = (StructureStyle)structure.getStyle();
        Block block = structure.getBlock();
        XBlock.setType(block, type.getBlockMaterial(structure.getLevel()));
        XBlock.setDirection(block, facing);
    }

    public static void onStructureBreak(BlockBreakEvent event, KingdomPlayer kp, Structure structure, Land land) {
        Kingdom landKingdom = land.getKingdom();
        Player player = event.getPlayer();
        Kingdom kpKingdom = kp.getKingdom();
        if (!KingdomsPluginPermission.STRUCTURES_BUILD_BREAK.hasPermission((CommandSender)player, true) && landKingdom != null) {
            if (kpKingdom != null) {
                KLogger.debug((DebugNS)KingdomsDebug.STRUCTURE_BREAK, () -> "No permission but structure is in pacifist? " + landKingdom.isPacifist() + " and has attributes? " + landKingdom.hasAttribute(kpKingdom, (RelationAttribute)StandardRelationAttribute.MANAGE_STRUCTURES));
                if (!landKingdom.hasAttribute(kpKingdom, (RelationAttribute)StandardRelationAttribute.MANAGE_STRUCTURES)) {
                    if (!((StructureType)((StructureStyle)structure.getStyle()).getType()).isNexus() || player.getGameMode() == GameMode.CREATIVE && !KingdomsConfig.NEXUS_BREAK_CREATIVE.getBoolean()) {
                        KingdomsLang.OTHER_KINGDOMS_STRUCTURE_BREAK.sendError((CommandSender)player, new Object[0]);
                    } else if (!landKingdom.isPacifist()) {
                        YamlConfigAccessor section = KingdomsConfig.NEXUS_BREAK_ITEM.getManager().noDefault().getSection();
                        if (section == null || new ItemMatcher(section.getSection()).matches(player.getInventory().getItemInMainHand())) {
                            long cost = KingdomsConfig.NEXUS_BREAK_COST.getInt();
                            if (landKingdom.getResourcePoints() < cost) {
                                cost = landKingdom.getResourcePoints();
                            }
                            KingdomsLang.OTHER_KINGDOMS_NEXUS_BREAK.sendMessage((CommandSender)player, "rp", cost);
                            landKingdom.addResourcePoints(-cost);
                            kpKingdom.addResourcePoints(cost);
                        } else {
                            KingdomsLang.OTHER_KINGDOMS_NEXUS_BREAK_WRONG_ITEM.sendError((CommandSender)player, new Object[0]);
                        }
                    } else {
                        KingdomsLang.OTHER_KINGDOMS_NEXUS_BREAK_PACIFIST.sendError((CommandSender)player, new Object[0]);
                    }
                    event.setCancelled(true);
                } else if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
                    StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
                    event.setCancelled(true);
                }
            } else {
                KingdomsLang.OTHER_KINGDOMS_STRUCTURE_BREAK.sendError((CommandSender)player, new Object[0]);
                event.setCancelled(true);
            }
        }
        if (!KingdomsPluginPermission.NEXUS_REMOVE.hasPermission((CommandSender)player, true) && ((StructureType)((StructureStyle)structure.getStyle()).getType()).isNexus() && !KingdomsConfig.NEXUS_ALLOW_REMOVAL.getBoolean()) {
            KingdomsLang.NEXUS_CANT_BE_REMOVED.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
        if (event.isCancelled()) {
            return;
        }
        boolean toInv = KingdomsConfig.Structures.TO_INVENTORY_ON_BREAK.getManager().getBoolean();
        KingdomItemRemoveContext ctx = new KingdomItemRemoveContext();
        ctx.setCause((Event)event);
        ctx.setPlayer(kp);
        ctx.setDropsItem(!toInv);
        if (structure.remove(ctx).isCancelled()) {
            return;
        }
        KLogger.debug((DebugNS)KingdomsDebug.STRUCTURE_BREAK, () -> "Land kingdom is: " + landKingdom + " and permission " + KingdomsPluginPermission.STRUCTURES_BUILD_BREAK.hasPermission((CommandSender)player, true) + " with nexus permmission: " + KingdomsPluginPermission.NEXUS_REMOVE.hasPermission((CommandSender)player, true) + " and structure type: " + ((StructureStyle)structure.getStyle()).getType());
        event.setDropItems(false);
        if (toInv && ((StructureStyle)structure.getStyle()).hasItem()) {
            XItemStack.giveOrDrop(player, structure.getItem(landKingdom == null ? kpKingdom : landKingdom));
        }
    }

    public static void onStructureInteract(PlayerInteractEvent event, Structure structure) {
        Kingdom kingdom;
        Player player = event.getPlayer();
        if (player.isSneaking() && KingdomsConfig.Structures.DISABLE_SHIFT_CLICK.getManager().getBoolean()) {
            Material type = player.getInventory().getItemInMainHand().getType();
            if (type == Material.AIR || !type.isBlock()) {
                event.setUseInteractedBlock(Event.Result.DENY);
            }
            return;
        }
        Land land = structure.getLand();
        event.setCancelled(true);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (land.isClaimed() && !KingdomsPluginPermission.STRUCTURES_INTERACT.hasPermission((CommandSender)player, true) && !StandardRelationAttribute.MANAGE_STRUCTURES.hasAttribute(kingdom = kp.getKingdom(), land.getKingdom())) {
            KingdomsLang.OTHER_KINGDOMS_STRUCTURE_INTERACT.sendError((CommandSender)player, new Object[0]);
            return;
        }
        KingdomItemInteractEvent<Structure> structureEvent = new KingdomItemInteractEvent<Structure>(event, land, structure);
        Bukkit.getPluginManager().callEvent(structureEvent);
        if (structureEvent.isCancelled()) {
            return;
        }
        if (!land.isClaimed()) {
            KingdomsLang.OTHER_KINGDOMS_STRUCTURE_CAN_TAKE.sendError((CommandSender)player, new Object[0]);
            LandProtectionManager.openKingdomItemGUI(player, structure, structureEvent);
            return;
        }
        ((StructureType)((StructureStyle)structure.getStyle()).getType()).open(new KingdomItemGUIContext<Structure>(structureEvent));
    }
}

