/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.scheduler;

import java.time.Duration;
import java.util.concurrent.Executor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.kingdoms.dependencies.classpath.BootstrapProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.scheduler.AbstractJavaScheduler;
import org.kingdoms.utils.time.TimeUtils;

public class BukkitSchedulerAdapter
extends AbstractJavaScheduler {
    private final Executor sync;
    private final BukkitScheduler bukkitScheduler;
    private final Plugin plugin;

    public BukkitSchedulerAdapter(Kingdoms loader, BootstrapProvider bootstrapProvider) {
        super(bootstrapProvider);
        this.plugin = loader;
        this.bukkitScheduler = loader.getServer().getScheduler();
        this.sync = task -> {
            if (Kingdoms.get().isDisabling()) {
                return;
            }
            loader.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)loader.getLoader(), task);
        };
    }

    @Override
    public Executor sync() {
        return this.sync;
    }

    @Override
    public void syncLater(Runnable task, Duration startIn) {
        this.bukkitScheduler.scheduleSyncDelayedTask(this.plugin, task, TimeUtils.millisToTicks(startIn.toMillis()));
    }
}

