/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.services.Service;

public final class ServiceWorldEdit
implements Service {
    @Override
    public void enable() {
        WorldEdit.getInstance().getEventBus().register((Object)this);
    }

    private static void paste0(File file, SimpleLocation location) throws IOException, WorldEditException {
        ClipboardFormat format = ClipboardFormats.findByFile((File)file);
        try (ClipboardReader reader = format.getReader(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            Clipboard clipboard = reader.read();
            World world = BukkitAdapter.adapt((org.bukkit.World)location.getBukkitWorld());
            try (EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(world, -1);){
                Operation operation = new ClipboardHolder(clipboard).createPaste((Extent)editSession).to(BlockVector3.at((int)location.getX(), (int)location.getY(), (int)location.getZ())).ignoreAirBlocks(false).build();
                Operations.complete((Operation)operation);
            }
        }
    }

    @Subscribe
    public void onEdit(EditSessionEvent event) {
        Actor editor = event.getActor();
        if (editor == null || !editor.isPlayer()) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)editor.getUniqueId());
        Objects.requireNonNull(player, () -> "Actor " + editor + " for WorldEdit is a null player");
        if (player.isOp()) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom() || kp.isAdmin()) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        org.bukkit.World world = BukkitAdapter.asBukkitWorld((World)event.getWorld()).getWorld();
        AtomicInteger excluded = new AtomicInteger();
        event.setExtent((Extent)new KingdomsProtectionExtent(event.getExtent(), touchedLocation -> {
            Location bukkitLocation = BukkitAdapter.adapt((org.bukkit.World)world, (BlockVector3)touchedLocation);
            SimpleChunkLocation chunk = SimpleChunkLocation.of(bukkitLocation);
            if (!kingdom.isClaimed(chunk)) {
                excluded.incrementAndGet();
                return false;
            }
            return true;
        }));
        if (excluded.get() > 0) {
            KingdomsLang.WORLD_EDIT_EXCLUDED.sendError((CommandSender)player, "blocks", excluded.get());
        }
    }

    private static final class KingdomsProtectionExtent
    extends AbstractDelegateExtent {
        private final Function<BlockVector3, Boolean> filterFunction;

        protected KingdomsProtectionExtent(Extent extent, Function<BlockVector3, Boolean> excludeFunction) {
            super(extent);
            this.filterFunction = excludeFunction;
        }

        public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 location, T block) throws WorldEditException {
            if (!this.filterFunction.apply(location).booleanValue()) {
                return false;
            }
            return super.setBlock(location, block);
        }
    }
}

